<?php
/**
 * Reviews
 *
 * Shows reviews on the account page.
 */

defined( 'ABSPATH' ) || exit;

$customer_id = get_current_user_id();
$reviews = get_comments(array(
    'user_id' => $customer_id,
    'status' => 'approve',
    'type' => 'review',
    'post_type' => 'product'
));
?>
<section class="section-account">
    <?php wc_get_template('myaccount/account-header.php'); ?>
    <div class="account-tabs">
        <ul class="uk-tab uk-flex-center">
            <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>"><?php esc_html_e('Siparişlerim', 'leanfit'); ?></a></li>
            <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-account')); ?>"><?php esc_html_e('Üyelik Bilgilerim', 'leanfit'); ?></a></li>
            <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-address')); ?>"><?php esc_html_e('Adreslerim', 'leanfit'); ?></a></li>
            <li class="uk-active"><a href="<?php echo esc_url(wc_get_account_endpoint_url('reviews')); ?>"><?php esc_html_e('Yorumlarım', 'leanfit'); ?></a></li>
        </ul>

        <div class="custom-container">
            <div class="my-reviews uk-grid uk-flex-center" uk-grid>
                <div class="uk-width-6-12@l uk-width-11-12@m">
                    <?php if (empty($reviews)) : ?>
                        <!-- Eğer hiç review yok ise / no-reviews Start -->
                        <div class="no-reviews">
                            <div class="no-review-icon">
                                <span uk-icon="icon: icn-info"></span>
                            </div>
                            <div class="no-review-title"><?php esc_html_e('Henüz hiçbir ürünü incelememişsiniz.', 'leanfit'); ?></div>
                        </div>
                        <!-- no-reviews End -->
                    <?php else : ?>
                        <div class="review-list" id="review-list">
                            <?php foreach ($reviews as $review) : 
                                $product = wc_get_product($review->comment_post_ID);
                                if (!$product) continue;
                                
                                $rating = get_comment_meta($review->comment_ID, 'rating', true);
                                $review_images = get_comment_meta($review->comment_ID, 'review_images', true);
                                $title = get_comment_meta($review->comment_ID, 'comment_title', true);
                            ?>
                                <div class="review-item">
                                    <div class="uk-grid uk-grid-small uk-items-center">
                                        <div class="product-stars">
                                            <?php
                                            for ($i = 1; $i <= 5; $i++) {
                                                if ($i <= $rating) {
                                                    echo '<span uk-icon="icn-star-2" class="star filled"></span>';
                                                } else {
                                                    echo '<span uk-icon="icn-star-null-2" class="star"></span>';
                                                }
                                            }
                                            ?>
                                        </div>

                                        <div class="author-name">
                                            <?php 
                                            $author = get_user_by('id', $review->user_id);
                                            echo esc_html($author->display_name);
                                            ?>
                                        </div>
                                    </div>

                                    <div class="uk-grid-medium uk-items-center uk-grid" uk-grid="">
                                        <div class="uk-width-8-12@m uk-first-column">
                                            <div class="review-text">
                                                <h3><?php echo esc_html($title); ?></h3>
                                                <p><?php echo wp_kses_post($review->comment_content); ?></p>
                                            </div>
                                        </div>

                                        <?php if (!empty($review_images)) : ?>
                                        <div class="uk-width-4-12@m">
                                            <div class="review-images">
                                                <div class="uk-grid uk-flex-right@m uk-child-width-1-6@xl uk-child-width-1-5@l uk-child-width-1-4 uk-grid-xsmall uk-grid-match" uk-lightbox="">
                                                    <?php 
                                                    foreach ($review_images as $image) : 
                                                    ?>
                                                        <a href="<?php echo esc_url($image); ?>">
                                                            <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($author->display_name); ?>" />
                                                        </a>
                                                    <?php endforeach; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div> 
</section> 