<?php
/**
 * Lost password confirmation
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.2.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_lost_password_confirmation_message' );
?>

<script>
    if (window.innerWidth <= 768) {
        document.querySelector(".header-all").classList.add("header-relative");
    }
</script>
<style>
    @media only screen and (max-width: 768px) {
        .header-all {
            background-color: #ffffff;
        }

        body {
            background: #ffffff;
        }
    }

    footer { 
        display: none;
    }
</style>
<section class="section-login m-center">
    <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1" uk-slideshow="animation: fade">
        <div class="uk-slideshow-items">
            <div>
                <div class="uk-position-relative uk-overflow-hidden">
                    <div class="uk-position-relative uk-position-z-index-negative banner-image uk-visible@m" 
                         style="background-image: url('<?php bloginfo('template_url'); ?>/assets/image/intro.jpg');"></div>
                    <div class="uk-position-relative uk-position-z-index-negative banner-mobile-image uk-hidden@m"></div>

                    <div class="banner-contents uk-position-absolute uk-position-z-index-2">
                        <div class="custom-container">
                            <div class="uk-grid align-items-center uk-flex-center">
                                <div class="uk-width-3-11@m">
                                    <div class="login-form">
                                        <div class="uk-width-1-1 uk-flex uk-flex-center icon-check">
                                            <span class="uk-icon" uk-icon="icon: icn-check-success"></span>
                                        </div>

                                        <div class="uk-text-center">
                                            <div class="welcome"><?php esc_html_e('Tebrikler', 'leanfit'); ?></div>
                                            <div class="intro-success"><?php esc_html_e('İşleminiz başarıyla tamamlandı.', 'leanfit'); ?></div>
                                            <p><?php esc_html_e('Gerekli bilgiler e-posta adresinize gönderildi.', 'leanfit'); ?></p>

                                            <div class="uk-text-center uk-margin-medium-top">
                                                <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="uk-button login-button"><?php esc_html_e('Giriş Yap', 'leanfit'); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
do_action( 'woocommerce_after_lost_password_confirmation_message' );
