<?php
/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.2.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_lost_password_form' );
?>

<script>
    if (window.innerWidth <= 768) {
        document.querySelector(".header-all").classList.add("header-relative");
    }
</script>
<style>
    @media only screen and (max-width: 768px) {
        .header-all {
            background-color: #ffffff;
        }

        body {
            background: #ffffff;
        }
    }

    footer { 
        display: none;
    }
</style>
<section class="section-login">
    <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1" uk-slideshow="animation: fade">
        <div class="uk-slideshow-items">
            <div>
                <div class="uk-position-relative uk-overflow-hidden">
					<div class="uk-position-relative uk-position-z-index-negative banner-image uk-visible@m" 
						 style="background-image: url('<?php bloginfo('template_url'); ?>/assets/image/intro.jpg');"></div>
					<div class="uk-position-relative uk-position-z-index-negative banner-mobile-image uk-hidden@m"></div>

                    <div class="banner-contents uk-position-absolute uk-position-z-index-2">
                        <div class="custom-container">
                            <div class="uk-grid align-items-center">
                                <div class="uk-width-3-12@xxl uk-width-4-11@m">
                                    <form method="post" class="woocommerce-ResetPassword lost_reset_password login-form">
                                        <h1 class="uk-flex align-items-center">
                                            <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="uk-margin-remove uk-padding-remove">
                                                <span class="uk-flex" uk-icon="icon: icn-arrow-left;"></span>
                                            </a> &nbsp;<?php esc_html_e('Şifremi Unuttum', 'woocommerce'); ?>
                                        </h1>
                                        <p><?php echo apply_filters('woocommerce_lost_password_message', esc_html__('Şifrenizi mi unuttunuz? Yeniden erişim kazanmak için hesabınıza bağlı e-posta adresini doğrulayın.', 'woocommerce')); ?></p>

                                        <div class="uk-margin form-floating">
                                            <input class="uk-input" type="text" name="user_login" id="user_login" placeholder=" " autocomplete="username" required aria-required="true" />
                                            <label for="user_login"><?php esc_html_e('Kullanıcı Adı / E-posta', 'leanfit'); ?></label>
                                        </div>

                                        <?php do_action('woocommerce_lostpassword_form'); ?>

                                        <div class="uk-text-center">
                                            <input type="hidden" name="wc_reset_password" value="true" />
                                            <?php wp_nonce_field('lost_password', 'woocommerce-lost-password-nonce'); ?>
                                            <button type="submit" class="uk-button login-button" value="<?php esc_attr_e('Şifremi Sıfırla', 'leanfit'); ?>"><?php esc_html_e('Şifremi Sıfırla', 'leanfit'); ?></button>
                                        </div>
                                    </form>
                                </div>
                                <div class="uk-width-2-11@xxl uk-width-1-11@m uk-visible@m"></div>
								<div class="uk-width-3-10@xxl uk-width-4-10@xl uk-width-4-11@m uk-visible@m uk-light">
                                    <h2><?php esc_html_e('Fitness Yolculuğunuzu Hızlandırın', 'leanfit'); ?></h2>
                                    <h3 class=""><?php esc_html_e('Sınırlı Bir Süre İçin Tüm Doğal Protein Tozlarında %20 İndirim!', 'leanfit'); ?></h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
do_action('woocommerce_after_lost_password_form');
