<?php
/**
 * Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/addresses.php.
 */

defined( 'ABSPATH' ) || exit;

// Include the account header
wc_get_template('myaccount/account-header.php');

$customer_id = get_current_user_id();

if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
    $get_addresses = apply_filters(
        'woocommerce_my_account_get_addresses',
        array(
            'billing'  => __( 'Fatura Adresi', 'leanfit' ),
            'shipping' => __( 'Teslimat Adresi', 'leanfit' ),
        ),
        $customer_id
    );
} else {
    $get_addresses = apply_filters(
        'woocommerce_my_account_get_addresses',
        array(
            'billing' => __( 'Fatura Adresi', 'leanfit' ),
        ),
        $customer_id
    );
}

$oldcol = 1;
$col    = 1;
?>
asfsa fa
<div class="account-tabs">
    <ul class="uk-tab uk-flex-center">
        <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>"><?php esc_html_e('Siparişlerim', 'leanfit'); ?></a></li>
        <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-account')); ?>"><?php esc_html_e('Üyelik Bilgilerim', 'leanfit'); ?></a></li>
        <li class="uk-active"><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-address')); ?>"><?php esc_html_e('Adreslerim', 'leanfit'); ?></a></li>
        <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('reviews')); ?>"><?php esc_html_e('Yorumlarım', 'leanfit'); ?></a></li>
    </ul>

    <div class="addresses">
        <div class="custom-container">
            <div class="address-items">
                <?php foreach ( $get_addresses as $name => $address_title ) : ?>
                    <?php
                        $address = wc_get_account_formatted_address( $name );
                        $col     = $col * 2;
                        $oldcol  = $oldcol * 2;
                    ?>
                    <div class="address-item">
                        <div class="address-header">
                            <h3><?php echo esc_html( $address_title ); ?></h3>
                            <a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', $name ) ); ?>" class="edit">
                                <?php echo esc_html__('Düzenle', 'leanfit'); ?>
                            </a>
                        </div>
                        <div class="address-content">
                            <?php if ( $address ) : ?>
                                <address>
                                    <?php echo wp_kses_post( $address ); ?>
                                </address>
                            <?php else : ?>
                                <p class="woocommerce-Message"><?php echo esc_html__( 'Bu adres türü için adres bilgileriniz yok.', 'leanfit' ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) : ?>
                <div class="add-new-address">
                    <a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', 'shipping' ) ); ?>" class="uk-button uk-button-primary">
                        <?php esc_html_e( 'Yeni Adres Ekle', 'leanfit' ); ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div> 
</section> 