<?php
/**
 * Checkout Payment Section
 *
 * @package Leanfit
 */

defined('ABSPATH') || exit;

if (!is_ajax()) {
    do_action('woocommerce_review_order_before_payment');
}
?>

<div id="payment" class="woocommerce-checkout-payment">
    <?php if (WC()->cart->needs_payment()) : ?>
        <ul class="wc_payment_methods payment_methods methods">
            <?php
            if (!empty($available_gateways)) {
                foreach ($available_gateways as $gateway) {
                    wc_get_template('checkout/payment-method.php', array('gateway' => $gateway));
                }
            } else {
                echo '<li class="woocommerce-notice woocommerce-notice--info woocommerce-info">';
                echo apply_filters('woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__('Üzgünüz, mevcut ödeme yöntemleri yok. Lütfen yardım için bize ulaşın veya alternatif düzenlemler yapmak istiyorsanız.', 'leanfit') : esc_html__('Lütfen üzerinde çalışıyoruz.', 'leanfit'));
                echo '</li>';
            }
            ?>
        </ul>
    <?php endif; ?>

    <div class="form-row place-order">
        <noscript>
            <?php
            printf(
                esc_html__('Tarayıcınız JavaScript desteği sağlamıyor, ya da devre dışı bırakıldı. Lütfen ödeme yöntemlerini güncelleyiniz.', 'leanfit'),
                '<em>',
                '</em>'
            );
            ?>
            <br/><button type="submit" class="button alt" name="woocommerce_checkout_update_totals" value="<?php esc_attr_e('Ödeme yöntemlerini güncelle', 'leanfit'); ?>"><?php esc_html_e('Ödeme yöntemlerini güncelle', 'leanfit'); ?></button>
        </noscript>

        <?php wc_get_template('checkout/terms.php'); ?>

        <?php do_action('woocommerce_review_order_before_submit'); ?>

        <?php echo apply_filters('woocommerce_order_button_html', '<button type="submit" class="button alt" name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr($order_button_text) . '" data-value="' . esc_attr($order_button_text) . '">' . esc_html($order_button_text) . '</button>'); ?>

        <?php do_action('woocommerce_review_order_after_submit'); ?>

        <?php wp_nonce_field('woocommerce-process_checkout', 'woocommerce-process-checkout-nonce'); ?>
    </div>
</div>

<?php
if (!is_ajax()) {
    do_action('woocommerce_review_order_after_payment');
}
?> 