<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.9.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_cart' ); ?>



<section class="section-checkout">
		<div class="custom-container uk-margin-medium-top uk-margin-medium-bottom">
			<div class="uk-grid-large" uk-grid>
				<!-- Main Content -->
				<div class="uk-width-8-11@l">
					<!-- Basket Section -->
					<section>
						<h2 class="section-title uk-margin-remove-bottom"><?php esc_html_e('Sepet', 'woocommerce'); ?></h2>
						<div id="order_review" class="woocommerce-checkout-review-order">
							<?php
							foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
								$_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);

								if ($_product && $_product->exists() && $cart_item['quantity'] > 0) {
									$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
									
									// Ürün fiyatlarını hesapla
									$regular_price = $_product->get_regular_price();
									$sale_price = $_product->get_sale_price();
									$current_price = $_product->get_price();
									
									// İndirim oranını hesapla
									$discount_percentage = 0;
									if ($regular_price > 0 && $sale_price) {
										$discount_percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
									}
							?>

							<div class="uk-card uk-card-small uk-border-0 checkout-cart-item">
								<div class="uk-card-body uk-padding-remove">
									<div class="uk-grid-xsmall uk-flex-middle uk-flex-between uk-grid" uk-grid="">
										<div class="uk-width-5-8@xxl uk-width-5-9@l uk-width-7-11 uk-first-column">
											<div class="uk-grid uk-flex-middle uk-grid-xsmall uk-width-1-1">
												<div class="uk-width-auto">
													<?php if ($product_permalink) : ?>
														<a href="<?php echo esc_url($product_permalink); ?>">
															<?php echo $_product->get_image('woocommerce_thumbnail', ['class' => 'uk-border-rounded']); ?>
														</a>
													<?php else : ?>
														<?php echo $_product->get_image('woocommerce_thumbnail', ['class' => 'uk-border-rounded']); ?>
													<?php endif; ?>
												</div>
												<div class="uk-width-8-9@xxl uk-width-7-9@xl uk-width-6-9">
													<div class="uk-grid uk-grid-small uk-flex-between align-items-center">
														<div class="uk-width-3-5@m">
															<h3 class="uk-h4 uk-margin-remove checkout-product-name">
																<?php echo wp_kses_post(apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key)); ?>
															</h3>
														</div>
														<div class="uk-width-2-5@m">
															<div class="quantity-control">
																<span class="checkout-quantity"><?php esc_html_e('Adet', 'leanfit'); ?></span>
																<div class="uk-button-group quantity-buttons" data-id="<?php echo esc_attr($_product->get_id()); ?>" data-cart-key="<?php echo esc_attr($cart_item_key); ?>">
																	<button type="button" class="uk-button uk-button-small qty-btn minus">-</button>
																	<input type="text" 
																		class="uk-button uk-button-small qty-value has" 
																		value="<?php echo esc_attr($cart_item['quantity']); ?>"
																		data-cart-key="<?php echo esc_attr($cart_item_key); ?>"
																		readonly
																	>
																	<button type="button" class="uk-button uk-button-small qty-btn plus">+</button>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div class="uk-width-3-11@xxl uk-width-4-11@xl uk-width-3-11 uk-text-right">
											<div class="uk-grid uk-flex-center@m uk-flex-between uk-grid-small align-items-center">
												<?php if ($sale_price) : ?>
													<span class="order-price"><?php echo wc_price($sale_price); ?></span>
													<span class="order-discount-price"><?php echo wc_price($regular_price); ?></span>
													<?php if ($discount_percentage > 0) : ?>
														<span class="order-discount-rate">%<?php echo $discount_percentage; ?> <?php esc_html_e('İndirim', 'leanfit'); ?></span>
													<?php endif; ?>
												<?php else : ?>
													<span class="order-price"><?php echo wc_price($current_price); ?></span>
												<?php endif; ?>
											</div>
										</div>
										<div class="uk-width-auto uk-text-right cart-remove">
											<?php
											echo apply_filters('woocommerce_cart_item_remove_link', sprintf(
												'<a href="%s" aria-label="%s" data-product_id="%s" data-product_sku="%s"><span uk-icon="icon: icn-close"></span></a>',
												esc_url(wc_get_cart_remove_url($cart_item_key)),
												"",
												esc_attr($_product->get_id()),
												esc_attr($_product->get_sku())
											), $cart_item_key);
											?>
										</div>
									</div>
								</div>
							</div>
							<?php
								}
							}
							?>
							<?php //do_action('woocommerce_checkout_order_review'); ?>
						</div>
					</section>

<!-- Shipping Section -->
<section class="section-checkout-shipping">
	<h2 class="section-title uk-margin-remove-bottom"><?php esc_html_e('Kargo', 'leanfit'); ?></h2>
	<div class="uk-card uk-card-small uk-border-0">
		<div class="uk-card-body uk-padding-remove">
			<?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) : ?>
				<?php do_action('woocommerce_review_order_before_shipping'); ?>
				<?php 
					$packages = WC()->shipping()->get_packages();
					if (!empty($packages)) {
						foreach ($packages as $i => $package) {
							$available_methods = $package['rates'];
							if (!empty($available_methods)) {
								foreach ($available_methods as $method) {
									$method_id = $method->get_id();
									$method_title = $method->get_label();
									$method_cost = $method->get_cost();
									$shipping_logo = '';
									
									// Kargo firmasına göre logo belirleme
									if (strpos(strtolower($method_title), 'yurtiçi') !== false) {
										$shipping_logo = get_template_directory_uri() . '/assets/image/yurtici.jpg';
									} else {
										$shipping_logo = get_template_directory_uri() . '/assets/image/placeholder.png';
									}
									// Diğer kargo firmaları için logo eklenebilir
									?>
									<div class="uk-flex uk-flex-middle">
										<input type="radio" 
											   name="shipping_method[<?php echo esc_attr($i); ?>]" 
											   id="shipping_method_<?php echo esc_attr($i); ?>_<?php echo esc_attr($method->get_id()); ?>" 
											   value="<?php echo esc_attr($method->get_id()); ?>" 
											   class="uk-hidden shipping-method" 
											   data-index="<?php echo esc_attr($i); ?>"
											   <?php checked($method->get_id(), WC()->session->get('chosen_shipping_methods')[$i] ?? ''); ?> />
										<label for="shipping_method_<?php echo esc_attr($i); ?>_<?php echo esc_attr($method->get_id()); ?>">
											<?php if ($shipping_logo) : ?>
												<img src="<?php echo esc_url($shipping_logo); ?>" width="48" height="48" alt="<?php echo esc_attr($method_title); ?>" class="uk-margin-medium-right <?php echo checked($method->get_id(), WC()->session->get('chosen_shipping_methods')[$i] ?? '', false) ? 'uk-border-1' : ''; ?>">
											<?php endif; ?>
										</label>
										<label class="uk-flex uk-flex-middle" for="shipping_method_<?php echo esc_attr($i); ?>_<?php echo esc_attr($method->get_id()); ?>">
											<strong class="uk-margin-medium-right"><?php echo esc_html($method_title); ?></strong>
											<?php 
											$available_methods = WC()->shipping()->get_packages()[0]['rates'] ?? [];
											if (count($available_methods) === 1) : ?>
												<span><?php echo esc_html__('Standart Kargo', 'leanfit'); ?></span>
											<?php endif; ?>
											<?php /*if ($method_cost > 0) : ?>
												<span class="uk-margin-small-left">(<?php echo wc_price($method_cost); ?>)</span>
											<?php endif; */ ?>
										</label>
									</div>
									<?php
								}
							}
						}
					}
				?>
				<?php do_action('woocommerce_review_order_after_shipping'); ?>
			<?php endif; ?>
		</div>
	</div>
</section>
				</div>

				<!-- Summary Section -->
				<div class="uk-width-3-11@l">
					<section class="section-checkout-summary">
						<div class="uk-border-0">
							<div class="uk-card-body uk-padding-remove">
								<h2 class="section-title uk-margin-remove uk-visible@m"><?php esc_html_e('Özet', 'leanfit'); ?></h2>

								<!-- Coupon Section -->
								<div class="section-checkout-coupon">
									<?php if (wc_coupons_enabled()) : ?>
										<div class="coupon-input">
											<div class="uk-flex uk-flex-between uk-inline uk-width-1-1 align-items-center">
												<input type="text" name="coupon_code" class="uk-input" id="cart-input-coupon" value="" placeholder="<?php esc_attr_e('Kupon Kodu Kullan', 'leanfit'); ?>" />
												<button type="button" class="uk-button add-button" name="apply_coupon" id="cart-add-coupon">
													<span uk-icon="icon: icn-plus"></span>
												</button>
											</div>
											<div id="cart-coupon-message-container"></div>
										</div>
										<?php wp_nonce_field('apply-coupon', 'cart-coupon-nonce'); ?>
										<?php 
											$coupons = WC()->cart->get_coupons();
											if (!empty($coupons)) :
											?>
										<div class="coupon-list">
											<?php 
												foreach ($coupons as $code => $coupon) :
											?>
												<div class="coupon-item" id="cart-coupon-<?php echo esc_attr(sanitize_title($code)); ?>">
													<div class="uk-flex uk-flex-between uk-grid-small">
														<div class="coupon-text"><?php echo esc_html($code); ?></div>
														<div class="coupon-cancel">
															<a href="javascript:void(0)" class="cart-remove-coupon" data-coupon="<?php echo esc_attr($code); ?>">
																<span uk-icon="icon: icn-close"></span>
															</a>
														</div>
													</div>
												</div>
											<?php 
												endforeach;?>
										</div>
										<?php endif; ?>
									<?php endif; ?>
								</div>

								<!-- Order Summary -->
								<div class="uk-margin-small-top uk-margin-medium-bottom summary-details uk-visible@m">
									<div class="uk-flex uk-flex-between uk-margin-small-bottom">
										<span><?php esc_html_e('Toplam Tutar', 'leanfit'); ?></span>
										<span><?php wc_cart_totals_subtotal_html(); ?></span>
									</div>

									<?php if (WC()->cart->needs_shipping()) : ?>
									<div class="uk-flex uk-flex-between uk-margin-small-bottom">
										<span><?php esc_html_e('Kargo', 'leanfit'); ?></span>
										<?php if (WC()->cart->get_shipping_total() > 0) : ?>
											<span><?php echo wc_price(WC()->cart->get_shipping_total()); ?></span>
										<?php else : ?>
											<span><?php esc_html_e('Ücretsiz', 'leanfit'); ?></span>
										<?php endif; ?>
									</div>
									<?php endif; ?>
									
									<?php if (WC()->cart->get_coupons()) : ?>
									<div class="uk-flex uk-flex-between uk-margin-small-bottom uk-text-danger">
										<span class="lean-text-red"><?php esc_html_e('Kupon', 'leanfit'); ?></span>
										<span class="lean-text-red">-<?php 
											$discount_amount = 0;
											foreach (WC()->cart->get_coupons() as $code => $coupon) {
												$discount_amount += WC()->cart->get_coupon_discount_amount($code);
											}
											echo wc_price($discount_amount);
										?></span>
									</div>
									<?php endif; ?>
									
									<?php 
									// İndirim oranını hesapla
									$subtotal = WC()->cart->get_subtotal();
									$total = WC()->cart->get_total('edit');
									$shipping_total = WC()->cart->get_shipping_total();
									$total_without_shipping = $total - $shipping_total;
									$discount_percentage = 0;
									
									if ($subtotal > 0 && $total_without_shipping < $subtotal) {
										$discount_percentage = round((($subtotal - $total_without_shipping) / $subtotal) * 100);
									}
									
									if ($discount_percentage > 0) :
									?>
									<div class="uk-flex uk-flex-between uk-margin-small-bottom">
										<span class="lean-text-red"><?php esc_html_e('İndirim', 'leanfit'); ?></span>
										<span class="lean-text-red">%<?php echo esc_html($discount_percentage); ?></span>
									</div>
									<?php endif; ?>
									
									<div class="uk-flex uk-flex-between checkout-total-price">
										<span><?php esc_html_e('Ödenecek Tutar', 'leanfit'); ?></span>
										<span><?php 
											ob_start();
											wc_cart_totals_order_total_html();
											$total_html = ob_get_clean();
											echo wp_strip_all_tags($total_html);
										?></span>
									</div>
								</div>

								<div class="uk-visible@m">
									<a href="<?php echo wc_get_checkout_url(); ?>" class="uk-button lean-button-red uk-width-1-1 continue-btn" id="place_order"><?php esc_html_e('Devam Et', 'leanfit'); ?></a>
								</div>
								<!-- End Order Summary -->
							</div>
						</div>
					</section>
				</div>
			</div>
		</div>


		<section class="section-checkout-summary summary-mobile uk-hidden@m">
			<div class="uk-text-center uk-padding-small-bottom">
				<button type="button" class="uk-button uk-button-text summary-arrow" id="summary-arrow">
					<span uk-icon="icon: icn-summary-arrow"></span>
				</button>
			</div>

			<div class="uk-margin-small-top uk-margin-medium-bottom summary-details uk-hidden" id="mobile-summary-details">
				<div class="uk-flex uk-flex-between uk-margin-small-bottom">
					<span><?php esc_html_e('Toplam Tutar', 'leanfit'); ?></span>
					<span><?php wc_cart_totals_subtotal_html(); ?></span>
				</div>

				<?php if (WC()->cart->needs_shipping() && WC()->cart->get_shipping_total() > 0) : ?>
				<div class="uk-flex uk-flex-between uk-margin-small-bottom">
					<span><?php esc_html_e('Kargo', 'leanfit'); ?></span>
					<span><?php echo wc_price(WC()->cart->get_shipping_total()); ?></span>
				</div>
				<?php endif; ?>

				<?php if (WC()->cart->get_coupons()) : ?>
				<div class="uk-flex uk-flex-between uk-margin-small-bottom uk-text-danger">
					<span class="lean-text-red"><?php esc_html_e('Kupon', 'leanfit'); ?></span>
					<span class="lean-text-red">-<?php 
						$discount_amount = 0;
						foreach (WC()->cart->get_coupons() as $code => $coupon) {
							$discount_amount += WC()->cart->get_coupon_discount_amount($code);
						}
						echo wc_price($discount_amount);
					?></span>
				</div>
				<?php endif; ?>
	
				<?php 
				// İndirim oranını hesapla
				$subtotal = WC()->cart->get_subtotal();
				$total = WC()->cart->get_total('edit');
				$discount_percentage = 0;
				
				if ($subtotal > 0 && $total < $subtotal) {
					$discount_percentage = round((($subtotal - $total) / $subtotal) * 100);
				}
				
				if ($discount_percentage > 0) :
				?>
				<div class="uk-flex uk-flex-between uk-margin-small-bottom">
					<span class="lean-text-red"><?php esc_html_e('İndirim', 'leanfit'); ?></span>
					<span class="lean-text-red">%<?php echo esc_html($discount_percentage); ?></span>
				</div>
				<?php endif; ?>
				<hr>
			</div>

			<div class="uk-padding-24 uk-padding-remove-top uk-grid uk-grid-xsmall uk-flex-between align-items-center uk-child-width-1-2">
				<div class="checkout-total-price">
					<span><?php esc_html_e('Ödenecek Tutar', 'leanfit'); ?></span>
					<span><?php 
						ob_start();
						wc_cart_totals_order_total_html();
						$total_html = ob_get_clean();
						echo wp_strip_all_tags($total_html);
					?></span>
				</div>
				<div>
					<a href="<?php echo wc_get_checkout_url(); ?>" class="uk-button lean-button-red uk-width-1-1 continue-btn" id="place_order_mobile"><?php esc_html_e('Devam Et', 'leanfit'); ?></a>
				</div>
			</div>
		</section>
		
	</section>




	<script>
    document.addEventListener("DOMContentLoaded", function () {
        const summaryButton = document.getElementById("summary-arrow");
        const summaryDetails = document.getElementById("mobile-summary-details");
        const icon = summaryButton.querySelector("span[uk-icon]");

        summaryButton.addEventListener("click", function () {
            summaryDetails.classList.toggle("uk-hidden");
            icon.style.transform = summaryDetails.classList.contains("uk-hidden") ? "rotate(0deg)" : "rotate(180deg)";
        });

        // Kupon input kontrolü
        document.getElementById("cart-input-coupon").addEventListener("keyup", function () {
            document.getElementById("cart-add-coupon").style.opacity = this.value !== "" ? "1" : "0";
        });

        // Miktar güncelleme işlemleri
        document.querySelectorAll(".quantity-buttons").forEach((container) => {
            const minusBtn = container.querySelector(".minus");
            const plusBtn = container.querySelector(".plus");
            const qtyInput = container.querySelector(".qty-value");
            const productId = container.getAttribute('data-id');
            const cartKey = container.getAttribute('data-cart-key');

            function updateQuantity(newQty) {
                if (newQty >= 1) {
                    container.style.opacity = '0.5';

					
					if (productId > 0) {
						jQuery.ajax({
							url: ajaxurl,
							type: 'POST',
							data: {
								action: 'update_cart_item_quantity',
								product_id: productId,
								quantity: newQty
							},
							success: function(response) {
								console.log(response);
								if(response.success) {
									window.location.reload();
								}
							}
						});
					}

                    
                    /*jQuery.ajax({
                        url: wc_cart_params.wc_ajax_url.toString().replace('%%endpoint%%', 'update_order_review'),
                        type: 'POST',
                        data: {
                            security: wc_cart_params.update_order_review_nonce,
                            cart_item_key: cartKey,
                            quantity: newQty
                        },
                        success: function(response) {
                            window.location.reload();
                        },
                        error: function(xhr, status, error) {
                            console.error('Quantity update error:', error);
                            container.style.opacity = '1';
                        }
                    });*/
                }
            }

            minusBtn.addEventListener("click", () => {
                const currentValue = parseInt(qtyInput.value);
                if (currentValue > 1) {
                    updateQuantity(currentValue - 1);
                }
            });

            plusBtn.addEventListener("click", () => {
                const currentValue = parseInt(qtyInput.value);
                updateQuantity(currentValue + 1);
            });
        });
    });
</script>

<script>
jQuery(document).ready(function($) {

    // Kargo metodu değiştiğinde AJAX ile güncelle
    $(document).on('change', 'input.shipping-method', function() {
        var $input = $(this);
        var method = $input.val();
        var index = $input.data('index');

        $.ajax({
            url: wc_cart_params.wc_ajax_url.toString().replace('%%endpoint%%', 'update_shipping_method'),
            type: 'POST',
            data: {
                shipping_method: {
                    [index]: method
                },
                security: wc_cart_params.update_order_review_nonce
            },
            success: function(response) {
                window.location.reload();
            },
            error: function(xhr, status, error) {
                console.error('Shipping method update error:', error);
                window.location.reload();
            }
        });
    });
});
</script>