<?php get_header(); ?>

    <?php
    while (have_posts()) : the_post();
        // Mevcut sayfanın ID'sini al
        $page_id = get_the_ID();
        
        // Üst blokları getir
        $top_blocks = get_post_meta($page_id, 'page_top_blocks', true);
        if (is_array($top_blocks) && !empty($top_blocks)) {
            foreach ($top_blocks as $block_id) {
                $block = get_block_by_id($block_id);
                if ($block) {
                    $block_slug = sanitize_title($block->name);
                    echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
                }
            }
        }

        // Sayfa içeriği
        if (get_the_content()) {
            echo '<div class="container">';
            the_content();
            echo '</div>';
        }

        // Orta blokları getir
        $middle_blocks = get_post_meta($page_id, 'page_middle_blocks', true);
        if (is_array($middle_blocks) && !empty($middle_blocks)) {
            foreach ($middle_blocks as $block_id) {
                $block = get_block_by_id($block_id);
                if ($block) {
                    $block_slug = sanitize_title($block->name);
                    echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
                }
            }
        }

        // Alt blokları getir
        $bottom_blocks = get_post_meta($page_id, 'page_bottom_blocks', true);
        if (is_array($bottom_blocks) && !empty($bottom_blocks)) {
            foreach ($bottom_blocks as $block_id) {
                $block = get_block_by_id($block_id);
                if ($block) {
                    $block_slug = sanitize_title($block->name);
                    echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
                }
            }
        }
    endwhile;
    ?>

<?php get_footer(); ?>