<?php get_header(); ?>
<script>document.querySelector(".header-all").classList.add("header-relative");</script>

    <?php
    $page_id = get_the_ID();

    while (have_posts()) : the_post();
        // WooCommerce checkout ve cart sayfası kontrolü
        if (is_checkout()) {
            // WooCommerce checkout içeriğini göster
            echo do_shortcode('[woocommerce_checkout]');
        } elseif (is_cart()) {
            // WooCommerce cart içeriğini göster
            echo do_shortcode('[woocommerce_cart]');
        } else {
            // Normal sayfa içeriği için standart akış
            // Üst blokları getir
            $top_blocks = get_post_meta($page_id, 'page_top_blocks', true);
            if (is_array($top_blocks) && !empty($top_blocks)) {
                foreach ($top_blocks as $block_id) {
                    $block = get_block_by_id($block_id);
                    if ($block) {
                        $block_slug = sanitize_title($block->name);
                        echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
                    }
                }
            }

            // Sayfa içeriği
            if (get_the_content()) {
                echo '<div class="default-page">';
                    echo '<div class="custom-container">';
                        the_content();
                    echo '</div>';
                echo '</div>';
            }

            // Orta blokları getir
            $middle_blocks = get_post_meta($page_id, 'page_middle_blocks', true);
            if (is_array($middle_blocks) && !empty($middle_blocks)) {
                foreach ($middle_blocks as $block_id) {
                    $block = get_block_by_id($block_id);
                    if ($block) {
                        $block_slug = sanitize_title($block->name);
                        echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
                    }
                }
            }

            // Alt blokları getir
            $bottom_blocks = get_post_meta($page_id, 'page_bottom_blocks', true);
            if (is_array($bottom_blocks) && !empty($bottom_blocks)) {
                foreach ($bottom_blocks as $block_id) {
                    $block = get_block_by_id($block_id);
                    if ($block) {
                        $block_slug = sanitize_title($block->name);
                        echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
                    }
                }
            }
        }
    endwhile;
    ?>

<?php get_footer(); ?>

<script>
	document.addEventListener('DOMContentLoaded', function() {
		const ulElements = document.querySelectorAll('ul.wp-block-list');
		ulElements.forEach(function(ul) {
			ul.classList.remove('wp-block-list');
			ul.classList.add('uk-list', 'uk-list-disc');
		});
	});
</script>