<?php

if (! function_exists('limit')) {
    /**
     * Translate the given message.
     *
     * @param $value
     * @param int $limit
     * @param string $end
     * @return string
     */
    function limit($value, $limit = 100, $end = '...') {
        if (mb_strwidth($value, 'UTF-8') <= $limit) {
            return $value;
        }

        return rtrim(mb_strimwidth($value, 0, $limit, '', 'UTF-8')).$end;
    }
}

if (! function_exists('price_format')) {
    /**
     * Translate the given message.
     *
     * @param $value
     * @return string
     */
    function price_format($value) {
        return number_format((float)$value, 2, ",", ".") . " " . get_woocommerce_currency_symbol();
    }
}


if (! function_exists('get_attachment_id_by_url')) {
    function get_attachment_id_by_url($url) {
        global $wpdb;

        $upload_dir_paths = wp_upload_dir();
        $url = str_replace($upload_dir_paths['baseurl'], '', $url);

        $query = "
            SELECT ID 
            FROM {$wpdb->posts}
            WHERE guid LIKE '%{$url}' 
            AND post_type = 'attachment'
        ";

        $id = $wpdb->get_var($query);

        return $id;
    }

//    $image_id = get_attachment_id_by_url($item["image"]);
//
//    if ($image_id) {
//        $full_url = wp_get_attachment_image_url($image_id, 'full');
//        $medium_url = wp_get_attachment_image_url($image_id, 'medium');
//        $large_url = wp_get_attachment_image_url($image_id, 'large');
//
//        $image =  '<img src="' . $full_url . '" srcset="' . $item["mobile_image"] . ' 767w, ' . $large_url . ' 1024w" sizes="(max-width: 600px) 100vw, 1024px" class="uk-width-1-1 uk-transition-scale-up uk-transition-opaque" alt="image description" />';
//    }
}
