<?php

function add_block_list_to_page_editor() {
    // Üst Bloklar
    add_meta_box(
        'page_top_blocks',
        'Üst Bloklar',
        'render_page_blocks_metabox',
        ['post', 'page'],
        'normal',
        'high',
        ['position' => 'top']
    );

    // Orta Bloklar
    add_meta_box(
        'page_middle_blocks',
        'Orta Bloklar',
        'render_page_blocks_metabox',
        ['post', 'page'],
        'normal',
        'high',
        ['position' => 'middle']
    );

    // Alt Bloklar
    add_meta_box(
        'page_bottom_blocks',
        'Alt Bloklar',
        'render_page_blocks_metabox',
        ['post', 'page'],
        'normal',
        'high',
        ['position' => 'bottom']
    );
}

function render_page_blocks_metabox($post, $metabox) {
    $position = $metabox['args']['position'];
    $selected_blocks = get_post_meta($post->ID, 'page_' . $position . '_blocks', true);
    if (!is_array($selected_blocks)) {
        $selected_blocks = [];
    }

    // Tüm blokları getir
    global $wpdb;
    $table_name = $wpdb->prefix . 'blocks';
    $all_blocks = $wpdb->get_results("SELECT * FROM $table_name");
    ?>
    <div class="metabox-container" style="display: flex; gap: 20px;">
        <!-- Sol taraf - Seçili bloklar -->
        <div class="selected-blocks" style="flex: 1;">
            <ul class="sortable-blocks" data-position="<?php echo esc_attr($position); ?>">
                <?php
                foreach ($selected_blocks as $block_id) {
                    $block = get_block_by_id($block_id);
                    if ($block) {
                        echo '<li class="block-item" data-block-id="' . esc_attr($block->id) . '">';
                        echo '<span class="block-title">' . esc_html($block->name) . '</span>';
                        echo '<button type="button" class="remove-block">×</button>';
                        echo '<input type="hidden" name="page_' . esc_attr($position) . '_blocks[]" value="' . esc_attr($block->id) . '">';
                        echo '</li>';
                    }
                }
                ?>
            </ul>
        </div>

        <!-- Sağ taraf - Tüm bloklar -->
        <div class="available-blocks" style="width: 200px;">
            <input type="text" class="block-search" placeholder="Blok ara..." style="width: 100%; margin-bottom: 10px;">
            <div class="blocks-list-wrapper">
                <ul class="blocks-list">
                    <?php foreach ($all_blocks as $block): ?>
                        <li class="block-item" data-block-id="<?php echo esc_attr($block->id); ?>" 
                            data-position="<?php echo esc_attr($position); ?>">
                            <?php echo esc_html($block->name); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </div>

    <style>
        .sortable-blocks { 
            min-height: 50px; 
            border: 1px dashed #ccc; 
            padding: 10px;
            margin: 0;
        }
        .block-item { 
            padding: 8px;
            margin: 5px 0;
            background: #f5f5f5;
            border: 1px solid #ddd;
            cursor: move;
            list-style: none;
            position: relative;
        }
        .available-blocks .block-item {
            cursor: pointer;
        }
        .remove-block {
            position: absolute;
            right: 5px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            border: none;
            background: none;
            color: #cc0000;
        }
        .blocks-list {
            margin: 0;
            padding: 0;
        }
        .blocks-list-wrapper {
            max-height: 200px;
            overflow-y: auto;
            border: 1px solid #ddd;
            padding: 5px;
        }
        /* Webkit scrollbar stilleri */
        .blocks-list-wrapper::-webkit-scrollbar {
            width: 6px;
        }
        .blocks-list-wrapper::-webkit-scrollbar-track {
            background: #f1f1f1;
        }
        .blocks-list-wrapper::-webkit-scrollbar-thumb {
            background: #888;
            border-radius: 3px;
        }
        .blocks-list-wrapper::-webkit-scrollbar-thumb:hover {
            background: #555;
        }
        .block-search {
            padding: 5px;
            border: 1px solid #ddd;
            border-radius: 3px;
            font-size: 13px;
        }
        
        .block-search:focus {
            border-color: #2271b1;
            box-shadow: 0 0 0 1px #2271b1;
            outline: none;
        }
    </style>

    <script>
    jQuery(document).ready(function($) {
        // Sıralama için sortable
        $(".sortable-blocks").sortable({
            placeholder: "block-placeholder",
            update: function(event, ui) {
                // Sıralama güncellendiğinde input değerlerini güncelle
            }
        });

        // Sağdaki blokları tıklayarak ekleme
        $(document).on("click", ".available-blocks .block-item", function() {
            var blockId = $(this).data("block-id");
            var blockTitle = $(this).text().trim();
            var position = $(this).data("position");
            var container = $(this).closest('.metabox-container');
            
            // Eğer bu blok zaten eklenmişse, eklemeyi iptal et
            if (container.find('.sortable-blocks').find(`input[value="${blockId}"]`).length > 0) {
                return;
            }
            
            var newBlockHtml = `
                <li class="block-item" data-block-id="${blockId}">
                    <span class="block-title">${blockTitle}</span>
                    <button type="button" class="remove-block">×</button>
                    <input type="hidden" name="page_${position}_blocks[]" value="${blockId}">
                </li>
            `;
            container.find('.sortable-blocks').append(newBlockHtml);
        });

        // Blok silme
        $(document).on("click", ".remove-block", function() {
            $(this).closest(".block-item").remove();
        });

        // Blok arama fonksiyonu
        $(document).on('input', '.block-search', function() {
            var searchText = $(this).val().toLowerCase();
            var blocksList = $(this).closest('.available-blocks').find('.block-item');
            
            blocksList.each(function() {
                var blockTitle = $(this).text().toLowerCase();
                if (blockTitle.includes(searchText)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
    });
    </script>
    <?php
}

function get_block_by_id($block_id) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'blocks';
    return $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $block_id));
}

function save_page_block_meta($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    $positions = ['top', 'middle', 'bottom'];

    foreach ($positions as $position) {
        $field_name = 'page_' . $position . '_blocks';
        if (isset($_POST[$field_name])) {
            $blocks = array_map('intval', $_POST[$field_name]);
            update_post_meta($post_id, $field_name, $blocks);
        } else {
            delete_post_meta($post_id, $field_name);
        }
    }
}

function add_blocks_to_page_content($content) {
    if (!is_singular(['post', 'page'])) return $content;
    
    global $post;
    $positions = ['top', 'middle', 'bottom'];
    $additional_content = '';
    
    foreach ($positions as $position) {
        $blocks = get_post_meta($post->ID, 'page_' . $position . '_blocks', true);
        if (is_array($blocks)) {
            foreach ($blocks as $block_id) {
                $block = get_block_by_id($block_id);
                if ($block) {
                    $block_slug = sanitize_title($block->name);
                    if ($position === 'top') {
                        $additional_content = "[dn_block {$block_slug} id=\"{$block_id}\"]" . $additional_content;
                    } elseif ($position === 'middle') {
                        $content = $content . "[dn_block {$block_slug} id=\"{$block_id}\"]";
                    } else {
                        $additional_content .= "[dn_block {$block_slug} id=\"{$block_id}\"]";
                    }
                }
            }
        }
    }
    
    return $additional_content . $content;
}

add_action('add_meta_boxes', 'add_block_list_to_page_editor');
add_action('save_post', 'save_page_block_meta');
add_filter('the_content', 'add_blocks_to_page_content');

?>