<?php get_header(); ?>

    <?php
    // Üst blokları getir
    $front_page_id = get_option('page_on_front');
    $top_blocks = get_post_meta($front_page_id, 'page_top_blocks', true);
    if (is_array($top_blocks) && !empty($top_blocks)) {
        foreach ($top_blocks as $block_id) {
            $block = get_block_by_id($block_id);
            if ($block) {
                $block_slug = sanitize_title($block->name);
                echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
            }
        }
    }
    
    // Blog yazıları
    /*if (have_posts()) :
    ?>
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <?php
                while (have_posts()) : the_post(); ?>
                    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <header class="entry-header">
                            <h2 class="entry-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h2>
                            <div class="entry-meta">
                                <span class="posted-on"><?php echo get_the_date(); ?></span>
                            </div>
                        </header>

                        <div class="entry-content">
                            <?php
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('medium');
                            }
                            the_excerpt();
                            ?>
                        </div>
                    </article>
                <?php 
                endwhile;

                // Sayfalama
                echo '<div class="pagination">';
                echo paginate_links([
                    'prev_text' => '&laquo; Önceki',
                    'next_text' => 'Sonraki &raquo;'
                ]);
                echo '</div>';
                ?>
            </div>
            <?php if (is_active_sidebar('sidebar-1')) : ?>
                <div class="col-md-4">
                    <?php get_sidebar(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php 
    endif;*/

    // Orta blokları getir
    $middle_blocks = get_post_meta($front_page_id, 'page_middle_blocks', true);
    if (is_array($middle_blocks) && !empty($middle_blocks)) {
        foreach ($middle_blocks as $block_id) {
            $block = get_block_by_id($block_id);
            if ($block) {
                $block_slug = sanitize_title($block->name);
                echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
            }
        }
    }

    // Alt blokları getir
    $bottom_blocks = get_post_meta($front_page_id, 'page_bottom_blocks', true);
    if (is_array($bottom_blocks) && !empty($bottom_blocks)) {
        foreach ($bottom_blocks as $block_id) {
            $block = get_block_by_id($block_id);
            if ($block) {
                $block_slug = sanitize_title($block->name);
                echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
            }
        }
    }
    ?>

<?php get_footer(); ?>