<?php 

ob_start();

require_once "common/head.php"; 

?>

<body>
<div class="header-all">
    <nav id="top" class="header-top nav-top">
        <div class="custom-container">
            <div class="top-inner row">
                <div class="col-lg-6 col-md-6 col-3 flex-fill order-xxl-1 order-lg-1 text-center d-flex align-items-center p-column-none uk-flex-between">
                    <div class="header-bottom header-desktop uk-visible@m">
                        <ul class="uk-navbar-nav uk-flex-left">
                            <?php get_menu_items_by_location("header-menu"); ?>
                        </ul>
                    </div>
                    <div class="header-logo p-0">
                        <div id="logo">
                            <a href="<?php bloginfo('url'); ?>">
                                <img src="<?= theme_logo(); ?>" title="LeanFit by Game" alt="LeanFit by Game" class="img-responsive" />
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-md-4 col-4 header-right flex-fill order-xxl-3 order-lg-2 p-column-none">
                    <div class="uk-flex justify-content-end align-items-center">
                        <div class="d-block">
                            <div class="header-links">
                                <div class="uk-navbar-item item-fix">
                                    <div class="uk-position-relative">
                                        <a href="#search-modal" uk-toggle class="uk-flex uk-flex-gap-small uk-items-center">
                                            <span class="uk-flex" uk-icon="icon: icn-search;"></span>
                                        </a>
                                    </div>
                                </div>
                                <div class="uk-navbar-item item-fix">
                                    <div class="uk-position-relative">
                                        <a href="#" uk-toggle="target: #offcanvas-basket" class="uk-flex uk-flex-gap-small uk-items-center">
                                            <span class="uk-flex" uk-icon="icon: icn-bag;"></span>
                                            <?= __( 'Sepet', 'leanfit' );?>
                                        </a>
                                    </div>
                                </div>
                                <div class="uk-navbar-item item-fix uk-visible@m">
                                    <div class="uk-position-relative">
                                        <?php if ( is_user_logged_in() ) : ?>
                                            <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="uk-flex uk-flex-gap-small uk-items-center">
                                                <span class="uk-flex" uk-icon="icon: icn-user;"></span>
                                                <?= __( 'Hesabım', 'leanfit' );?>
                                            </a>
                                        <?php else : ?>
                                            <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="uk-flex uk-flex-gap-small uk-items-center">
                                                <span class="uk-flex" uk-icon="icon: icn-user;"></span>
                                                <?= __( 'Giriş Yap / Üye Ol', 'leanfit' );?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="uk-navbar-item item-fix uk-visible@l">
                                    <div class="uk-position-relative">
                                        <a href="<?php echo get_track_order_url(); ?>" class="uk-button tracking-button">
                                            <span class="uk-flex" uk-icon="icon: location;"></span>
                                            <?= __( 'Sipariş Takip', 'leanfit' ); ?>
                                        </a>
                                    </div>
                                </div>
                                <div class="uk-navbar-item item-close uk-hidden@l">
                                    <div class="uk-position-relative uk-mobile-menu-box">
                                        <a href="#modal-menu" uk-icon="icon: icn-menu;" class="overflow-hidden mobile-menu-btn" uk-toggle></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <div id="offcanvas-basket" class="uk-offcanvas" uk-offcanvas="flip: true; overlay: true">
        <div class="uk-offcanvas-bar uk-flex uk-flex-column" id="cart">

            <?php include(get_template_directory() . '/components/cart-modal.php'); ?>

        </div>
    </div>

    <header class="nav-menu">
        <div class="mobile-header">
            <div class="header-logo d-md-none d-inline-block">
                <div id="logo" class="h-logo">
                    <a href="<?php bloginfo('url'); ?>"><img src="<?php bloginfo('template_url'); ?>/assets/image/catalog/logo/lean_fit_logo.png" title="LeanFit by Game" alt="LeanFit by Game" class="img-responsive" /></a>
                </div>
            </div>

            <div class="header-right d-md-none d-inline-block me-1">
                <div class="header-links">
                    <div class="uk-navbar-item">
                        <div class="uk-position-relative" style="margin-right: 15px;">
                            <a href="#" uk-toggle="target: #offcanvas-basket">
                                Bag
                                <span class="cart-total" style="margin-left: 5px;">0</span>
                            </a>
                        </div>

                        <div class="uk-grid">
                            <form action="/index.php?route=common/language/language" method="post" enctype="multipart/form-data" class="form-language">
                                <button class="uk-button uk-button-text uk-text-small language-select text-uppercase" type="button" name="tr-tr">
                                    tr
                                </button>
                                <input type="hidden" name="code" value="" />
                                <input type="hidden" name="redirect" value="home" />
                            </form>
                        </div>
                    </div>

                    <div class="uk-flex">
                        <a href="#modal-menu" class="overflow-hidden mobile-menu-btn" uk-toggle>
                            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 203.33 162">
                                <rect x="18" y="9" width="180" height="18" rx="9"></rect>
                                <rect x="18" y="135" width="180" height="18" rx="9"></rect>
                                <rect x="57.13" y="72" width="140.87" height="18" rx="9"></rect>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>

            <div id="modal-menu" class="uk-modal uk-modal-full" uk-modal>
                <div class="uk-modal-dialog uk-flex uk-flex-column" uk-height-viewport>
                    <div class="uk-modal-header uk-overflow-hidden overlay">
                        <nav class="uk-navbar uk-navbar-container uk-width uk-navbar-transparent" uk-navbar>
                            <div class="uk-grid uk-grid-small uk-flex-middle uk-width">
                                <div class="uk-width-1-2">
                                    <div class="uk-navbar-item uk-padding-remove uk-flex-left">
                                        <div class="uk-flex uk-light">
                                            <a href="#" class="uk-modal-close"><span uk-icon="icon: icn-close;"></span> Menu</a>
                                        </div>
                                    </div>
                                </div>

                                <div class="uk-width-1-2">
                                    <div class="uk-navbar-item uk-padding-remove uk-flex-right">
                                        <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="uk-flex uk-flex-gap-small align-items-center">
                                            <?php if ( is_user_logged_in() ) : ?>
                                                <span class="user-circle" uk-icon="icon: icn-user-circle;"></span>
                                                <?= __( 'Hesabım', 'leanfit' );?>
                                            <?php else : ?>
                                                <span uk-icon="icon: icn-user;"></span>
                                                <?= __( 'Giriş Yap / Üye Ol', 'leanfit' );?>
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </nav>
                    </div>

                    <div class="uk-modal-header uk-background-default uk-overflow-hidden overlay uk-hidden">
                        <nav class="uk-navbar uk-navbar-container uk-navbar-transparent" uk-navbar>
                            <div class="uk-navbar-item uk-padding-remove">
                                <a href="#" class="uk-h4 uk-margin-remove uk-text-inherit uk-flex uk-flex-middle back-menu">
                                    <span class="uk-text-tertiary uk-margin-right" uk-icon="icon: icn-chevron-left;"></span>
                                    <div class="title uk-text-tertiary"></div>
                                </a>
                            </div>
                        </nav>
                    </div>

                    <div class="uk-modal-body">
                        <ul uk-accordion>
                            <?php get_menu_items_by_location("header-menu", true); ?>
                        </ul>

                        <div class="mobile-short-menu">
                            <ul>
                                <li><a href="<?php echo get_track_order_url(); ?>"><?= __( 'Sipariş Takip', 'leanfit' );?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
</div>

<div id="search-modal" class="uk-modal-full" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-full uk-close-large" type="button" uk-close></button>
        <div class="uk-grid-collapse" uk-grid>
            <form action="<?php echo esc_url(home_url('/')); ?>" class="search-modal uk-flex" id="leanfitSearch">
                <span class="btn-search input-group-btn" uk-icon="icon: icn-search;"></span>
                <input type="text" name="s" value="" placeholder="<?= __( 'Ne arıyorsunuz?', 'leanfit' );?>" class="form-control input-lg ui-autocomplete-input" />
                <button type="submit" class="uk-hidden"><?= __( 'Ara', 'leanfit' );?></button>
            </form>
        </div>
    </div>
</div>

<style>
    .fixed-header .uk-button-text {
        color: #fff;
        font-size: 13px;
        font-weight: 600;
    }
</style>