<?php
$cart_items = WC()->cart->get_cart();
?>

<div class="offcanvas-header uk-position-sticky uk-flex uk-flex-between uk-flex-middle uk-flex-none">
            <h4 class="uk-margin-remove"><?php echo _e('Sepet', 'leanfit'); ?></h4>
            <a href="#" class="uk-offcanvas-close uk-text-black uk-position-static uk-padding-remove">
                <span uk-icon="icn-close"></span>
            </a>
        </div>

<?php if (!empty($cart_items)) { ?>
        <div class="offcanvas-body uk-flex uk-flex-column uk-flex-1">
            <div class="cart-products">
            <?php foreach ($cart_items as $cart_item_key => $cart_item) {
                $product = $cart_item['data'];
                $product_id = $product->get_id();
                $product_permalink = get_permalink($product_id);
                $thumbnail = $product->get_image();
                $product_name = $product->get_name();
                $product_price = WC()->cart->get_product_price($product);
                $regular_price = $product->get_regular_price();
                $sale_price = $product->get_sale_price();
                
                // Discount calculation
                if ($sale_price) {
                    $discount_percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
                }
            ?>
                <div class="cart-item uk-grid-small uk-flex-between uk-grid align-items-center" data-item="<?php echo esc_attr($cart_item_key); ?>" uk-grid="">
                    <div class="uk-width-7-10@m">
                        <div class="uk-grid uk-grid-xsmall">
                            <div class="uk-width-auto overflow-hidden">
                                <div class="image">
                                    <a href="<?php echo esc_url($product_permalink); ?>">
                                        <?php echo $thumbnail; ?>
                                    </a>
                                </div>
                            </div>

                            <div class="uk-width-7-11@m uk-width-2-3 uk-flex">
                                <div class="cart-product-name">
                                    <a class="cart-label" href="<?php echo esc_url($product_permalink); ?>" title="<?php echo esc_attr($product_name); ?>">
                                        <?php echo esc_html($product_name); ?>
                                    </a>
                                    <div class="cart-prices uk-hidden@m">
                                        <div class="price"><?php echo $product_price; ?></div>
                                        <?php if ($sale_price) : ?>
                                            <div class="old_price"><?php echo wc_price($regular_price); ?></div>
                                            <div class="discount-rate">%<?php echo $discount_percentage; ?> <?php echo _e('İndirim', 'leanfit'); ?></div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="cart-quantity-label">
                                        <div class="quantity-control">
                                            <span class="checkout-quantity"><?php esc_html_e('Adet', 'leanfit'); ?></span>
                                            <div class="uk-button-group cart-quantity-buttons" data-id="<?php echo esc_attr($product->get_id()); ?>" data-cart-key="<?php echo esc_attr($cart_item_key); ?>">
                                                <button type="button" class="uk-button uk-button-small qty-btn minus">-</button>
                                                <input type="text" class="uk-button uk-button-small qty-value has" value="<?php echo esc_attr($cart_item['quantity']); ?>" data-cart-key="<?php echo esc_attr($cart_item_key); ?>" readonly>
                                                <button type="button" class="uk-button uk-button-small qty-btn plus">+</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="uk-width-auto cart-remove">
                        <div class="cursor-pointer uk-icon remove-cart-item" data-cart-item="<?php echo esc_attr($cart_item_key); ?>" uk-icon="icon: icn-close"></div>
                        
                        <div class="cart-prices uk-visible@m">
                            <div class="price"><?php echo $product_price; ?></div>
                            <?php if ($sale_price) : ?>
                                <div class="old_price"><?php echo wc_price($regular_price); ?></div>
                                <div class="discount-rate">%<?php echo $discount_percentage; ?> <?php echo _e('İndirim', 'leanfit'); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        </div>

        <div class="offcanvas-footer uk-background-default uk-position-sticky uk-position-bottom uk-margin-auto-top">
            <div class="">
                <a href="<?php echo wc_get_checkout_url(); ?>" class="uk-button cart-button-basket uk-width-1-1 text-uppercase uk-margin-small-top"><?php echo _e('Ödeme', 'leanfit'); ?></a>
            </div>
        </div>

<script>

document.addEventListener('DOMContentLoaded', function() {
    if (window.innerWidth <= 768) {
        const cartItemsContainer = document.querySelector('.cart-products');
        
        // Check if cart items container exists
        if (!cartItemsContainer) return;
        
        const initSwipe = () => {
            const cartItems = cartItemsContainer.querySelectorAll('.cart-item');
            if (!cartItems.length) return;
            
            cartItems.forEach(item => {
                let touchStartX = 0;
                let touchEndX = 0;
                
                const handleTouchStart = (e) => {
                    touchStartX = e.touches[0].clientX;
                };
                
                const handleTouchMove = (e) => {
                    touchEndX = e.touches[0].clientX;
                    const diffX = touchStartX - touchEndX;
                    
                    if (diffX > 0 && diffX <= 60) {
                        item.style.transform = `translateX(-${diffX + 35}px)`;
                    }
                };
                
                const handleTouchEnd = () => {
                    const diffX = touchStartX - touchEndX;
                    
                    if (diffX > 30) {
                        // Önce diğer tüm öğeleri kapat
                        cartItems.forEach(otherItem => {
                            if (otherItem !== item) {
                                otherItem.classList.remove('swiped');
                                otherItem.style.transform = 'translateX(0)';
                            }
                        });
                        item.classList.add('swiped');
                    } else {
                        item.classList.remove('swiped');
                        item.style.transform = 'translateX(0)';
                    }
                };
                
                // Remove existing event listeners if any
                item.removeEventListener('touchstart', handleTouchStart);
                item.removeEventListener('touchmove', handleTouchMove);
                item.removeEventListener('touchend', handleTouchEnd);
                
                // Add new event listeners
                item.addEventListener('touchstart', handleTouchStart);
                item.addEventListener('touchmove', handleTouchMove);
                item.addEventListener('touchend', handleTouchEnd);
            });
        };

        // Initialize swipe functionality
        initSwipe();

        // Handle click outside
        document.addEventListener('click', (e) => {
            // Eğer tıklanan element cart-remove veya onun alt elementi değilse
            if (!e.target.closest('.cart-remove') && !e.target.closest('.cart-item.swiped')) {
                const cartItems = cartItemsContainer.querySelectorAll('.cart-item');
                cartItems.forEach(item => {
                    item.classList.remove('swiped');
                    item.style.transform = 'translateX(0)';
                });
            }
        });

        // Re-initialize when cart is updated (if using AJAX)
        document.addEventListener('cart_updated', initSwipe);
    }
});
</script>

<?php } else { ?>
    <div class="offcanvas-no-product uk-text-center uk-flex uk-flex-column uk-flex-center uk-flex-middle uk-flex-1">
            <div class="basket-icon"><span uk-icon="icn-basket"></span></div>
            <p class="basket-no-product-text"><?php echo _e('Sepetinizde henüz ürün bulunmamaktadır.', 'leanfit'); ?></p>
        <a href="<?php echo get_term_link(24, 'product_cat'); ?>" class="uk-button uk-button-primary uk-margin-top"><?php echo _e('Ürünleri Görüntüle', 'leanfit'); ?></a>
        </div>
    <?php } ?>

