<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $product;

if ( ! comments_open() ) {
    return;
}

$product_id = get_the_ID();

// Tüm yorumları al
$comments = get_approved_comments($product_id);
$total_comments = count($comments);

// Transient kullanarak cache'leme
$cache_key = 'product_rating_data_' . $product_id;
$rating_data = get_transient($cache_key);

if(false === $rating_data) {
    $rating_counts = array(5 => 0, 4 => 0, 3 => 0, 2 => 0, 1 => 0);
    $total_rating = 0;

    foreach($comments as $comment) {
        $rating = get_comment_meta($comment->comment_ID, 'rating', true);
        if($rating) {
            $rating_counts[$rating]++;
            $total_rating += $rating;
        }
    }

    $average_rating = $total_comments > 0 ? round($total_rating / $total_comments, 2) : 0;

    set_transient($cache_key, [
        'average' => $average_rating,
        'total' => $total_comments,
        'counts' => $rating_counts
    ], HOUR_IN_SECONDS); // 1 saat cache'le
} else {
    $average_rating = $rating_data['average'];
    //$total_comments = $rating_data['total'];
    $rating_counts = $rating_data['counts'];
}

?>

<section class="uk-section section-review uk-padding-remove-bottom">
    <div class="custom-container">
        <div class="uk-grid">
            <div class="uk-width-1-1@s">
                <h2 class="section-title"><?= __( 'Yorumlar', 'leanfit' );?></h2>

                <div class="review-star">
                    <div class="uk-grid uk-grid-large uk-items-center align-items-center" uk-grid>
                        <div class="uk-width-2-12@xl uk-width-3-12@l uk-width-4-12@m uk-text-center">
                            <h3 class="review-score"><?php echo esc_html($average_rating); ?></h3>

                            <div class="product-stars">
                                <?php
                                // Tam yıldızlar
                                for($i = 1; $i <= floor($average_rating); $i++) {
                                    echo '<span uk-icon="icn-star-2" class="star filled"></span>';
                                }
                                // Kalan yıldızlar
                                for($i = ceil($average_rating); $i <= 5; $i++) {
                                    echo '<span uk-icon="icn-star-null-2" class="star"></span>';
                                }
                                ?>
                            </div>

                            <h4 class="review-score-text"><?php echo sprintf( __('%s incelemelerine göre', 'leanfit'), esc_html($total_comments) ); ?></h4>
                            <button class="uk-button uk-button-review" uk-toggle="target: #review-form-modal" type="button"><?php esc_html_e('Yorum Yap', 'leanfit'); ?></button>
                        </div>

                        <div class="uk-width-10-12@xl uk-width-9-12@l uk-width-8-12@m uk-visible@m">
                            <?php
                            // Her rating için progress bar oluştur (5'ten 1'e)
                            for($i = 5; $i >= 1; $i--) {
                                $count = $rating_counts[$i];
                                $percentage = $total_comments > 0 ? $count : 0;
                                ?>
                                <div class="progress">
                                    <div class="score"><?php echo esc_html($count); ?></div>
                                    <progress class="uk-progress" value="<?php echo esc_attr($count); ?>" max="<?php echo esc_attr($total_comments); ?>"></progress>

                                    <div class="product-stars">
                                        <?php
                                        // Yıldızları oluştur
                                        for($j = 1; $j <= 5; $j++) {
                                            if($j <= $i) {
                                                echo '<span uk-icon="icn-star-2" class="star filled"></span>';
                                            } else {
                                                echo '<span uk-icon="icn-star-null-2" class="star"></span>';
                                            }
                                        }
                                        ?>
                                    </div>
                                </div>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <div class="review-list" id="product-reviews">
                    <?php
                    wp_list_comments(
                        array(
                            'callback' => 'custom_woocommerce_product_review_list',
                            'style'    => 'ol',
                            'short_ping' => true,
                        ),
                        array_slice(get_comments(array(
                            'post_id' => $product->get_id(),
                            'status' => 'approve',
                            'orderby' => 'comment_date',
                            'order' => 'DESC',
                        )), 0, 3)
                    );
                    ?>
                </div>

                <?php if ( get_comment_count($product->get_id())['approved'] > 4 ) : ?>
                <div class="uk-text-center">
                    <button class="uk-button uk-load-more uk-text-uppercase" id="load-more-reviews" data-product-id="<?php echo $product->get_id(); ?>" data-page="2"><?php esc_html_e('Daha Fazla Yorum Gör', 'leanfit'); ?></button>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div id="review-form-modal" uk-modal>
        <div class="uk-modal-dialog uk-modal-body">
            <h2 class="uk-modal-title"><?php esc_html_e('Yorum Yap', 'leanfit'); ?></h2>
            <div class="review-form">
                <?php comment_form(); ?>
            </div>
        </div>
    </div>
</section>




