<section class="customer-comment-slideshow">
    <div class="uk-container">
        <div class="uk-grid uk-flex-center" uk-grid>
            <div class="uk-width-3-5@m uk-margin-large-bottom">
                <h2 class="section-title uk-text-center"><?php echo $block->title; ?></h2>
                <h3 class="section-subtitle uk-text-center"><?php echo $block->subtitle; ?></h3>
            </div>
        </div>
    </div>

    <div class="uk-position-relative uk-visible-toggle uk-light" uk-slider="center: true; finite: false; sets: true;">
        <div class="uk-slider-items uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-4@m uk-child-width-1-5@l uk-child-width-1-6@xl uk-child-width-1-7@xxl uk-grid-small uk-grid-match">
            <?php
            // Ana sayfada gösterilecek yorumları al
            $homepage_reviews = get_homepage_reviews();
            
            // Yorum kartlarının renk sınıfları
            $color_classes = ['item-blue', 'item-red', 'item-yellow', 'item-orange', 'item-gray'];
            $color_index = 0;
            $color_class = "item-white";
            
            // Yorumları 3 kez tekrarla (12 kart oluştur)
            for ($repeat = 0; $repeat < 2; $repeat++) {
                foreach ($homepage_reviews as $review) {
                    $rating = get_comment_meta($review->comment_ID, 'rating', true);
                    $images = get_comment_meta($review->comment_ID, 'review_images', true);
                    
                    // Yazar ismini formatla (Duygu Altın -> Duygu A.)
                    $author = get_comment_author($review->comment_ID);
                    $name_parts = explode(' ', $author);
                    $formatted_name = $name_parts[0];
                    if (isset($name_parts[1])) {
                        $formatted_name .= ' ' . substr($name_parts[1], 0, 1) . '.';
                    }
                    
                    // Renk sınıfını döngüsel olarak seç
                    // $color_class = $color_classes[$color_index % count($color_classes)];
                    // $color_index++;
                    ?>
                    <div>
                        <div class="comment-item <?php echo $color_class; ?>">
                            <div>
                                <div class="comment-stars uk-margin-small-bottom">
                                    <?php for ($i = 1; $i <= 5; $i++) : ?>
                                        <span uk-icon="icn-star" class="star <?php echo ($i <= $rating) ? 'filled' : ''; ?>"></span>
                                    <?php endfor; ?>
                                </div>

                                <p><?php echo wp_trim_words($review->comment_content, 30); ?></p>
                            </div>

                            <?php if (!empty($images) && is_array($images)) : ?>
                                <div class="comment-images">
                                    <div class="uk-grid uk-child-width-1-3@m uk-child-width-1-2@s uk-child-width-1-2 uk-grid-xsmall uk-grid-match uk-grid-gap-medium" uk-lightbox>
                                        <?php foreach ($images as $image_url) : ?>
                                            <a href="<?php echo esc_url($image_url); ?>" class="uk-margin-small-bottom">
                                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($formatted_name); ?>" />
                                            </a>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <h3><?php echo esc_html($formatted_name); ?></h3>
                        </div>
                    </div>
                <?php 
                }
            }
            ?>
        </div>

        <a class="uk-position-center-left uk-position-small uk-slide-navigation uk-hidden-hover" href uk-slidenav-previous uk-slider-item="previous">
            <span uk-icon="icn-scroll-arrow-left"></span>
        </a>
        <a class="uk-position-center-right uk-position-small uk-slide-navigation uk-hidden-hover next-button" href uk-slidenav-next uk-slider-item="next">
            <span uk-icon="icn-scroll-arrow-right"></span>
        </a>
    </div>
</section>