// Assuming jQuery is included in your project.  If not, include it via a `<script>` tag in your HTML.
jQuery(function($) {
    $('#load-more-reviews').on('click', function() {
        var button = $(this);
        var product_id = button.data('product-id');
        var page = button.data('page');

        $.ajax({
            url: wc_add_to_cart_params.ajax_url,
            type: 'POST',
            data: {
                action: 'load_more_reviews',
                product_id: product_id,
                page: page
            },
            success: function(response) {
                if (response.html) {
                    $('#product-reviews').append(response.html);
                    button.data('page', page + 1);
                    if (!response.has_more) {
                        button.hide();
                    }
                }
            }
        });
    });

    // File input değişikliğini izle
    $('#comment_images').on('change', function() {
        var fileCount = this.files.length;
        if (fileCount > 5) {
            alert('En fazla 5 görsel yükleyebilirsiniz.');
            this.value = ''; // Dosya seçimini temizle
        }
    });
});