<?php
/**
 * Order details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.6.0
 *
 * @var bool $show_downloads Controls whether the downloads table should be rendered.
 */

 // phpcs:disable WooCommerce.Commenting.CommentHooks.MissingHookComment

defined( 'ABSPATH' ) || exit;

$order = wc_get_order( $order_id ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited

if ( ! $order ) {
	return;
}
?>
<style>
    @media only screen and (max-width: 768px) {
        .header-all {
            background-color: #ffffff;
        }
    }

    body {
        background-color: #ffffff;
    }
    
    .woocommerce-order > p {
        display: none;
    }
</style>
<section class="section-login section-order-success m-center">
    <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1" uk-slideshow="animation: fade">
        <div class="uk-slideshow-items">
            <div>
                <div class="uk-position-relative uk-overflow-hidden">
                    <div class="banner-contents uk-position-z-index-2">
                        <div class="custom-container">
                            <div class="uk-grid align-items-center uk-flex-center">
                                <div class="uk-width-3-12@xxl uk-width-4-12@xl uk-width-6-12@l">
                                    <div class="login-form">
                                        <div class="uk-width-1-1 uk-flex uk-flex-center icon-check">
                                            <span class="uk-icon" uk-icon="icon: icn-check-success"></span>
                                        </div>

                                        <div class="uk-text-center">
                                            <div class="welcome"><?php esc_html_e('Tebrikler', 'leanfit'); ?></div>
                                            <div class="intro-success">
                                                <?php 
                                                /* translators: %s: Order number */
                                                printf(
                                                    esc_html__('Sipariş #%s başarıyla tamamlandı.', 'leanfit') . '<br>' . esc_html__('Gerekli bilgiler e-posta adresinize gönderildi.', 'leanfit'),
                                                    $order->get_order_number()
                                                );
                                                ?>
                                            </div>
                                            <p><?php esc_html_e('Gerekli bilgiler e-posta adresinize gönderilmiştir.', 'leanfit'); ?></p>

                                            <div class="uk-text-center uk-margin-medium-top uk-padding-large uk-padding-remove-bottom uk-padding-remove-top">
                                                <a href="<?php echo esc_url(home_url('/')); ?>" class="uk-button lean-button-red uk-margin-small">
                                                    <?php esc_html_e('Anasayfaya Git', 'leanfit'); ?>
                                                </a>

                                                <a href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>" class="uk-button lean-button-dark">
                                                    <?php esc_html_e('Siparişlerim', 'leanfit'); ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


