<?php
/**
 * Edit account form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.6.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_edit_account_form' );

?>

<style>
    .woocommerce-notices-wrapper {
        display: none;
    }

    .text-description {
        margin: 10px 0 30px;
        font-size: 16px;
    }
</style>

<section class="section-account">
    <?php wc_get_template('myaccount/account-header.php'); ?>
    <div class="account-tabs">
        <ul class="uk-tab uk-flex-center">
            <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>"><?php esc_html_e('Siparişlerim', 'leanfit'); ?></a></li>
            <li class="uk-active"><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-account')); ?>"><?php esc_html_e('Üyelik Bilgilerim', 'leanfit'); ?></a></li>
            <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-address')); ?>"><?php esc_html_e('Adreslerim', 'leanfit'); ?></a></li>
            <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('reviews')); ?>"><?php esc_html_e('Yorumlarım', 'leanfit'); ?></a></li>
        </ul>

        <div class="custom-container">

            <div class="uk-grid uk-flex-center">
                <div class="uk-width-4-11@l uk-width-5-11@m uk-width-7-11@s">
                    <div class="membership-content">
                        <form method="post" class="lean-form woocommerce-EditAccountForm edit-account" <?php do_action( 'woocommerce_edit_account_form_tag' ); ?>>
                            <?php do_action( 'woocommerce_edit_account_form_start' ); ?>

                            <div class="uk-margin form-floating">
                                <input class="uk-input" type="text" name="account_first_name" id="account_first_name" placeholder=" " value="<?php echo esc_attr( $user->first_name ); ?>" />
                                <label for="account_first_name"><?php esc_html_e( 'Adınız', 'leanfit' ); ?></label>
                            </div>

                            <div class="uk-margin form-floating">
                                <input class="uk-input" type="text" name="account_last_name" id="account_last_name" placeholder=" " value="<?php echo esc_attr( $user->last_name ); ?>" />
                                <label for="account_last_name"><?php esc_html_e( 'Soyadınız', 'leanfit' ); ?></label>
                            </div>

                            <div class="uk-margin form-floating">
                                <input class="uk-input" type="text" name="account_display_name" id="account_display_name" placeholder=" " value="<?php echo esc_attr( $user->display_name ); ?>" />
                                <label for="account_display_name"><?php esc_html_e( 'Kullanıcı Adı', 'leanfit' ); ?></label>
                            </div>

                            <div class="uk-margin form-floating">
                                <input class="uk-input" type="email" name="account_email" id="account_email" placeholder=" " value="<?php echo esc_attr( $user->user_email ); ?>" />
                                <label for="account_email"><?php esc_html_e( 'E-Posta Adresiniz', 'leanfit' ); ?></label>
                            </div>

                            <?php do_action( 'woocommerce_edit_account_form' ); ?>

                            <div class="uk-text-center uk-section-small">
                                <?php wp_nonce_field( 'save_account_details', 'save-account-details-nonce' ); ?>
                                <button type="submit" class="uk-button save-button uk-width-1-1@s uk-text-uppercase" name="save_account_details"><?php esc_html_e( 'Kaydet', 'leanfit' ); ?></button>
                                <input type="hidden" name="action" value="save_account_details" />
                            </div>

                            <div class="uk-grid uk-flex-between">
                                <a class="button-text" uk-toggle="target: #change-password"><?php esc_html_e('Şifremi Değiştir', 'leanfit'); ?></a>
                                <a class="button-text" uk-toggle="target: #delete-membership"><?php esc_html_e('Üyeliğimi Sil', 'leanfit'); ?></a>
                            </div>

                            <?php do_action( 'woocommerce_edit_account_form_end' ); ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <?php do_action( 'woocommerce_after_edit_account_form' ); ?>

</section>


<div id="change-password" class="membership-modal" uk-modal>
    <div class="uk-modal-dialog uk-modal-body">
        <div class="lean-modal-header">
            <div class="uk-grid uk-flex-between align-items-center">
                <div>
                    <h2 class="uk-modal-title uk-margin-remove"><?php esc_html_e('Şifremi Değiştir', 'leanfit'); ?></h2>
                </div>
                <div>
                    <button class="uk-modal-close" type="button"><span uk-icon="icon: icn-close"></span></button>
                </div>
            </div>
        </div>

        <div class="uk-modal-content">
            <form method="post" class="lean-form password-form">
                <?php wp_nonce_field( 'change_password', 'change-password-nonce' ); ?>
                <input type="hidden" name="action" value="change_password" />

                <div class="uk-margin form-floating">
                    <input class="uk-input" type="password" name="password_current" id="password_current" placeholder=" " />
                    <label for="password_current"><?php esc_html_e('Mevcut Şifreniz', 'leanfit'); ?></label>
                </div>

                <div class="uk-margin form-floating">
                    <input class="uk-input" type="password" name="password_1" id="password_1" placeholder=" " />
                    <label for="password_1"><?php esc_html_e('Yeni Şifreniz', 'leanfit'); ?></label>
                </div>

                <div class="uk-margin form-floating">
                    <input class="uk-input" type="password" name="password_2" id="password_2" placeholder=" " />
                    <label for="password_2"><?php esc_html_e('Yeni Şifrenizi Doğrulayın', 'leanfit'); ?></label>
                </div>

                <div class="uk-mt-20px">
                    <div class="uk-flex uk-grid-small align-items-center">
                        <label>
                            <input class="uk-checkbox has uk-margin-remove" type="checkbox" name="privacy_policy" id="privacy_policy" required>
                        </label>
                        <label for="privacy_policy">
                            <?php
                            printf(
                                esc_html__('Kişisel Verilerin Korunması ve İşlenmesine İlişkin %1$s Bilgilendirme Metnini %2$s okudum ve kabul ettim.', 'leanfit'),
                                '<a class="uk-text-red" href="#terms-modal" uk-toggle>',
                                '</a>'
                            );
                            ?>
                        </label>
                    </div>
                </div>

                <!-- Terms Modal -->
                <div id="terms-modal" class="uk-modal-container" uk-modal>
                    <div class="uk-modal-dialog">
                        <button class="uk-modal-close-full uk-close-large" type="button" uk-close></button>
                        <div class="uk-padding-large">
                            <h2><?php
                                $privacy_page_id = get_option('wp_page_for_privacy_policy');
                                $privacy_page = get_post($privacy_page_id);
                                echo esc_html($privacy_page ? $privacy_page->post_title : _e('Information Text on the Protection and Processing of Personal Data', 'leanfit'));
                                ?></h2>
                            <div class="uk-margin-medium-top">
                                <?php
                                if ($privacy_page_id) {
                                    echo apply_filters('the_content', $privacy_page->post_content);
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="uk-text-center uk-margin-small-top">
                    <button type="submit" class="uk-button save-button uk-width-1-1@s uk-text-uppercase"><?php esc_html_e('Kaydet', 'leanfit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>


<div id="delete-membership" class="membership-modal" uk-modal>
    <div class="uk-modal-dialog uk-modal-body">
        <div class="lean-modal-header">
            <div class="uk-grid uk-flex-between align-items-center">
                <div>
                    <h2 class="uk-modal-title uk-margin-remove"><?php esc_html_e('Üyeliğimi Sil', 'leanfit'); ?></h2>
                </div>
                <div>
                    <button class="uk-modal-close" type="button"><span uk-icon="icon: icn-close"></span></button>
                </div>
            </div>
        </div>

        <div class="uk-modal-content">
            <div class="lean-form">
                <div class="uk-margin-small">
                    <p class="text-description"><?php esc_html_e("Gittiğinizi gördüğümüz için üzgünüz :( Hesabınızı silmek istediğinizden emin misiniz?", 'leanfit'); ?></p>
                </div>

                <form method="post" onsubmit="return confirm('<?php esc_attr_e('Hesabınızı silmek istediğinize emin misiniz? Bu işlem geri alınamaz.', 'leanfit'); ?>');">
                    <?php wp_nonce_field('delete_account', 'delete-account-nonce'); ?>
                    <input type="hidden" name="action" value="delete_account" />

                    <div class="uk-text-center uk-margin-small-top uk-mt-20px">

                        <button type="submit" class="uk-button button-dark uk-width-1-1@s uk-text-uppercase" name="delete_account">
                            <?php esc_html_e('Üyeliğimi Sil', 'leanfit'); ?>
                        </button>
                    </div>

                    <div class="uk-text-center uk-margin">
                        <button type="button" class="uk-modal-close uk-button save-button uk-width-1-1@s uk-text-uppercase">
                            <?php esc_html_e('İptal Et', 'leanfit'); ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>