<?php
/**
 * Checkout Order Receipt Template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/order-receipt.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<script>
    document.querySelector(".header-all").classList.add("header-relative");
</script>
<style>
    @media only screen and (max-width: 768px) {
        .header-all {
            background-color: #ffffff;
        }
    }

    body {
        background-color: #ffffff;
    }

    .section-checkout {
        background-color: #ffffff;
    }

    .summary-details {
        background-color: #f4f0ed !important;
    }

	.payment-form iframe {
		min-height: 100vh;
		height: 100%;
	}
</style>

<section class="section-checkout">
    <div class="custom-container uk-margin-medium-top uk-margin-medium-bottom">
        <div class="uk-grid-large" uk-grid>
            <!-- Summary Section -->
            <div class="uk-width-3-11@l">
                <section class="section-checkout-summary">
                    <div class="uk-border-0">
                        <div class="uk-card-body uk-padding-remove">
                            <h2 class="section-title uk-margin-remove"><?php esc_html_e('Özet', 'leanfit'); ?></h2>

                            <div class="uk-margin-small-top uk-margin-medium-bottom summary-details">
                                <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                                    <span><?php esc_html_e('Sipariş Numarası', 'leanfit'); ?></span>
                                    <span><?php echo esc_html($order->get_order_number()); ?></span>
                                </div>
                                
                                <?php if ($order->get_payment_method_title()) : ?>
                                <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                                    <span><?php esc_html_e('Ödeme Yöntemi', 'leanfit'); ?></span>
                                    <span><?php echo wp_kses_post($order->get_payment_method_title()); ?></span>
                                </div>
                                <?php endif; ?>

                                <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                                    <span><?php esc_html_e('Toplam Tutar', 'leanfit'); ?></span>
                                    <span><?php wc_cart_totals_subtotal_html(); ?></span>
                                </div>

                                
									<?php if (WC()->cart->needs_shipping()) : ?>
									<div class="uk-flex uk-flex-between uk-margin-small-bottom">
										<span><?php esc_html_e('Kargo', 'leanfit'); ?></span>
										<?php if (WC()->cart->get_shipping_total() > 0) : ?>
											<span><?php echo wc_price(WC()->cart->get_shipping_total()); ?></span>
										<?php else : ?>
											<span><?php esc_html_e('Ücretsiz', 'leanfit'); ?></span>
										<?php endif; ?>
									</div>
									<?php endif; ?>

                                <?php if (WC()->cart->get_coupons()) : ?>
                                <div class="uk-flex uk-flex-between uk-margin-small-bottom uk-text-danger">
                                    <span class="lean-text-red"><?php esc_html_e('Kupon', 'leanfit'); ?></span>
                                    <span class="lean-text-red">-<?php 
											$discount_amount = 0;
											foreach (WC()->cart->get_coupons() as $code => $coupon) {
												$discount_amount += WC()->cart->get_coupon_discount_amount($code);
											}
											echo wc_price($discount_amount);
										?></span>
                                </div>
                                <?php endif; ?>

                                <?php 
                                $discount_percentage = 0;
                                $subtotal = floatval($order->get_subtotal());
                                $total = floatval($order->get_total());
                                if ($subtotal > 0) {
                                    $discount_percentage = round((($subtotal - $total) / $subtotal) * 100);
                                }
                                if ($discount_percentage > 0) :
                                ?>
                                <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                                    <span class="lean-text-red"><?php esc_html_e('İndirim', 'leanfit'); ?></span>
                                    <span class="lean-text-red">%<?php echo esc_html($discount_percentage); ?></span>
                                </div>
                                <?php endif; ?>

                                <hr>
                                <div class="uk-flex uk-flex-between checkout-total-price">
                                    <span><?php esc_html_e('Ödenecek Tutar', 'leanfit'); ?></span>
                                    <span><?php 
											ob_start();
											wc_cart_totals_order_total_html();
											$total_html = ob_get_clean();
											echo wp_strip_all_tags($total_html);
										?></span>
                                </div>
                            </div>

                        </div>
                    </div>
                </section>
            </div>

            <!-- Main Content -->
            <div class="uk-width-8-11@l">
                <section>
                    <h2 class="section-title uk-margin-remove-bottom"><?php esc_html_e('Ödeme', 'leanfit'); ?></h2>
                    <div class="payment-form">
                        <?php do_action('woocommerce_receipt_' . $order->get_payment_method(), $order->get_id()); ?>
                    </div>
                </section>
            </div>
        </div>
    </div>
</section>
