<?php
global $post;

$product_id = $post->ID;  // Mevcut sayfanın ürün ID'sini al
$product = wc_get_product($product_id);  // Ürün nesnesini al

// Ürünün başlık (isim) bilgisi
$product_name = $product->get_name();

// Ürünün fiyatı
$product_price = $product->get_price();

// Ürünün SKU (stok kodu)
$product_sku = $product->get_sku();

// Ürünün açıklaması
$product_description = $product->get_description();

// Ürünün kısa açıklaması
$product_short_description = $product->get_short_description();

// Ürün kategorileri
$product_categories = wp_get_post_terms($product->get_id(), 'product_cat');

// Ürünün görselleri
$product_images = $product->get_gallery_image_ids(); // Varsa galerideki tüm görseller
$product_main_image = wp_get_attachment_url($product->get_image_id()); // Ana görsel

// Ürünün stok durumu
$product_stock_status = $product->get_stock_status();

// Ürünün varlık durumu (aktif/arsiv)
$product_status = $product->get_status();

// Ürün Etiketleri
$product_tags = wp_get_post_terms($product->get_id(), 'product_tag');

// Ürünlerin Özellikleri
$product_attributes = $product->get_attributes();

// Ürünün Yorum Sayısı ve Puanı
$product_rating_count = $product->get_rating_count();
$product_average_rating = $product->get_average_rating();

$tabs = get_post_meta(get_the_ID(), '_custom_product_tabs', true);
$icon_tabs = get_post_meta(get_the_ID(), '_custom_icon_tabs', true);

$top_blocks = get_post_meta(get_the_ID(), '_product_top_blocks', true);
$center_blocks = get_post_meta(get_the_ID(), '_product_center_blocks', true);
$bottom_blocks = get_post_meta(get_the_ID(), '_product_bottom_blocks', true);

$top_block = "";
$center_block = "";
$bottom_block = "";
foreach ($top_blocks as $k => $v)
    $top_block .= do_shortcode('[dn_block id="'.$v.'"]');

foreach ($center_blocks as $k => $v)
    $center_block .= do_shortcode('[dn_block id="'.$v.'"]');

foreach ($bottom_blocks as $k => $v)
    $bottom_block .= do_shortcode('[dn_block id="'.$v.'"]');

get_header();
?>


<script>document.querySelector(".header-all").classList.add("header-relative");</script>

<script type="text/javascript">
    var ajaxurl = '<?php echo admin_url("admin-ajax.php"); ?>';
</script>

<main>
    <section class="uk-section uk-padding-remove-top section-product">
        <div class="custom-container">
            <div class="uk-grid uk-grid-large uk-child-width-1-2@m" id="js-oversized" uk-grid>
                <div>
                    <div class="product-image-carousel-wrapper">
                        <div class="box-product product-image-carousel clearfix" style="background-color: <?php echo get_post_meta($product->get_id(), '_custom_background_color', true); ?>">
                            <?php if (!empty($product_images)): ?>
                                <?php
                                foreach ($product_images as $key => $image_id):
                                    $image_url = wp_get_attachment_image_url($image_id, 'full');
                                    $image_title = get_the_title($image_id);
                                    $image_caption = get_post_field('post_excerpt', $image_id);
                                    $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
                                    ?>
                                    <div class="uk-position-relative uk-overflow-hidden">
                                        <?php if ($key == 0) {?>
                                            <div class="uk-text-uppercase uk-position-absolute uk-position-z-index-2 product-icon text-black"><i uk-icon="icn-vegan-green"></i> <?php echo get_post_meta($product->get_id(), '_custom_badge', true); ?></div>
                                        <?php } ?>
                                        <div class="uk-position-relative uk-position-z-index-zero product-image-box">
                                            <a href="<?= $image_url; ?>" data-fancybox="gallery" data-media="(min-width: 50px)" data-sources="<?= $image_url; ?>" >
                                                <img src="<?= $image_url; ?>" alt="<?= $product_name; ?>" title="<?= $product_name; ?>" class="img-responsive" />
                                            </a>
                                        </div>
                                    </div>
                                <?php endforeach; ?>

                            <?php else: ?>
                                <div class="uk-position-relative uk-overflow-hidden">
                                    <div class="uk-text-uppercase uk-position-absolute uk-position-z-index-2 product-icon text-black"><i uk-icon="icn-vegan-green"></i> <?php echo get_post_meta($product->get_id(), '_custom_badge', true); ?></div>
                                    <div class="uk-position-relative uk-position-z-index-zero product-image-box">
                                        <a href="<?= $product_main_image; ?>" data-fancybox="gallery" data-media="(min-width: 50px)" data-sources="<?= $product_main_image; ?>" >
                                            <img src="<?= $product_main_image; ?>" alt="<?= $product_name; ?>" title="<?= $product_name; ?>" class="img-responsive" />
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>

                <div>
                    <div class="product-informations" uk-sticky="end: #js-oversized; offset: 120; ">
                        <div class="uk-grid uk-flex-center">
                            <div class="uk-width-5-8@xxl uk-width-6-8@xl uk-width-7-8@l">
                                <h1 class="product-title uk-margin-remove"><?= $product_name; ?></h1>

                                    <section class="uk-section uk-section-xsmall">
                                        <div class="uk-flex uk-grid-small uk-flex-start uk-items-center">
                                            <div class="product-stars">
                                                <?php
                                                $totalStars = 5;
                                                if ($product_average_rating == 0) {
                                                    $product_rating = 5;
                                                } else {
                                                    $product_rating = $product_average_rating;
                                                }

                                                for ($i = 1; $i <= $totalStars; $i++) {
                                                    if ($i <= $product_rating) {
                                                        echo '<span uk-icon="icn-star" class="star filled"></span>';
                                                    } else {
                                                        echo '<span uk-icon="icn-star-null" class="star"></span>';
                                                    }
                                                }
                                                ?>
                                            </div>

                                            <p class="reviews-text uk-margin-remove"><?= $product_rating_count;?> <?= __( 'Yorum', 'leanfit' );?></p>
                                        </div>
                                    </section>

                                    <div id="product-73" class="product-detail product-detail-wrapper">
                                        <div class="desktop-infos">
                                            <div class="product-prices">
                                                <div class="product-price has-discount">
                                                        <span class="current-price">
                                                            <span itemprop="price"><?php echo price_format($product_price); ?> (<?= __( 'KDV Dahil', 'leanfit' );?>)</span>
                                                        </span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="product-add-to-cart">
                                            <div class="product-quantity clearfix">
                                                <div class="p-cartwapper">
                                                    <div class="count-container">
                                                        <div class="count count-input">
                                                            <a onclick="checkout.count.init(this, 'down', true)" class="count-minus">-</a>
                                                            <input type="text" id="input-quantity" name="quantity" value="1" class="uk-disabled uk-text-center product-quantity" />
                                                            <input type="hidden" name="product_id" value="<?= $product_id; ?>" />
                                                            <a onclick="checkout.count.init(this, 'up', true)" class="count-plus">+</a>
                                                        </div>
                                                    </div>

                                                    <div class="add">
                                                        <button class="btn btn-primary add-to-cart" id="add-to-cart-btn" type="button"><?= __( 'Sepete Ekle', 'leanfit' );?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="uk-margin-medium-bottom uk-margin-medium-top border-bottom"></div>
                                        <?php if (!empty($icon_tabs)) : ?>
                                            <div class="product-highlights">
                                                <!-- <h3 class="subtitle"><?= __( 'Ürün Özellikleri', 'leanfit' );?></h3> -->

                                                <div class="uk-grid uk-child-width-1-3" uk-grid>
                                                    <?php foreach ($icon_tabs as $index => $tab) : ?>
                                                        <div>
                                                            <div class="icon-highlight">
                                                                <span uk-icon="<?php echo esc_attr($tab['icon']); ?>"></span>
                                                            </div>
                                                            <h4><?php echo wp_kses_post($tab['title']); ?></h4>
                                                        </div>
                                                    <?php endforeach; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <h3 class="subtitle"><?= __( 'Ürün İçeriği', 'leanfit' );?></h3>

                                        <div class="product-content-short">
                                            <?php echo apply_filters('the_content', get_the_excerpt()); ?>
                                        </div>

                                    </div>

                                    <?php if (!empty($tabs)) : ?>
                                        <ul class="uk-padding-remove">
                                            <?php foreach ($tabs as $index => $tab) : ?>
                                                <li>
                                                    <a class="tab-title cursor-pointer" href="#<?= sanitize_title($tab['title']);?>" uk-scroll><?php echo esc_html($tab['title']); ?></a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </section>

    <?php echo $top_block; ?>

    <?php if (!empty($tabs)) : ?>
        <section class="uk-section uk-section-large section-product-technical-specifications">
            <div class="custom-container">
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-1">
                        <ul class="uk-accordion" uk-accordion>
                            <?php foreach ($tabs as $index => $tab) : ?>
                                <li id="<?= sanitize_title($tab['title']);?>">
                                    <a class="uk-accordion-title cursor-pointer"><?php echo esc_html($tab['title']); ?></a>
                                    <div class="uk-accordion-content">
                                        <div class="uk-overflow-auto">
                                            <?php echo wp_kses_post($tab['content']); ?>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php

    echo $center_block;


    if (comments_open()) :
        comments_template();
    endif;

    echo $bottom_block;

    ?>

</main>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const modal = document.querySelector('#review-form-modal');
        if (modal) {
            const commentTextareas = modal.querySelectorAll('textarea[name="comment"]');
            if (commentTextareas.length > 1) {
                commentTextareas[1].remove();
            }
        }
    });
</script>

<script type="text/javascript">
    const section = document.querySelector(".section-product-technical-specifications");
    const tables = section.querySelectorAll("table");
    tables.forEach((table) => {
        table.classList.add("uk-table");
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const ratingInputs = document.querySelectorAll('.rating input[type="radio"]');
        ratingInputs.forEach(input => {
            input.addEventListener('click', function() {
                ratingInputs.forEach(inp => inp.checked = false);
                this.checked = true;
                console.log('Seçilen rating:', this.value);
            });
        });
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const tabLinks = document.querySelectorAll('.tab-title');
        tabLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();

                const targetId = this.getAttribute('href').substring(1);
                const targetAccordion = document.getElementById(targetId);
                const targetPosition = targetAccordion.getBoundingClientRect().top + window.pageYOffset - 100;

                window.scrollTo({
                    top: targetPosition,
                    behavior: 'smooth'
                });

                setTimeout(() => {
                    const accordionItem = UIkit.accordion(targetAccordion.closest('.uk-accordion')).toggle(
                        Array.from(targetAccordion.parentNode.children).indexOf(targetAccordion)
                    );
                }, 500);
            });
        });
    });
</script>


<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css" />

<script type="text/javascript">
    var mobileWidth = window.innerWidth;
    if (mobileWidth > 600) {
        // set slider
        const direction = $("html").attr("dir");
        $(".product-related-carousel").each(function () {
            $(this).addClass("owl-carousel owl-theme");
            const sliderRelatedOptions = {
                loop: true,
                nav: true,
                navText: ["", ""],
                dots: true,
                items: 3,
            };
            if (direction == "rtl") sliderRelatedOptions["rtl"] = true;
            $(this).owlCarousel(sliderRelatedOptions);
        });
    } else {
        $(".product-related-carousel").addClass("row-bt5 row-cols-2");
    }
    if (mobileWidth < 769) {
        const direction = $("html").attr("dir");
        $(".product-image-carousel").each(function () {
            $(this).addClass("owl-carousel owl-theme");
            const sliderRelatedOptions = {
                loop: true,
                nav: false,
                navText: ["", ""],
                dots: true,
                items: 1,
            };
            if (direction == "rtl") sliderRelatedOptions["rtl"] = true;
            $(this).owlCarousel(sliderRelatedOptions);
        });
    }

    Fancybox.bind("[data-fancybox]", {
        Images: {
            content: (_ref, slide) => {
                let rez = "<picture>";

                const media = slide.media.split(";");

                slide.sources.split(";").map((source, index) => {
                    rez += `<source
                      media="${media[index] || ""}"
                      srcset="${source}"
                    />`;
                });

                rez += `<img src="${slide.src}" alt="" />`;

                rez += "</picture>";

                return rez;
            },
        },
    });
</script>

<script>
    $(".review-form .comment-form-comment").remove();
    $(".review-form #submit").remove();

    if (document.querySelector('input[name="review_images[]"]')) {
        document.querySelector('input[name="review_images[]"]').addEventListener('change', function(e) {
            const preview = document.getElementById('image-preview');
            preview.innerHTML = ''; // Eski görselleri temizle

            Array.from(e.target.files).forEach(file => {
                const img = document.createElement('img');
                img.src = URL.createObjectURL(file);
                img.style.width = '100px';
                img.style.margin = '5px';
                preview.appendChild(img);
            });
        });
    }
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // #review-form-modal altındaki 2. name=comment textarea tagini sil
        const modal = document.querySelector('#review-form-modal');
        if (modal) {
            const commentTextareas = modal.querySelectorAll('textarea[name="comment"]');
            if (commentTextareas.length > 1) {
                commentTextareas[1].remove();
            }
        }
    });
</script>

<?php get_footer(); ?>