<?php get_header(); ?>
<script>
	document.querySelector(".header-all").classList.add("header-relative");
</script>
    <div id="product-category" class="custom-container">
        <div class="products-list uk-padding-remove-top uk-margin-medium-top">
            <div class="uk-container">
                <div class="uk-grid uk-flex-center" uk-grid>
                    <div class="uk-width-4-5@m uk-margin-medium-bottom">
                        <h1 class="section-title uk-text-center">
                            <?php echo sprintf( __('"%s" için arama sonuçları', 'leanfit'), esc_html(get_search_query()) ); ?>
                            <div class="search-count">
                                <?php echo sprintf('%s sonuç bulundu', $wp_query->found_posts); ?>
                            </div>
                        </h1>
                    </div>
                </div>
            </div>

            <div class="uk-grid-small uk-margin-xlarge-bottom uk-margin-medium-top" uk-grid>
                <?php
                if (have_posts()) :
                    $counter = 1;
                    while (have_posts()) : the_post();
                        $class = "uk-width-1-3@m uk-width-1-2@s uk-width-1-1";

                        global $product;
                        if ($product && is_a($product, 'WC_Product')) :
                        ?>
                        <div class="<?php echo esc_attr($class); ?>">
                            <div class="leanfit-product-layout product-item" data-item-id="<?php the_ID(); ?>" data-item-name="<?php the_title(); ?>" data-item-price="<?php echo esc_attr(get_post_meta(get_the_ID(), '_price', true)); ?>" data-item-currency="TRY" data-item-brand="LeanFit by Game">
                                <div class="uk-position-relative uk-overflow-hidden">
                                    <div class="uk-text-uppercase uk-position-absolute uk-position-z-index-2 product-icon">
                                        <i uk-icon="icn-vegan-green"></i> <?php echo esc_html(get_post_meta($product->get_id(), '_custom_badge', true)); ?>
                                    </div>
                                    <div class="uk-position-relative uk-position-z-index-zero product-image-box">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php 
                                            $product_image = get_the_post_thumbnail_url();
                                            if ($product_image) {
                                                $image_url = $product_image;
                                            } else {
                                                $image_url = get_template_directory_uri() . '/assets/image/placeholder.png';
                                            }
                                            ?>
                                            <img src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>" class="img-responsive" />
                                        </a>
                                    </div>
                                </div>

                                <div class="uk-position-relative product-details">
                                    <div class="uk-flex uk-flex-between uk-items-center">
                                        <div class="product-stars">
                                            <?php
                                            $average_rating = $product->get_average_rating();
                                            $comment_count = get_comments_number($product->get_id());
                                            $average_rating = $comment_count > 0 ? round($average_rating, 1) : 5;

                                            for ($i = 1; $i <= 5; $i++) {
                                                if ($i <= floor($average_rating)) {
                                                    echo '<span uk-icon="icn-star" class="star filled"></span>';
                                                } elseif ($i - 0.5 <= $average_rating) {
                                                    echo '<span uk-icon="icn-star-half" class="star half-filled"></span>';
                                                } else {
                                                    echo '<span uk-icon="icn-star-null" class="star"></span>';
                                                }
                                            }
                                            ?>
                                        </div>
                                        <p class="product-gr"><?php echo esc_html(get_post_meta($product->get_id(), '_custom_weight', true)); ?></p>
                                    </div>

                                    <h3 class="product-name">
                                        <a href="<?php the_permalink(); ?>" class="text-decoration-none" tabindex="0"><?php the_title(); ?></a>
                                    </h3>
                                    <p class="product-price">
                                        <span><?php echo price_format(get_post_meta(get_the_ID(), '_price', true)); ?></span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <?php
                        endif;
                        $counter++;
                    endwhile;

                    echo '<div class="uk-width-1-1 uk-text-center uk-margin-medium-top">';
                    echo paginate_links(array(
                        'prev_text' => '&larr;',
                        'next_text' => '&rarr;',
                        'type' => 'list',
                        'class' => 'uk-pagination uk-flex-center'
                    ));
                    echo '</div>';

                else :
                    echo '<div class="uk-width-1-1 uk-text-center">
                        <p class="uk-text-lead">Aramanızla eşleşen ürün bulunamadı.</p>
                        <p>Lütfen farklı arama terimleri kullanarak tekrar deneyin.</p>
                    </div>';
                endif;

                wp_reset_postdata();
                ?>
            </div>
        </div>
    </div>


<?php get_footer();?>