<?php
/*
Template Name: Community Page
*/

get_header();
?>

<script>document.querySelector(".header-all").classList.add("header-relative");</script>

<?php
$page_query = new WP_Query(array('page_id' => get_the_ID()));

if ($page_query->have_posts()) : while ($page_query->have_posts()) : $page_query->the_post();
    // Mevcut sayfanın ID'sini al
    $page_id = get_the_ID();
    
    // Üst blokları getir
    $top_blocks = get_post_meta($page_id, 'page_top_blocks', true);
    if (is_array($top_blocks) && !empty($top_blocks)) {
        foreach ($top_blocks as $block_id) {
            $block = get_block_by_id($block_id);
            if ($block) {
                $block_slug = sanitize_title($block->name);
                echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
            }
        }
    }

    // Sayfa içeriği
    if (get_the_content()) {
        echo '<div class="container">';
        the_content();
        echo '</div>';
    } ?>

<section class="section-blog-list">
    <div class="custom-container">
        <div class="uk-margin-xlarge">
            <div class="uk-grid uk-grid-small" uk-grid>
                <div class="uk-width-1-1">
                    <?php
                    $categories = get_categories(array(
                        'orderby' => 'term_id',
                        'order'   => 'ASC',
                        'hide_empty' => false,
                        'taxonomy' => 'category'
                    ));
                    
                    if(!empty($categories)) : ?>
                    <ul class="uk-tab uk-flex-wrap uk-flex-center uk-margin-large-bottom uk-flex-nowrap" uk-tab>
                        <?php foreach($categories as $index => $category) : ?>
                        <li class="<?php echo $index === 0 ? 'uk-active' : ''; ?>">
                            <a href="#"><span><?php echo esc_html($category->name); ?></span></a>
                        </li>
                        <?php endforeach; ?>
                    </ul>

                    <ul class="uk-switcher uk-margin">
                        <?php foreach($categories as $category) : ?>
                        <li>
                            <div class="uk-grid-large uk-grid-gap-medium uk-child-width-1-3@m uk-child-width-1-2@s uk-child-width-1-1" uk-grid>
                                <?php
                                $category_posts = new WP_Query(array(
                                    'post_type' => 'post',
                                    'category__in' => array($category->term_id),
                                    'posts_per_page' => 6,
                                    'post_status' => 'publish',
                                    'orderby' => 'date',
                                    'order' => 'DESC'
                                ));

                                if($category_posts->have_posts()) : 
                                    while($category_posts->have_posts()) : $category_posts->the_post();
                                        $thumbnail = get_the_post_thumbnail_url(get_the_ID(), 'large');
                                        $default_image = get_template_directory_uri() . '/assets/image/placeholder.png';
                                        $thumbnail = $thumbnail ? $thumbnail : $default_image;
                                ?>
                                <div>
                                    <div class="uk-inline-clip uk-width-1-1 uk-transition-toggle" tabindex="0">
                                        <a href="<?php the_permalink(); ?>">
                                            <img
                                                src="<?php echo esc_url($thumbnail); ?>"
                                                srcset="<?php echo esc_url($thumbnail); ?>, <?php echo esc_url($thumbnail); ?> 767w"
                                                class="uk-width-1-1 uk-transition-scale-up uk-transition-opaque"
                                                alt="<?php echo esc_attr(get_the_title()); ?>"
                                            />
                                        </a>
                                    </div>
                                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                    <p><?php echo wp_trim_words(get_the_excerpt(), 80); ?></p>
                                    <span class="border-bottom"></span>
                                </div>
                                <?php 
                                    endwhile;
                                else:
                                    echo '<div>Bu kategoride henüz yazı bulunmamaktadır.</div>';
                                endif;
                                wp_reset_postdata();
                                ?>
                            </div>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

    <?php
    // Orta blokları getir
    $middle_blocks = get_post_meta($page_id, 'page_middle_blocks', true);
    if (is_array($middle_blocks) && !empty($middle_blocks)) {
        foreach ($middle_blocks as $block_id) {
            $block = get_block_by_id($block_id);
            if ($block) {
                $block_slug = sanitize_title($block->name);
                echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
            }
        }
    }

    // Alt blokları getir
    $bottom_blocks = get_post_meta($page_id, 'page_bottom_blocks', true);
    if (is_array($bottom_blocks) && !empty($bottom_blocks)) {
        foreach ($bottom_blocks as $block_id) {
            $block = get_block_by_id($block_id);
            if ($block) {
                $block_slug = sanitize_title($block->name);
                echo do_shortcode("[dn_block {$block_slug} id=\"{$block_id}\"]");
            }
        }
    }
endwhile; endif;
wp_reset_postdata();
?>

<?php get_footer(); ?>