<?php

function custom_product_tabs_metabox() {
    add_meta_box(
        'custom_product_tabs',
        'Ürün Tabs Alanı',
        'render_custom_product_tabs_metabox',
        'product', // Sadece ürünler için
        'normal',
        'default'
    );
}
add_action('add_meta_boxes', 'custom_product_tabs_metabox');
function render_custom_product_tabs_metabox($post) {
    $tabs = get_post_meta($post->ID, '_custom_product_tabs', true);
    wp_nonce_field(basename(__FILE__), 'custom_product_tabs_nonce');
    ?>
    <div id="custom-product-tabs">
        <button type="button" class="button add-tab">+ Yeni Tab Ekle</button>
        <div id="tabs-container" style="margin-top: 15px;">
            <?php
            if (!empty($tabs)) {
                foreach ($tabs as $index => $tab) {
                    ?>
                    <div class="tab-item">
                        <div style="margin-bottom: 10px;">
                            <input type="text" name="custom_product_tabs[<?php echo $index; ?>][title]" placeholder="Tab Başlığı" value="<?php echo esc_attr($tab['title']); ?>" />
                        </div>
                        <?php
                        $editor_id = 'custom_product_tabs_' . $index;
                        $editor_settings = array(
                            'textarea_name' => "custom_product_tabs[$index][content]",
                            'media_buttons' => true,
                            'tinymce' => true,
                            'quicktags' => true
                        );
                        wp_editor($tab['content'], $editor_id, $editor_settings);
                        ?>
                        <button type="button" class="button remove-tab">Tabı Sil</button>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
    </div>

    <script>
        jQuery(document).ready(function($) {
            $('.add-tab').on('click', function() {
                var index = $('#tabs-container .tab-item').length;
                var tabHtml = '<div class="tab-item">';
                tabHtml += '<div style="margin-bottom: 10px;"><input type="text" name="custom_product_tabs[' + index + '][title]" placeholder="Tab Başlığı" /></div>';
                tabHtml += '<textarea id="custom_product_tabs_' + index + '" name="custom_product_tabs[' + index + '][content]"></textarea>';
                tabHtml += '<button type="button" class="button remove-tab">Tabı Sil</button>';
                tabHtml += '</div>';
                $('#tabs-container').append(tabHtml);

                tinymce.init({
                    selector: '#custom_product_tabs_' + index,
                    menubar: true,
                    plugins: 'lists link image fullscreen',
                    toolbar: 'undo redo | styleselect | bold italic underline strikethrough | forecolor backcolor | fontselect fontsizeselect | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | image media link | table tabledelete | tableprops tablerowprops tablecellprops | tableinsertrowbefore tableinsertrowafter tabledeleterow | tableinsertcolbefore tableinsertcolafter tabledeletecol | code preview fullscreen',
                    quickbars_insert_toolbar: 'quicktable',
                    branding: false
                });

            });

            $(document).on('click', '.remove-tab', function() {
                $(this).closest('.tab-item').remove();
            });
        });
    </script>

    <style>
        #custom-product-tabs .tab-item {
            margin-bottom: 10px;
            padding: 10px;
            background: #f9f9f9;
            border: 1px solid #ddd;
        }
        #custom-product-tabs .tab-item input {
            width: 100%;
            margin-bottom: 5px;
        }
    </style>
    <?php
}

function save_custom_product_tabs($post_id) {
    if (!isset($_POST['custom_product_tabs_nonce']) || !wp_verify_nonce($_POST['custom_product_tabs_nonce'], basename(__FILE__))) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['custom_product_tabs'])) {
        update_post_meta($post_id, '_custom_product_tabs', $_POST['custom_product_tabs']);
    } else {
        delete_post_meta($post_id, '_custom_product_tabs');
    }
}
add_action('save_post', 'save_custom_product_tabs');

function load_latest_tinymce($in) {
    $in['wordpress_adv_hidden'] = false;
    $in['theme_advanced_buttons3_add'] = 'anchor';
    return $in;
}
add_filter('tiny_mce_before_init', 'load_latest_tinymce');

// Icon Tab
function custom_product_icon_tabs_metabox() {
    add_meta_box(
        'custom_product_icon_tabs',
        'Ürün İkonlu Özellik Alanı',
        'render_custom_icon_tabs_metabox',
        'product',
        'normal',
        'default'
    );
}
add_action('add_meta_boxes', 'custom_product_icon_tabs_metabox');

function render_custom_icon_tabs_metabox($post) {
    $tabs = get_post_meta($post->ID, '_custom_icon_tabs', true);
    wp_nonce_field(basename(__FILE__), 'custom_icon_tabs_nonce');
    ?>
    <div id="custom-icon-tabs">
        <button type="button" class="button add-icon-tab">+ Yeni İkon Tab Ekle</button>
        <div id="icon-tabs-container" style="margin-top: 15px;">
            <?php
            if (!empty($tabs)) {
                foreach ($tabs as $index => $tab) {
                    ?>
                    <div class="icon-tab-item">
                        <div style="margin-bottom: 10px;">
                            <input type="text" name="custom_icon_tabs[<?php echo $index; ?>][icon]" placeholder="İkon Kodu Örn; icn-product-stamina" value="<?php echo esc_attr($tab['icon']); ?>" />
                            <input type="text" name="custom_icon_tabs[<?php echo $index; ?>][title]" placeholder="Tab Başlığı" value="<?php echo esc_attr($tab['title']); ?>" />
                        </div>
                        <button type="button" class="button remove-icon-tab">Tabı Sil</button>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
    </div>

    <script>
        jQuery(document).ready(function($) {
            $('.add-icon-tab').on('click', function() {
                var index = $('#icon-tabs-container .icon-tab-item').length;
                var tabHtml = '<div class="icon-tab-item">';
                tabHtml += '<input type="text" name="custom_icon_tabs[' + index + '][icon]" placeholder="İkon Kodu Örn; icn-product-stamina" />';
                tabHtml += '<input type="text" name="custom_icon_tabs[' + index + '][title]" placeholder="Tab Başlığı" />';
                tabHtml += '<button type="button" class="button remove-icon-tab">Tabı Sil</button>';
                tabHtml += '</div>';
                $('#icon-tabs-container').append(tabHtml);
            });

            $(document).on('click', '.remove-icon-tab', function() {
                $(this).closest('.icon-tab-item').remove();
            });
        });
    </script>

    <style>
        #custom-icon-tabs .icon-tab-item {
            margin-bottom: 10px;
            padding: 10px;
            background: #f9f9f9;
            border: 1px solid #ddd;
        }
        #custom-icon-tabs .icon-tab-item input {
            width: 100%;
            margin-bottom: 5px;
        }
    </style>
    <?php
}

function save_custom_icon_tabs($post_id) {
    // Güvenlik kontrolü: nonce doğrulama
    if (!isset($_POST['custom_icon_tabs_nonce']) || !wp_verify_nonce($_POST['custom_icon_tabs_nonce'], basename(__FILE__))) {
        return;
    }

    // Otomatik kaydetme kontrolü
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    // Kullanıcı izin kontrolü
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    // Tablar verisini kaydetme
    if (isset($_POST['custom_icon_tabs'])) {
        update_post_meta($post_id, '_custom_icon_tabs', $_POST['custom_icon_tabs']);
    } else {
        delete_post_meta($post_id, '_custom_icon_tabs');
    }
}

add_action('save_post', 'save_custom_icon_tabs');

// -----------------------------------------------------------------

function custom_product_blocks_metaboxes() {
    add_meta_box(
        'custom_product_top_block',
        'Üst Bloklar',
        'render_product_block_metabox',
        'product',
        'normal',
        'default',
        array('position' => 'top')
    );

    add_meta_box(
        'custom_product_center_block',
        'Orta Bloklar',
        'render_product_block_metabox',
        'product',
        'normal',
        'default',
        array('position' => 'center')
    );

    add_meta_box(
        'custom_product_bottom_block',
        'Alt Bloklar',
        'render_product_block_metabox',
        'product',
        'normal',
        'default',
        array('position' => 'bottom')
    );
}
add_action('add_meta_boxes', 'custom_product_blocks_metaboxes');

// Metabox içeriğini oluştur
function render_product_block_metabox($post, $metabox) {
    wp_nonce_field('product_blocks_nonce', 'product_blocks_nonce');
    $position = $metabox['args']['position'];
    $selected_blocks = get_post_meta($post->ID, '_product_' . $position . '_blocks', true);
    if (!is_array($selected_blocks)) $selected_blocks = array();

    // Veritabanından blokları al
    global $wpdb;
    $table_name = $wpdb->prefix . 'blocks';
    $blocks = $wpdb->get_results("SELECT * FROM $table_name");
    ?>
    <div class="product-blocks-container" style="display: flex; gap: 20px;">
        <!-- Sol taraf - Seçili bloklar -->
        <div class="selected-blocks" style="flex: 2;">
            <h4>Seçili Bloklar</h4>
            <ul class="sortable-blocks" data-position="<?php echo esc_attr($position); ?>" style="min-height: 100px; border: 1px dashed #ccc; padding: 10px;">
                <?php
                foreach ($selected_blocks as $block_id) {
                    $block = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $block_id));
                    if ($block) {
                        $block_id = '[dn_block '.sanitize_title($block->name).' id="'.sanitize_title($block->id).'"]';
                        echo sprintf(
                            '<li class="block-item" data-block-id="%d">
                                <div class="block-content">
                                    <span class="dashicons dashicons-move"></span>
                                    <span class="block-title">%s</span>
                                    <button type="button" class="remove-block button-link">
                                        <span class="dashicons dashicons-trash"></span>
                                    </button>
                                </div>
                            </li>',
                            $block->id,
                            esc_html($block->name)
                        );
                    }
                }
                ?>
            </ul>
            <input type="hidden" name="product_<?php echo $position; ?>_blocks" id="product_<?php echo $position; ?>_blocks"
                   value="<?php echo esc_attr(implode(',', $selected_blocks)); ?>">
        </div>

        <!-- Sağ taraf - Kullanılabilir bloklar -->
        <div class="available-blocks" style="flex: 1;">
            <h4>Kullanılabilir Bloklar</h4>
            <div class="blocks-list-container"> <!-- Yeni container div -->
                <ul class="blocks-list">
                    <?php
                    foreach ($blocks as $block) {

                        $block_id = '[dn_block '.sanitize_title($block->name).' id="'.sanitize_title($block->id).'"]';
                        echo sprintf(
                            '<li>
                        <button type="button" class="button add-block w-full" 
                                data-block-id="%d" 
                                data-block-title="%s">
                            %s
                        </button>
                    </li>',
                            $block->id,
                            esc_attr($block->name),
                            esc_html($block->name)
                        );
                    }
                    ?>
                </ul>
            </div>
        </div>
    </div>

    <style>
        .sortable-blocks { list-style: none; margin: 0; }
        .block-item {
            background: #fff;
            border: 1px solid #ddd;
            margin-bottom: 5px;
            padding: 8px;
            cursor: move;
        }
        .block-content {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .block-title { flex-grow: 1; }
        .remove-block { color: #dc3232; cursor: pointer; }
        .blocks-list { list-style: none; margin: 0; padding: 0; }
        .blocks-list li { margin-bottom: 5px; }
        .add-block { width: 100%; text-align: left; }
    </style>

    <script>
        jQuery(document).ready(function($) {
            // Sürükle-bırak fonksiyonalitesi
            $(".sortable-blocks").sortable({
                placeholder: "block-item-placeholder",
                update: function(event, ui) {
                    updateBlockOrder($(this));
                }
            });

            // Blok ekleme
            $(".add-block").on("click", function() {
                const blockId = $(this).data("block-id");
                const blockTitle = $(this).data("block-title");
                const position = $(this).closest(".product-blocks-container")
                    .find(".sortable-blocks").data("position");

                addBlockToList(blockId, blockTitle, position);
            });

            // Blok silme
            $(document).on("click", ".remove-block", function() {
                const blockItem = $(this).closest(".block-item");
                const sortableList = blockItem.parent();
                blockItem.remove();
                updateBlockOrder(sortableList);
            });

            // Blok sırasını güncelle
            function updateBlockOrder($sortable) {
                const blockIds = $sortable.find(".block-item")
                    .map(function() {
                        return $(this).data("block-id");
                    }).get();

                const position = $sortable.data("position");
                $(`#product_${position}_blocks`).val(blockIds.join(","));
            }

            // Yeni blok ekle
            function addBlockToList(blockId, blockTitle, position) {
                const $sortable = $(`.sortable-blocks[data-position="${position}"]`);

                // Bloğun zaten ekli olup olmadığını kontrol et
                if ($sortable.find(`[data-block-id="${blockId}"]`).length === 0) {
                    const newBlock = `
                    <li class="block-item" data-block-id="${blockId}">
                        <div class="block-content">
                            <span class="dashicons dashicons-move"></span>
                            <span class="block-title">${blockTitle}</span>
                            <button type="button" class="remove-block button-link">
                                <span class="dashicons dashicons-trash"></span>
                            </button>
                        </div>
                    </li>`;

                    $sortable.append(newBlock);
                    updateBlockOrder($sortable);
                }
            }
        });
    </script>
    <?php
}

// Metabox verilerini kaydet
function save_product_blocks($post_id) {
    if (!isset($_POST['product_blocks_nonce']) ||
        !wp_verify_nonce($_POST['product_blocks_nonce'], 'product_blocks_nonce')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    // Üst blokları kaydet
    if (isset($_POST['product_top_blocks'])) {
        $top_blocks = array_filter(explode(',', sanitize_text_field($_POST['product_top_blocks'])));
        update_post_meta($post_id, '_product_top_blocks', $top_blocks);
    }

    // Orta blokları kaydet
    if (isset($_POST['product_center_blocks'])) {
        $bottom_blocks = array_filter(explode(',', sanitize_text_field($_POST['product_center_blocks'])));
        update_post_meta($post_id, '_product_center_blocks', $bottom_blocks);
    }

    // Alt blokları kaydet
    if (isset($_POST['product_bottom_blocks'])) {
        $bottom_blocks = array_filter(explode(',', sanitize_text_field($_POST['product_bottom_blocks'])));
        update_post_meta($post_id, '_product_bottom_blocks', $bottom_blocks);
    }
}
add_action('save_post_product', 'save_product_blocks');