<footer>
    <section class="lean-footer">
        <div class="custom-container">
            <div class="uk-display-block">
                <div class="uk-grid-small uk-items-center" uk-grid>
                    <div class="uk-width-1-2">
                        <div class="footer-logo">
                            <a href="<?php bloginfo('url'); ?>"><img src="<?= theme_logo(); ?>" title="" alt="" class="img-responsive" /></a>
                        </div>
                    </div>

                    <div class="uk-width-1-2 uk-hidden@m">
                        <div class="scroll-top">
                            <a href="" uk-scroll><span uk-icon="icn-scroll-arrow-top"></span></a>
                        </div>
                    </div>

                    <div class="uk-width-1-2@l">
                        <div class="footer-menu">
                            <ul>
                                <?php get_menu_items_by_location("footer-menu"); ?>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="uk-grid-small uk-items-center uk-margin-large-bottom uk-margin-large-top" uk-grid>
                    <div class="uk-width-1-2@l">
                        <div class="uk-child-width-1-4@m uk-child-width-1-2 uk-grid" uk-grid>
                            <div style="max-width: 225px;">
                                <a href="#" target="_blank">
                                    <img src="<?php bloginfo('template_url'); ?>/assets/image/googleplay.svg" alt="Google Play Store" style="filter: invert(1) brightness(100%); opacity: .8;"/>
                                </a>
                            </div>
                            <div style="max-width: 225px;">
                                <a href="#" target="_blank">
                                    <img src="<?php bloginfo('template_url'); ?>/assets/image/appstore.svg" alt="App Store" style="filter: invert(1) brightness(100%); opacity: .8;" />
                                </a>
                            </div>
                        </div>
                        <div class="uk-width-2-3@l uk-margin-medium-top">
                            <img src="<?php bloginfo('template_url'); ?>/assets/image/payment-icons.png" alt="Payment Logos" style="filter: invert(1) brightness(100%);" />
                        </div>
                    </div>

                    <div class="uk-width-1-2@l">
                        <div class="footer-social">
                            <ul>
                                <li>
                                    <a href="https://facebook.com/" target="_self" title="Facebook LeanFit by Game"><span uk-icon="icon: icn-facebook;"></span></a>
                                </li>
                                <li>
                                    <a href="https://twitter.com" target="_self" title="Twitter LeanFit by Game"><span uk-icon="icon: icn-twitter;"></span></a>
                                </li>
                                <li>
                                    <a href="https://youtube.com" target="_self" title="YouTube LeanFit by Game"><span uk-icon="icon: icn-youtube;"></span></a>
                                </li>
                                <li>
                                    <a href="https://instagram.com/" target="_self" title="Instagram LeanFit by Game"><span uk-icon="icon: icn-instagram;"></span></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="uk-grid-small uk-items-center" uk-grid>
                    <div class="uk-width-1-2@l uk-hidden@l">
                        <div class="footer-menu footer-menu-mobile info">
                            <ul>
                                <?php get_menu_items_by_location("information-pages"); ?>
                            </ul>
                        </div>
                    </div>

                    <div class="uk-width-1-2@l">
                        <div class="footer-copyright">Copyright © 2025 LeanFit by Game. All rights reserved.</div>
                    </div>

                    <div class="uk-width-1-2@l uk-visible@l">
                        <div class="footer-menu info">
                            <ul>
                                <?php get_menu_items_by_location("information-pages"); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <style>
        div#account-order img {
            width: 20% !important;
        }
    </style>
</footer>

<!--<script src="--><?php //bloginfo('template_url'); ?><!--/assets/catalog/view/theme/leanfit/custom/app.js"></script>-->
<script>
    window.addEventListener("scroll", function () {
        const header = document.querySelector(".header-all");
        if (window.scrollY > 150) {
            header.classList.add("header-fixed");
        } else {
            header.classList.remove("header-fixed");
        }
    });
</script>

<script>
document.querySelectorAll(".cart-quantity-buttons").forEach((container) => {
    const minusBtn = container.querySelector(".minus");
    const plusBtn = container.querySelector(".plus");
    const qtyInput = container.querySelector(".qty-value");
    const productId = container.getAttribute('data-id');
    const cartKey = container.getAttribute('data-cart-key');

    function updateQuantity(newQty) {
        if (newQty >= 1) {
            container.style.opacity = '0.5';
            
            if (productId > 0) {
                jQuery.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'update_cart_item_quantity',
                        product_id: productId,
                        quantity: newQty
                    },
                    success: function(response) {
                        if(response.success) {
                            // Load cart modal content
                            jQuery.ajax({
                                url: ajaxurl,
                                type: 'POST',
                                data: {
                                    action: 'load_cart_modal'
                                },
                                success: function(modalContent) {
                                    document.querySelector('#cart').innerHTML = modalContent;
                                    container.style.opacity = '1';
                                    
                                    // Yeni eklenen butonlar için event listener'ları yeniden bağla
                                    initializeQuantityButtons();
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    minusBtn.addEventListener("click", () => {
        const currentValue = parseInt(qtyInput.value);
        if (currentValue > 1) {
            updateQuantity(currentValue - 1);
        }
    });

    plusBtn.addEventListener("click", () => {
        const currentValue = parseInt(qtyInput.value);
        updateQuantity(currentValue + 1);
    });
});

// Event listener'ları başlatma fonksiyonu
function initializeQuantityButtons() {
    document.querySelectorAll(".cart-quantity-buttons").forEach((container) => {
        const minusBtn = container.querySelector(".minus");
        const plusBtn = container.querySelector(".plus");
        const qtyInput = container.querySelector(".qty-value");
        const productId = container.getAttribute('data-id');
        const cartKey = container.getAttribute('data-cart-key');

        function updateQuantity(newQty) {
            if (newQty >= 1) {
                container.style.opacity = '0.5';
                
                if (productId > 0) {
                    jQuery.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'update_cart_item_quantity',
                            product_id: productId,
                            quantity: newQty
                        },
                        success: function(response) {
                            if(response.success) {
                                // Load cart modal content
                                jQuery.ajax({
                                    url: ajaxurl,
                                    type: 'POST',
                                    data: {
                                        action: 'load_cart_modal'
                                    },
                                    success: function(modalContent) {
                                        document.querySelector('#cart').innerHTML = modalContent;
                                        container.style.opacity = '1';
                                        
                                        // Yeni eklenen butonlar için event listener'ları yeniden bağla
                                        initializeQuantityButtons();
                                    }
                                });
                            }
                        }
                    });
                }
            }
        }

        minusBtn.addEventListener("click", () => {
            const currentValue = parseInt(qtyInput.value);
            if (currentValue > 1) {
                updateQuantity(currentValue - 1);
            }
        });

        plusBtn.addEventListener("click", () => {
            const currentValue = parseInt(qtyInput.value);
            updateQuantity(currentValue + 1);
        });
    });
}

// Sepetten ürün kaldırma işlemlerini başlatma fonksiyonu
function initializeRemoveButtons() {
    document.querySelectorAll(".remove-cart-item").forEach((button) => {
        button.addEventListener("click", function() {
            const cartKey = this.getAttribute('data-cart-item');
            const isCartPage = window.location.href.includes('/cart') || window.location.href.includes('/sepet');
            const isCheckoutPage = window.location.href.includes('/checkout') || window.location.href.includes('/odeme');
            
            // Sepet veya ödeme sayfasındaysa
            if (isCartPage || isCheckoutPage) {
                jQuery.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'remove_cart_item',
                        cart_item_key: cartKey
                    },
                    success: function(response) {
                        if(response.success) {
                            window.location.reload();
                        }
                    }
                });
            } else {
                // Diğer sayfalarda modal içeriğini güncelle
                jQuery.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'remove_cart_item',
                        cart_item_key: cartKey
                    },
                    success: function(response) {
                        if(response.success) {
                            // Cart modal içeriğini güncelle
                            jQuery.ajax({
                                url: ajaxurl,
                                type: 'POST',
                                data: {
                                    action: 'load_cart_modal'
                                },
                                success: function(modalContent) {
                                    document.querySelector('#cart').innerHTML = modalContent;
                                    // Event listener'ları yeniden bağla
                                    initializeQuantityButtons();
                                    initializeRemoveButtons();
                                }
                            });
                        }
                    }
                });
            }
        });
    });
}

// Sayfa yüklendiğinde tüm event listener'ları başlat
document.addEventListener('DOMContentLoaded', function() {
    initializeQuantityButtons();
    initializeRemoveButtons();
});
</script>

</body>
</html>