
<div class="offcanvas-header uk-position-sticky uk-flex uk-flex-between uk-flex-middle uk-flex-none">
    <h4 class="uk-margin-remove">My Cart</h4>
    <a href="#" class="uk-offcanvas-close uk-text-black uk-position-static uk-padding-remove">
        <span uk-icon="icn-close"></span>
    </a>
</div>

    <?php
    $cart_items = WC()->cart->get_cart();

    if ( !empty($cart_items) ) { ?>

<div class="offcanvas-body uk-flex uk-flex-column uk-flex-1">
    <?php
    foreach ( $cart_items as $item_key => $item ) {
            $product = $item['data']; // Ürün objesini al
            $product_name = $product->get_name(); // Ürün adı
            $product_url = get_permalink($product->get_id()); // Ürün URL'si
            $product_image_url = wp_get_attachment_url($product->get_image_id()); // Ürün görseli
            $product_price = wc_price($product->get_price()); // Ürün fiyatı
            $product_quantity = $item['quantity']; // Ürün miktarı
            $product_variation = isset($item['variation']) ? $item['variation'] : []; // Ürün varyasyonu
            $product_sku = $product->get_sku(); // Ürün SKU'su
            ?>

            <div class="product-horizontal">
                <div class="uk-grid uk-grid-small item-cart ps-0" uk-grid data-item="<?php echo esc_attr($item_key); ?>">
                    <div class="uk-width-1-4@m uk-width-1-4 uk-first-column">
                        <div class="image">
                            <a href="<?php echo esc_url($product_url); ?>">
                                <img src="<?php echo esc_url($product_image_url); ?>" alt="<?php echo esc_attr($product_name); ?>" title="<?php echo esc_attr($product_name); ?>" />
                            </a>
                        </div>
                    </div>

                    <div class="uk-width-3-4@m uk-width-3-4">
                        <div class="leo-cart-item-info uk-padding-small">
                            <div class="product-name-price">
                                <div class="product-name">
                                    <a class="label" href="<?php echo esc_url($product_url); ?>" title="<?php echo esc_attr($product_name); ?>"><?php echo esc_html($product_name); ?></a>
                                </div>
                                <div class="product-price">
                                    <div class="current-price">
                                        <span class="price"><?php echo $product_price; ?></span>
                                    </div>
                                </div>
                            </div>

                            <div class="product-additional">
                                <?php if ( !empty($product_variation) ) { ?>
                                    <div class="combinations">
                                        <?php foreach ($product_variation as $taxonomy => $term_id) {
                                            $taxonomy_name = wc_attribute_label($taxonomy);
                                            $term = get_term($term_id);
                                            $term_name = $term ? $term->name : '';
                                            ?>
                                            <div class="product-line-info">
                                                <span class="label-1"><?php echo esc_html($taxonomy_name); ?>:</span>
                                                <span class="value"><?php echo esc_html($term_name); ?></span>
                                            </div>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                            </div>

                            <div class="quantity-and-btns">
                                <div class="product-quantity-cart count-input">
                                    <span class="quantity-label">Miktar</span>
                                    <span>
                                        <a href="javascript:void(0)" onclick="checkout.count.cart_init(this, 'down', <?php echo esc_attr($product->get_id()); ?>)" class="leo-bt-product-quantity leo-bt-product-quantity-down">
                                            <i class="material-icons">-</i>
                                        </a>
                                        <input class="leo-input-product-quantity input-group product-quantity" readonly type="text" value="<?php echo esc_attr($product_quantity); ?>" />
                                        <a href="javascript:void(0)" onclick="checkout.count.cart_init(this, 'up', <?php echo esc_attr($product->get_id()); ?>)" class="leo-bt-product-quantity leo-bt-product-quantity-up">
                                            <i class="material-icons">+</i>
                                        </a>
                                    </span>
                                </div>

                                <div class="remove-and-favorites">
                                    <a href="javascript:void(0);" class="leo-remove-from-cart" data-item-id="<?php echo esc_attr($product->get_id()); ?>" onclick="removeFromCart(this);" title="Kaldır">Kaldır</a>
                                    <div class="wishlist">
                                        <?php
                                        $user_id = get_current_user_id();
                                        $in_favorites = false;

                                        if ($user_id > 0) {
                                            $wishlist = get_user_meta($user_id, '_user_favorites', true);
                                            if (is_array($wishlist) && in_array($product->get_id(), $wishlist)) {
                                                $in_favorites = true;
                                            }
                                        }
                                        ?>

                                        <a href="javascript:void(0);" class="leo-wishlist-button btn-product btn"
                                           data-item-id="<?php echo esc_attr($product->get_id()); ?>" onclick="toggleFavorite(this)">
                                            <?php echo $in_favorites ? 'Favorilerden Çıkar' : 'Favorilere Ekle'; ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
</div>

<div class="offcanvas-footer uk-background-default uk-position-sticky uk-position-bottom uk-margin-auto-top">
    <div class="uk-text-small basket-summary-detail uk-margin-auto-top">
        <!-- Kupon Kodu Bölümü -->
        <div class="uk-margin uk-margin-remove-top promotion-code">
            <div class="uk-position-relative">
                <input type="text" name="coupon_code" id="coupon_code" class="uk-input uk-padding-remove" placeholder="Hediye kartı veya indirim kodu" />
                <a href="javascript:void(0)" class="uk-button uk-position-center-right uk-padding-remove uk-background-none button-coupon" id="apply_coupon">Uygula</a>
            </div>
            <div id="coupon_response" class="uk-margin-small-top" style="display: none;"></div>
            
            <!-- Uygulanan Kuponlar Listesi -->
            <?php if (!empty(WC()->cart->get_applied_coupons())) : ?>
                <div class="applied-coupons uk-margin-small-top">
                    <?php foreach (WC()->cart->get_applied_coupons() as $coupon_code) : 
                        $coupon = new WC_Coupon($coupon_code);
                        $discount_amount = WC()->cart->get_coupon_discount_amount($coupon_code);
                    ?>
                        <div class="coupon-item uk-flex uk-flex-between uk-margin-small-bottom">
                            <div class="coupon-code">
                                <a href="javascript:void(0)" class="remove-coupon" data-coupon="<?php echo esc_attr($coupon_code); ?>">
                                    <span uk-icon="icn-close" style="width: 10px; height: 10px;"></span>
                                </a>
                                <?php echo esc_html($coupon_code); ?>
                            </div>
                            <div class="coupon-actions">
                                <span class="discount-amount">-<?php echo wc_price($discount_amount); ?></span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Sepet Özeti -->
        <div class="cart-dropdown-bottom uk-margin-medium-top">
            <!-- Ara Toplam -->
            <div class="cart-summary-row uk-flex uk-flex-between uk-margin-small-bottom">
                <span class="label uk-padding-remove-left">Ara Toplam</span>
                <span class="value"><?php echo wc_price(WC()->cart->get_subtotal()); ?></span>
            </div>
            
            <!-- İndirimler -->
            <?php if (WC()->cart->get_discount_total() > 0) : ?>
            <div class="cart-summary-row uk-flex uk-flex-between uk-margin-small-bottom">
                <span class="label uk-padding-remove-left">İndirimler</span>
                <span class="value discount">-<?php echo wc_price(WC()->cart->get_discount_total()); ?></span>
            </div>
            <?php endif; ?>
            
            <!-- Kargo -->
            <?php if (WC()->cart->get_shipping_total() > 0) : ?>
            <div class="cart-summary-row uk-flex uk-flex-between uk-margin-small-bottom">
                <span class="label uk-padding-remove-left">Kargo</span>
                <span class="value"><?php echo wc_price(WC()->cart->get_shipping_total()); ?></span>
            </div>
            <?php endif; ?>
            
            <!-- Genel Toplam -->
            <div class="cart-summary-row total uk-flex uk-flex-between uk-margin-small-top uk-text-bold">
                <span class="label uk-padding-remove-left">GENEL TOPLAM</span>
                <span class="value"><?php echo wc_price(WC()->cart->get_total('edit')); ?></span>
            </div>
        </div>

        <!-- Butonlar -->
        <a href="<?php echo esc_url(wc_get_checkout_url()); ?>" class="uk-button uk-button-cart uk-width-1-1 text-uppercase uk-margin-small-top">Ödeme</a>
        <div class="uk-text-center uk-margin-small-top">
            <a href="<?php echo esc_url(get_permalink(wc_get_page_id('shop'))); ?>" class="btn-none-bg-sm">Mağazaya Geri Dön</a>
        </div>
    </div>
</div>
<?php } else { ?>
        <div class="offcanvas-no-product uk-text-center uk-flex uk-flex-column uk-flex-center uk-flex-middle uk-flex-1 w-full h-full">
            <div class="basket-icon"><span uk-icon="icn-basket"></span></div>
            <p class="basket-no-product-text">There are no products in your basket yet.</p>
            <a href="" class="uk-button uk-button-primary uk-margin-top">BROWSE PRODUCTS</a>
        </div>
    <?php } ?>
