<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $product;

if ( ! comments_open() ) {
    return;
}

$product_id = get_the_ID();

// Tüm yorumları al
$comments = get_approved_comments($product_id);
$total_comments = count($comments);

// Transient kullanarak cache'leme
$cache_key = 'product_rating_data_' . $product_id;
$rating_data = get_transient($cache_key);

if(false === $rating_data) {
    $rating_counts = array(5 => 0, 4 => 0, 3 => 0, 2 => 0, 1 => 0);
    $total_rating = 0;

    foreach($comments as $comment) {
        $rating = get_comment_meta($comment->comment_ID, 'rating', true);
        if($rating) {
            $rating_counts[$rating]++;
            $total_rating += $rating;
        }
    }

    $average_rating = $total_comments > 0 ? round($total_rating / $total_comments, 2) : 0;

    set_transient($cache_key, [
        'average' => $average_rating,
        'total' => $total_comments,
        'counts' => $rating_counts
    ], HOUR_IN_SECONDS); // 1 saat cache'le
} else {
    $average_rating = $rating_data['average'];
    //$total_comments = $rating_data['total'];
    $rating_counts = $rating_data['counts'];
}

?>

<section class="uk-section section-review uk-padding-remove-bottom">
    <div class="custom-container">
        <div class="uk-grid">
            <div class="uk-width-1-1@s">
                <h2 class="section-title"><?= __( 'Yorumlar', 'leanfit' );?></h2>

                <div class="review-star">
                    <div class="uk-grid uk-grid-large uk-items-center align-items-center" uk-grid>
                        <div class="uk-width-2-12@xl uk-width-3-12@l uk-width-4-12@m uk-text-center">
                            <h3 class="review-score"><?php echo esc_html($average_rating); ?></h3>

                            <div class="product-stars product-stars-review">
                                <?php
                                // Tam yıldızlar
                                for($i = 1; $i <= round($average_rating); $i++) {
                                    echo '<span uk-icon="icn-star-2" class="star filled"></span>';
                                }
                                // Kalan yıldızlar
                                for($i = round($average_rating); $i <= 5; $i++) {
                                    echo '<span uk-icon="icn-star-null-2" class="star"></span>';
                                }
                                ?>
                            </div>

                            <h4 class="review-score-text"><?php echo sprintf( __('<span class="total-comments"> %s </span> incelemelerine göre', 'leanfit'), esc_html($total_comments) ); ?></h4>
                            <button class="uk-button uk-button-review" uk-toggle="target: #review-form-modal" type="button"><?php esc_html_e('Yorum Yap', 'leanfit'); ?></button>
                        </div>

                        <div class="uk-width-10-12@xl uk-width-9-12@l uk-width-8-12@m uk-visible@m progresses">
                            <?php
                            // Her rating için progress bar oluştur (5'ten 1'e)
                            for($i = 5; $i >= 1; $i--) {
                                $count = $rating_counts[$i];
                                $percentage = $total_comments > 0 ? $count : 0;
                                ?>
                                <div class="progress" data-progress-container="<?= $i; ?>">
                                    <div class="score"><?php echo esc_html($count); ?></div>
                                    <progress class="uk-progress" data-progress="<?= $i; ?>" value="<?php echo esc_attr($count); ?>" max="<?php echo esc_attr($total_comments); ?>"></progress>

                                    <div class="product-stars">
                                        <?php
                                        // Yıldızları oluştur
                                        for($j = 1; $j <= 5; $j++) {
                                            if($j <= $i) {
                                                echo '<span uk-icon="icn-star-2" class="star filled"></span>';
                                            } else {
                                                echo '<span uk-icon="icn-star-null-2" class="star"></span>';
                                            }
                                        }
                                        ?>
                                    </div>
                                </div>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <div class="review-list" id="product-reviews">


                
                    <?php


                    echo do_shortcode('[wc_photo_reviews_overall_rating_html product_id="'.$product_id.'" overall_rating_enable="on" rating_count_enable="on"]');

                    echo do_shortcode('[wc_photo_reviews_rating_html product_id="" rating="" review_count="on"]');
                    //echo do_shortcode('[woocommerce_photo_reviews_form product_id="" hide_product_details="" hide_product_price="" type="popup" button_position="center"]');
                    echo do_shortcode('[wc_photo_reviews_shortcode comments_per_page="12" cols="3" cols_mobile="1" use_single_product="on" cols_gap="" products="" grid_bg_color="" grid_item_bg_color="" grid_item_border_color="" text_color="" star_color="" product_cat="" order="" orderby="comment_date_gmt" show_product="on" filter="on" pagination="on" pagination_ajax="on" pagination_pre="" pagination_next="" loadmore_button="off" filter_default_image="off" filter_default_verified="off" filter_default_rating="" pagination_position="" conditional_tag="" custom_css="" ratings="" mobile="on" is_slide="on" style="masonry" masonry_popup="review" enable_box_shadow="on" full_screen_mobile="on" overall_rating="off" rating_count="off" only_images="off" image_popup="below_thumb"]');



                    /*wp_list_comments(
                        array(
                            'callback' => 'custom_woocommerce_product_review_list',
                            'style'    => 'ol',
                            'short_ping' => true,
                        ),
                        array_slice(get_comments(array(
                            'post_id' => $product->get_id(),
                            'status' => 'approve',
                            'orderby' => 'comment_date',
                            'order' => 'DESC',
                        )), 0, 3)
                    );*/
                    ?>
                </div>

                <?php /*if ( get_comment_count($product->get_id())['approved'] > 4 ) : ?>
                <div class="uk-text-center">
                    <button class="uk-button uk-load-more uk-text-uppercase" id="load-more-reviews" data-product-id="<?php echo $product->get_id(); ?>" data-page="2"><?php esc_html_e('Daha Fazla Yorum Gör', 'leanfit'); ?></button>
                </div>
                <?php endif;*/ ?>
            </div>
        </div>
    </div>
    <div id="review-form-modal" uk-modal>
        <div class="uk-modal-dialog uk-modal-body">
            <h2 class="uk-modal-title"><?php esc_html_e('Yorum Yap', 'leanfit'); ?></h2>
            <div class="review-form">
                <?php comment_form(); ?>
            </div>
        </div>
    </div>
</section>

<style>
    .shortcode-wcpr-overall-rating-and-rating-count, 
    .shortcode-wcpr-overall-rating-and-rating-count,
    .woocommerce-photo-reviews-rating-html-shortcode {
        display: none !important;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // var total_rating = document.querySelector('.shortcode-wcpr-overall-rating-right-total');
        var total_rating = document.querySelector('.shortcode-wcpr-filter-button-li .shortcode-wcpr-filter-button-count');
        if(total_rating) {
            total_rating = total_rating.textContent;
            total_rating = total_rating.replace(/\D/g, '');
            total_rating = parseInt(total_rating, 10);

            var total_comments = document.querySelector('.total-comments').textContent = total_rating;
            var avarage_rating = document.querySelector('.shortcode-wcpr-overall-rating-right-star .rating').textContent;
            document.querySelector('.review-score').textContent = avarage_rating;

            var star_html = ""
            for(var i = 1; i <= 5; i++) {
                if(i <= Math.round(avarage_rating)) {
                    star_html += '<span class="star filled"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 23 22" width="23" height="22"><path d="m11.5 0 2.694 8.291h8.719l-7.053 5.125 2.693 8.292-7.053-5.124-7.053 5.124 2.693-8.291L.087 8.291h8.719L11.5 0Z"></path></svg></span>';
                } else {
                    star_html += '<span class="star"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 22" width="24" height="22"><path d="m12 0 2.694 8.291h8.719l-7.053 5.125 2.693 8.292L12 16.584l-7.053 5.124 2.693-8.291L.587 8.291h8.719L12 0Z"></path></svg></span>';
                }
            }
            document.querySelector('.product-stars-review').innerHTML = star_html;

            const wpr_stars = document.querySelectorAll('.shortcode-wcpr-stars-count .shortcode-wcpr-row');
            wpr_stars.forEach(item => {
                const rank_star = item.querySelector('.shortcode-wcpr-col-number');
                const rank_count = item.querySelector('.shortcode-wcpr-col-process .rate-percent-bg .rate-percent');
                var progress = document.querySelector('.uk-progress[data-progress="'+parseInt(rank_star.textContent)+'"]');
                var progress_container = document.querySelector('.progress[data-progress-container="'+parseInt(rank_star.textContent)+'"]');

                const widthValue = parseInt(rank_count.style.width);
                
                var value = 0;
                value = Math.round((widthValue * total_rating) / 100);

                if(progress) {
                    progress.value = parseInt(value);
                    progress.setAttribute('max', parseInt(total_rating));
                    progress_container.querySelector('.score').textContent = parseInt(value);
                }
            });
        }
    });
</script>

<script>
jQuery(document).ready(function($) {
    // Event delegation ile, AJAX ile gelen butonlarda da çalışır
    $(document).on('click', '.wcpr-load-more-button', function() {
        var container = $('.wcpr-reviews-container');
        var loadMoreBtn = $(this);
        var loading = loadMoreBtn.data('loading') || false;

        if (loading) return;

        loadMoreBtn.data('loading', true);
        var spinner = loadMoreBtn.find('[uk-spinner]');
        spinner.removeClass('uk-hidden');
        loadMoreBtn.prop('disabled', true);

        var currentPage = parseInt(container.attr('data-current-page'));
        var totalPages = parseInt(container.attr('data-total-pages'));

        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>',
            type: 'POST',
            data: {
                action: 'load_more_photo_reviews',
                page: currentPage + 1,
                product_id: <?php echo (int)$product_id; ?>,
                security: '<?php echo wp_create_nonce('load-more-reviews'); ?>'
            },
            success: function(response) {
                if (response.success && response.data.html) {
                    container.append(response.data.html);
                    container.attr('data-current-page', currentPage + 1);

                    if (currentPage + 1 >= totalPages) {
                        loadMoreBtn.parent().fadeOut();
                    }

                    // UIkit güncelle
                    if (typeof UIkit !== 'undefined') {
                        UIkit.update();
                    }
                } else {
                    console.error('Error loading reviews:', response);
                    alert('Error loading more reviews. Please try again.');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error);
                alert('Error loading more reviews. Please try again.');
            },
            complete: function() {
                loadMoreBtn.data('loading', false);
                spinner.addClass('uk-hidden');
                loadMoreBtn.prop('disabled', false);
            }
        });
    });
});
</script>