
<section class="section-recipes">
    <div class="custom-container">
        <div class="uk-grid" uk-grid>
            <div class="uk-width-3-11@m">
                <h2 class="section-title"><?php echo $block->title; ?></h2>
            </div>
        </div>

        <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1" uk-slider>
            <div class="uk-slider-items" uk-grid>
                <?php foreach ($data_array as $recipe) : ?>
                    <div class="uk-width-10-12@m">
                        <div class="item-recipes">
                            <div class="uk-grid-match" uk-grid>
                                <div class="video-item uk-width-4-11@m">
                                    <div class="uk-card uk-width-1-1">
                                        <div class="uk-inline-clip uk-transition-toggle uk-width-1-1" tabindex="0">
                                            <div class="uk-inline-clip uk-width-1-1 uk-transition-toggle" tabindex="0">
                                                <img
                                                    src="<?php echo $recipe['image'] ?? ''; ?>"
                                                    class="uk-width-1-1 uk-transition-scale-up uk-transition-opaque"
                                                    alt="<?php echo $recipe['text'] ?? ''; ?>"
                                                />
                                            </div>

                                            <?php if (!empty($recipe['video_id'])) : ?>
                                                <a class="uk-position-center video-button" href="#video-modal-<?php echo $recipe['id'] ?? ''; ?>" uk-toggle>
                                                    <span uk-icon="icon: icn-video-play; ratio: 2"></span>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="uk-width-7-11@m">
                                    <div class="recipe-text">
                                        <h3><?php echo $recipe['text'] ?? ''; ?></h3>
                                        <p><?php echo $recipe['text3'] ?? ''; ?></p>

                                        <div class="uk-grid uk-grid-large uk-child-width-1-2@m uk-margin-medium-top" uk-grid>
                                            <div>
                                                <h4>Malzemeler</h4>
                                                <p><?php echo nl2br($recipe['ingredients'] ?? ''); ?></p>
                                            </div>
                                            <div>
                                                <h4>Hazırlanışı</h4>
                                                <p><?php echo nl2br($recipe['instructions'] ?? ''); ?></p>
                                            </div>
                                        </div>

                                        <?php if (!empty($recipe['recipe_images'])) : 
                                            $gallery_images = json_decode($recipe['recipe_images'], true);
                                        ?>
                                            <div class="recipe-images">
                                                <div class="uk-grid uk-child-width-1-6@xl uk-child-width-1-5@l uk-child-width-1-3 uk-grid-xsmall uk-grid-match" uk-lightbox="">
                                                    <?php foreach ($gallery_images as $image) : ?>
                                                        <a href="<?php echo $image['url']; ?>">
                                                            <img src="<?php echo $image['url']; ?>" alt="<?php echo $recipe['text'] ?? ''; ?>" />
                                                        </a>
                                                    <?php endforeach; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <?php if (!empty($recipe['video_id'])) : ?>
                                <div id="video-modal-<?php echo $recipe['id'] ?? ''; ?>" class="uk-flex-top uk-modal-container" uk-modal>
                                    <div class="uk-modal-dialog uk-modal-body uk-margin-auto-vertical uk-padding-remove">
                                        <div class="uk-responsive-width">
                                            <iframe src="https://www.youtube.com/embed/<?php echo $recipe['video_id']; ?>" 
                                                    class="uk-width-1-1" 
                                                    height="600" 
                                                    frameborder="0" 
                                                    allow="autoplay; encrypted-media" 
                                                    allowfullscreen 
                                                    uk-video>
                                            </iframe>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>