<section class="customer-comment-slideshow comments-all">
    <div class="uk-container">
        <div class="uk-grid uk-flex-center" uk-grid>
            <div class="uk-width-3-5@m uk-margin-large-bottom">
                <h2 class="section-title uk-text-center"><?php echo $block->title; ?></h2>
                <h3 class="section-subtitle uk-text-center"><?php echo $block->subtitle; ?></h3>
            </div>
        </div>
    </div>

    <?php
            //$homepage_reviews = get_all_reviews();
            $comment_args = array(
                'viwcpr_single_loadmore' => 1,
                'status' => 'approve',
                'post_type' => 'product',
                'post_status' => 'any',
                'parent' => 0,
            );

            $homepage_reviews = VI_WOOCOMMERCE_PHOTO_REVIEWS_Frontend_Frontend::get_comments(apply_filters('woocommerce_photo_reviews_shortcode_comment_args', $comment_args));
        
            // Yorum kartlarının renk sınıfları
            $color_classes = ['item-blue', 'item-red', 'item-yellow', 'item-orange', 'item-gray'];
            $color_index = 0;
            $color_class = "item-white";
    ?>

    <style>
        .comment-title {
            font-size: 1.8rem !important;
            line-height: 1.5 !important;
            font-weight: 600 !important;
            margin-bottom: 1rem !important;
        }
    </style>

    <div class="custom-container">
        <div class="uk-position-relative uk-visible-toggle uk-light">

        
            <div class="uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-4@m uk-child-width-1-5@l uk-child-width-1-6@xl uk-grid-small uk-grid-match uk-grid-medium comment-all-grid" uk-grid>
                <?php
                // Yorumları 3 kez tekrarla (12 kart oluştur)
                    foreach ($homepage_reviews as $review) {
                        $rating = get_comment_meta($review->comment_ID, 'rating', true);
                        $images = get_comment_meta( $review->comment_ID, 'reviews-images', true );

                        // Yazar ismini formatla (Duygu Altın -> Duygu A.)
                        $author = get_comment_author($review->comment_ID);
                        $name_parts = explode(' ', $author);
                        $formatted_name = $name_parts[0];
                        if (isset($name_parts[1])) {
                            $formatted_name .= ' ' . substr($name_parts[1], 0, 1) . '.';
                        }
                        ?>
                        <div>
                            <div class="comment-item <?php echo $color_class; ?>">
                                <div>
                                    <div class="comment-stars uk-margin-small-bottom">
                                        <?php for ($i = 1; $i <= 5; $i++) : ?>
                                            <span uk-icon="icn-star" class="star <?php echo ($i <= $rating) ? 'filled' : ''; ?>"></span>
                                        <?php endfor; ?>
                                    </div>

                                    <?php if ( $review_title ): ?>
                                        <h3 class="comment-title"><?php echo esc_html( $review_title ); ?></h3>
                                    <?php endif; ?>

                                    <p><?php echo wp_trim_words($review->comment_content, 30); ?></p>
                                </div>

                                <?php if (!empty($images) && is_array($images)) : ?>
                                    <div class="comment-images">
                                        <div class="uk-grid uk-child-width-1-3@m uk-child-width-1-2@s uk-child-width-1-2 uk-grid-xsmall uk-grid-match uk-grid-gap-medium" uk-lightbox>
                                            <?php foreach ($images as $img_post_id) : 
                                                if (!villatheme_is_url($img_post_id)) {
                                                    $image_url = wp_get_attachment_image_url($img_post_id, 'large');
                                                    $thumb_url = wp_get_attachment_image_url($img_post_id, 'thumbnail');
                                                    if ($image_url && $thumb_url) : ?>
                                                        <a href="<?php echo esc_url($image_url); ?>" class="uk-margin-small-bottom">
                                                            <img src="<?php echo esc_url($thumb_url); ?>" alt="<?php echo esc_attr($formatted_name); ?>" />
                                                        </a>
                                                    <?php endif;
                                                }
                                            endforeach; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <h3><?php echo esc_html($formatted_name); ?></h3>
                            </div>
                        </div>
                        <?php
                    }
                ?>
            </div>

        </div>
    </div>
</section>