jQuery(function($) {
    'use strict';

    var CheckoutHandler = {
        init: function() {
            this.initPaymentMethods();
        },

        initPaymentMethods: function() {
            $('form.checkout').on('change', 'input[name="payment_method"]', function() {
                var selectedMethod = $('input[name="payment_method"]:checked').val();
                
                if (selectedMethod === 'paytr') {
                    $('#paytr-payment-button').show();
                } else {
                    $('#paytr-payment-button').hide();
                }
            });

            // Trigger change on page load
            $('input[name="payment_method"]:checked').trigger('change');
        },

        showError: function(message) {
            $('.woocommerce-error, .woocommerce-message').remove();
            $('form.checkout').prepend(
                $('<div class="woocommerce-error">' + message + '</div>')
            );
            $('html, body').animate({
                scrollTop: $('.woocommerce-error').offset().top - 100
            }, 1000);
        }
    };

    // Initialize checkout handler
    CheckoutHandler.init();

    // İl değiştiğinde ilçeleri getir
    $('#billing_city, #shipping_city').on('change', function() {
        var cityId = $(this).val();
        var type = $(this).attr('id').split('_')[0];
        var districtSelect = $('#' + type + '_district');
        
        if (cityId) {
            $.ajax({
                url: wc_checkout_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'get_districts',
                    city_id: cityId,
                    nonce: wc_checkout_params.update_order_review_nonce
                },
                success: function(response) {
                    if (response.success) {
                        districtSelect.html('<option value="">' + wc_checkout_params.i18n_select_district_text + '</option>');
                        $.each(response.data, function(id, name) {
                            districtSelect.append($('<option></option>').val(id).text(name));
                        });
                    }
                }
            });
        }
    });

    // İlçe değiştiğinde mahalleleri getir
    $('#billing_district, #shipping_district').on('change', function() {
        var districtId = $(this).val();
        var type = $(this).attr('id').split('_')[0];
        var neighborhoodSelect = $('#' + type + '_neighborhood');
        
        if (districtId) {
            $.ajax({
                url: wc_checkout_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'get_neighborhoods',
                    district_id: districtId,
                    nonce: wc_checkout_params.update_order_review_nonce
                },
                success: function(response) {
                    if (response.success) {
                        neighborhoodSelect.html('<option value="">' + wc_checkout_params.i18n_select_neighborhood_text + '</option>');
                        $.each(response.data, function(id, name) {
                            neighborhoodSelect.append($('<option></option>').val(id).text(name));
                        });
                    }
                }
            });
        }
    });

    // Adres formlarını gönder
    $('#billing-address-form, #shipping-address-form').on('submit', function(e) {
        e.preventDefault();
        var $form = $(this);
        var type = $form.find('input[name="address_type"]').val();
        
        $.ajax({
            url: wc_checkout_params.ajax_url,
            type: 'POST',
            data: {
                action: 'save_address',
                form_data: $form.serialize(),
                nonce: wc_checkout_params.update_order_review_nonce
            },
            beforeSend: function() {
                $form.block({
                    message: null,
                    overlayCSS: {
                        background: '#fff',
                        opacity: 0.6
                    }
                });
            },
            success: function(response) {
                if (response.success) {
                    UIkit.modal('#detail-' + type).hide();
                    window.location.reload();
                } else {
                    alert(response.data.message || wc_checkout_params.i18n_checkout_error);
                }
            },
            complete: function() {
                $form.unblock();
            }
        });
    });

    // Adres seçimi kaydet
    window.saveBillingAddress = function() {
        var selectedAddress = $('input[name="billing_address_id"]:checked').val();
        if (!selectedAddress) {
            alert(wc_checkout_params.i18n_select_address);
            return;
        }

        $.ajax({
            url: wc_checkout_params.ajax_url,
            type: 'POST',
            data: {
                action: 'set_default_address',
                address_id: selectedAddress,
                address_type: 'billing',
                nonce: wc_checkout_params.update_order_review_nonce
            },
            success: function(response) {
                if (response.success) {
                    UIkit.modal('#billing-address').hide();
                    window.location.reload();
                }
            }
        });
    };

    window.saveShippingAddress = function() {
        var selectedAddress = $('input[name="shipping_address_id"]:checked').val();
        if (!selectedAddress) {
            alert(wc_checkout_params.i18n_select_address);
            return;
        }

        $.ajax({
            url: wc_checkout_params.ajax_url,
            type: 'POST',
            data: {
                action: 'set_default_address',
                address_id: selectedAddress,
                address_type: 'shipping',
                nonce: wc_checkout_params.update_order_review_nonce
            },
            success: function(response) {
                if (response.success) {
                    UIkit.modal('#shipping-address').hide();
                    window.location.reload();
                }
            }
        });
    };

    // Kupon kodu işlemleri
    $('#checkout-add-coupon').on('click', function() {
        var couponCode = $('#checkout-input-coupon').val();
        if (!couponCode) {
            alert(wc_checkout_params.i18n_coupon_code_required);
            return;
        }

        $.ajax({
            url: wc_checkout_params.ajax_url,
            type: 'POST',
            data: {
                action: 'apply_coupon',
                coupon_code: couponCode,
                nonce: wc_checkout_params.update_order_review_nonce
            },
            beforeSend: function() {
                $('.section-checkout-coupon').block({
                    message: null,
                    overlayCSS: {
                        background: '#fff',
                        opacity: 0.6
                    }
                });
            },
            success: function(response) {
                if (response.success) {
                    window.location.reload();
                } else {
                    alert(response.data.message || wc_checkout_params.i18n_coupon_error);
                }
            },
            complete: function() {
                $('.section-checkout-coupon').unblock();
            }
        });
    });
}); 