<?php
/**
 * Orders
 *
 * Shows orders on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/orders.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.5.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_account_orders' );
?>

<section class="section-account">
	<?php wc_get_template('myaccount/account-header.php'); ?>

	<div class="account-tabs">
		<ul class="uk-tab uk-flex-center">
			<li class="uk-active"><a href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>"><?php esc_html_e('Siparişlerim', 'leanfit'); ?></a></li>
			<li><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-account')); ?>"><?php esc_html_e('Üyelik Bilgilerim', 'leanfit'); ?></a></li>
			<li><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-address')); ?>"><?php esc_html_e('Adreslerim', 'leanfit'); ?></a></li>
			<li><a href="<?php echo esc_url(wc_get_account_endpoint_url('reviews')); ?>"><?php esc_html_e('Yorumlarım', 'leanfit'); ?></a></li>
		</ul>

		<style>
			@media (min-width: 1024px) {
				.no-desktop-container {
					width: auto;
					padding: 0;
				}
			}
		</style>

		<div class="custom-container">
			<div class="order-tab-content uk-grid uk-flex-center" uk-grid>

				<div class="uk-width-8-12@l uk-width-11-12@m">
				<?php if ( $has_orders ) : ?>
									<div class="order-groups">
							<?php
										// Siparişleri yıl ve aya göre grupla
										$grouped_orders = array();
							foreach ( $customer_orders->orders as $customer_order ) {
											$order = wc_get_order( $customer_order );
											$year = $order->get_date_created()->format('Y');
											$month = $order->get_date_created()->format('F');
											$grouped_orders[$year][$month][] = $order;
										}

										// Gruplanmış siparişleri göster
										foreach ( $grouped_orders as $year => $months ) : ?>
											<div class="order-group-item">
												<h2 class="order-year"><?php echo esc_html($year); ?></h2>

												<?php foreach ( $months as $month => $orders ) : ?>
													<div class="order-month"><?php echo esc_html($month); ?></div>

													<div class="order-items">
														<?php foreach ( $orders as $order ) :
								$item_count = $order->get_item_count() - $order->get_item_count_refunded();
															$order_items = $order->get_items();
															?>
															<div class="order-item">
																<div class="order-date"><?php echo esc_html($order->get_date_created()->format('d/m/Y')); ?></div>

																<div class="uk-grid uk-flex-between@m align-items-center">
																	<div class="uk-width-2-12@l uk-width-4-12@m uk-width-5-12">
																		<div class="order-number">
																			<?php esc_html_e('Sipariş Numarası', 'leanfit'); ?>
																			<span class="value"><?php echo $order->get_order_number(); ?></span>
																		</div>
																	</div>

																	<div class="uk-width-2-12@l uk-width-4-12@m uk-width-5-12">
																		<div class="order-price">
																			<?php esc_html_e('Tutar', 'leanfit'); ?>
																			<span class="value"><?php echo $order->get_formatted_order_total(); ?></span>
																		</div>
																	</div>

																	<div class="uk-width-4-12@m uk-pad">
																		<div class="order-product-images">
																			<div class="uk-grid uk-child-width-1-5@m uk-child-width-1-7 uk-grid-small">
																				<?php 
																				$shown_items = 0;
																				$remaining_items = 0;
																				foreach ($order_items as $item) {
																					$product = $item->get_product();
																					if ($product && $shown_items < 3) {
																						echo '<div>';
																						echo $product->get_image();
																						echo '</div>';
																						$shown_items++;
																					} else {
																						$remaining_items++;
																					}
																				}
																				if ($remaining_items > 0) {
																					echo '<div><div class="plus-product uk-flex uk-flex-center">+' . $remaining_items . '</div></div>';
																				}
																				?>
																			</div>
																		</div>
																	</div>

																	<div class="uk-width-2-12@l uk-width-4-12@m uk-width-6-12">
																		<div class="order-status">
																			<?php
																			$status = $order->get_status();
																			$pin_class = '';
																			switch ($status) {
																				case 'processing':
																					$pin_class = 'pin-black';
																					break;
																				case 'on-hold':
																				case 'pending':
																					$pin_class = 'pin-yellow';
																					break;
																				case 'completed':
																					$pin_class = 'pin-green';
																					break;
																				case 'cancelled':
																					$pin_class = 'pin-red';
																					break;
																				default:
																					$pin_class = 'pin-black';
																			}
																			?>
																			<span class="pin <?php echo esc_attr($pin_class); ?>"></span>
																			<?php echo esc_html(wc_get_order_status_name($order->get_status())); ?>
																		</div>
																	</div>

																	<div class="uk-width-1-12@l uk-width-8-12@m uk-width-6-12">
																		<div class="order-detail-link uk-text-right">
																			<a class="cursor-pointer" onclick="detailOpen('<?php echo esc_attr($order->get_id()); ?>')">
																				<?php esc_html_e('Detaylar', 'leanfit'); ?>
																				<span class="uk-icon" uk-icon="icon: icn-arrow-right"></span>
																			</a>
																		</div>
																	</div>
																</div>
															</div>
														<?php endforeach; ?>
													</div>
												<?php endforeach; ?>
											</div>
										<?php endforeach; ?>
									</div>

												<?php
									// Sipariş detaylarını göster
									foreach ( $customer_orders->orders as $customer_order ) :
										$order = wc_get_order( $customer_order );
										$order_id = $order->get_id();
										$order_items = $order->get_items();
										$order_status = $order->get_status();
										$payment_method = $order->get_payment_method_title();
										$shipping_method = $order->get_shipping_method();
										$tracking_number = get_post_meta($order_id, '_tracking_number', true);
										?>
										<div class="order-detail uk-hidden" id="detail-<?php echo esc_attr($order_id); ?>">
											<div class="custom-container no-desktop-container">
												<div class="order-back">
													<span onclick="detailClose()" class="uk-icon uk-margin-medium-right cursor-pointer" uk-icon="icon: icn-arrow-left"></span>
													<?php esc_html_e('Sipariş Detayı', 'leanfit'); ?>
												</div>

												<div class="order-summary">
													<div class="uk-grid">
														<div class="uk-width-2-12@l uk-width-4-12@m uk-width-6-12">
															<div class="value-item">
																<?php esc_html_e('Sipariş Numarası', 'leanfit'); ?>
																<span class="value"><?php echo $order->get_order_number(); ?></span>
															</div>
														</div>

														<div class="uk-width-2-12@l uk-width-4-12@m uk-width-6-12">
															<div class="value-item">
																<?php esc_html_e('Sipariş Tarihi', 'leanfit'); ?>
																<span class="value"><?php echo $order->get_date_created()->format('d/m/Y'); ?></span>
															</div>
														</div>

														<div class="uk-width-2-12@l uk-width-4-12@m uk-width-6-12">
															<div class="value-item">
																<?php esc_html_e('Sipariş Toplamı', 'leanfit'); ?>
																<span class="value"><?php echo count($order_items) . ' ' . _n('Ürün', 'Ürünler', count($order_items), 'leanfit'); ?></span>
															</div>
														</div>

														<div class="uk-width-2-12@l uk-width-4-12@m uk-width-6-12">
															<div class="value-item">
																<?php esc_html_e('Sipariş Durumu', 'leanfit'); ?>
																<span class="value"><?php echo wc_get_order_status_name($order_status); ?></span>
															</div>
														</div>

														<div class="uk-width-2-12@l uk-width-4-12@m">
															<div class="value-item">
																<?php esc_html_e('Ödeme Yöntemi', 'leanfit'); ?>
																<span class="value"><?php echo $payment_method; ?></span>
															</div>
														</div>

														<div class="uk-width-2-12@l uk-width-4-12@m uk-flex uk-flex-right@m">
															<div class="value-item">
																<?php esc_html_e('Toplam Tutar', 'leanfit'); ?>
																<span class="value"><?php echo $order->get_formatted_order_total(); ?></span>
															</div>
														</div>
													</div>
												</div>
											</div>

											<div class="shopping-summary">
												<div class="custom-container no-desktop-container">
													<h3 class="summary-title"><?php esc_html_e('Sipariş Özeti', 'leanfit'); ?></h3>
													<p class="summary-subtitle"><?php esc_html_e('Siparişleriniz teslimat durumuna göre görüntülenir.', 'leanfit'); ?></p>
												</div>

												<div class="custom-container shopping-container no-desktop-container">
													<div class="shopping-detail">
														<div class="order-tracking">
															<div class="custom-container">
																<div class="timeline">
																	<div class="progress-bar">
																		<?php
																		$progress = 0;
																		switch ($order_status) {
																			case 'pending':
																				$progress = 25;
																				break;
																			case 'processing':
																				$progress = 50;
																				break;
																			case 'shipped':
																			case 'on-hold':
																				$progress = 75;
																				break;
																			case 'completed':
																				$progress = 100;
																				break;
																		}
																		?>
																		<div class="progress" data-progress="<?php echo esc_attr($progress); ?>" style="width: <?php echo esc_attr($progress); ?>%;"></div>
																	</div>
																	<div class="steps">
																		<div class="step <?php echo $progress >= 25 ? 'completed' : ''; ?>">
																			<div class="step-point"></div>
																			<div class="step-label"><?php esc_html_e('Sipariş Verildi', 'leanfit'); ?></div>
																			<div class="step-date"><?php echo $order->get_date_created()->format('d/m/Y'); ?></div>
																		</div>
																		<div class="step <?php echo $progress >= 50 ? 'completed' : ''; ?>">
																			<div class="step-point"></div>
																			<div class="step-label"><?php esc_html_e('Hazırlanıyor', 'leanfit'); ?></div>
																			<div class="step-date"><?php echo $progress >= 50 ? $order->get_date_modified()->format('d/m/Y') : ''; ?></div>
																		</div>
																		<div class="step <?php echo $progress >= 75 ? 'completed' : ''; ?> <?php echo $progress == 75 ? 'current' : ''; ?>">
																			<div class="step-point"></div>
																			<div class="step-label"><?php esc_html_e('Kargolandı', 'leanfit'); ?></div>
																			<div class="step-date"><?php echo $progress >= 75 ? $order->get_date_modified()->format('d/m/Y') : ''; ?></div>
																		</div>
																		<div class="step <?php echo $progress >= 100 ? 'completed' : ''; ?>">
																			<div class="step-point"></div>
																			<div class="step-label"><?php esc_html_e('Teslim Edildi', 'leanfit'); ?></div>
																			<div class="step-date"><?php echo $progress >= 100 ? $order->get_date_completed()->format('d/m/Y') : ''; ?></div>
																		</div>
																	</div>
																</div>
															</div>
														</div>

														<?php if ($shipping_method) : ?>
															<div class="order-cargo">
																<div class="custom-container">
																	<div class="uk-grid uk-child-width-auto@l uk-child-width-1-2@l align-items-center">
																		<div>
																			<div class="value-item">
																				<?php esc_html_e('Tahmini Teslimat', 'leanfit'); ?>
																				<span class="value"><?php 
																					$delivery_date = strtotime('+7 days', $order->get_date_created()->getTimestamp());
																					echo date_i18n('F d-', $delivery_date) . date_i18n('F d, Y', strtotime('+14 days', $order->get_date_created()->getTimestamp())); 
																				?></span>
																			</div>
																		</div>

																		<?php if ($tracking_number) : ?>
																		<div>
																			<div class="value-item">
																				<?php esc_html_e('Teslimat Numarası', 'leanfit'); ?>
																				<span class="value"><?php echo esc_html($tracking_number); ?></span>
																			</div>
																		</div>
																		<?php endif; ?>

																		<div>
																			<div class="value-item">
																				<?php esc_html_e('Kargo Şirketi', 'leanfit'); ?>
																				<span class="value"><?php echo esc_html($shipping_method); ?></span>
																			</div>
																		</div>

																		<?php if ($tracking_number) : ?>
																		<div>
																			<div class="cargo-number">
																				<span class="uk-icon" uk-icon="icon: icn-cargo"></span>
																				<?php esc_html_e('Kargo Takip:', 'leanfit'); ?> <?php echo esc_html($tracking_number); ?>
																			</div>
																		</div>
																		<?php endif; ?>
																	</div>
																</div>
															</div>
														<?php endif; ?>

														<div class="order-products">
															<div class="custom-container">
																<?php foreach ($order_items as $item_id => $item) :
																	$product = $item->get_product();
																	if (!$product) continue;
																	
																	$regular_price = $product->get_regular_price();
																	$sale_price = $product->get_sale_price();
																	$discount_percentage = 0;
																	
																	if ($regular_price && $sale_price) {
																		$discount_percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
																	}
																?>
																<div class="uk-grid align-items-center">
																	<div class="uk-width-9-12@l align-items-center">
																		<div class="uk-grid uk-grid-xsmall uk-flex-start@m uk-flex-between align-items-center">
																			<div class="uk-width-5-11@m uk-width-7-11">
																				<div class="order-product uk-flex align-items-center">
																					<div class="order-product-image">
																						<?php echo $product->get_image(); ?>
																					</div>
																					<div class="order-product-name">
																						<?php echo esc_html($item->get_name()); ?>
																						<span class="order-product-quantity uk-hidden@s">
																							<?php esc_html_e('Adet', 'leanfit'); ?> 
																							<span class="value"><?php echo $item->get_quantity(); ?> <?php echo _n('Ürün', 'Ürünler', $item->get_quantity(), 'leanfit'); ?></span>
																						</span>
																					</div>
																				</div>
																			</div>
																			<div class="uk-width-6-11@m uk-width-auto">
																				<div class="uk-grid uk-child-width-auto@m uk-child-width-1-1@s align-items-center">
																					<div>
																						<div class="uk-flex@m uk-flex-right@m uk-flex-between align-items-center">
																							<?php if ($discount_percentage > 0) : ?>
																							<span class="order-discount-rate uk-visible@s">%<?php echo $discount_percentage; ?> <?php esc_html_e('İndirim', 'leanfit'); ?></span>
																							<?php endif; ?>
																							<span class="order-price"><?php echo wc_price($item->get_total()); ?></span>
																							<?php if ($regular_price && $sale_price) : ?>
																							<span class="order-discount-price"><?php echo wc_price($regular_price * $item->get_quantity()); ?></span>
																							<?php endif; ?>
																							<?php if ($discount_percentage > 0) : ?>
																							<span class="order-discount-rate uk-hidden@s">%<?php echo $discount_percentage; ?> <?php esc_html_e('İndirim', 'leanfit'); ?></span>
										<?php endif; ?>
																						</div>
																					</div>

																					<div class="uk-visible@s">
																						<span class="order-product-quantity">
																							<?php esc_html_e('Adet', 'leanfit'); ?> 
																							<span class="value"><?php echo $item->get_quantity(); ?> <?php echo _n('Ürün', 'Ürünler', $item->get_quantity(), 'leanfit'); ?></span>
																						</span>
																					</div>
																				</div>
																			</div>
																		</div>
																	</div>

																	<div class="uk-width-3-12@l">
																		<div class="uk-grid align-items-center uk-flex-between">
																			<div class="uk-width-auto@m uk-width-1-1">
																				<div class="order-status">
								<?php
																					$pin_class = '';
																					switch ($order_status) {
																						case 'processing':
																							$pin_class = 'pin-black';
																							break;
																						case 'on-hold':
																						case 'pending':
																							$pin_class = 'pin-yellow';
																							break;
																						case 'completed':
																							$pin_class = 'pin-green';
																							break;
																						case 'cancelled':
																							$pin_class = 'pin-red';
																							break;
																						default:
																							$pin_class = 'pin-black';
																					}
																					?>
																					<span class="pin <?php echo esc_attr($pin_class); ?>"></span>
																					<?php echo wc_get_order_status_name($order_status); ?>
																				</div>
																			</div>

																			<div class="uk-width-auto@m uk-width-1-1">
																				<div class="uk-grid uk-grid-large uk-flex-left@m uk-flex-between">
																					<?php if ($order->get_status() === 'completed') : ?>
																					<div>
																						<a href="<?php echo esc_url(add_query_arg(['comment_post_ID' => $product->get_id()], get_permalink($product->get_id()) . '#review_form')); ?>" class="review-button">
																							<?php esc_html_e('Ürün İnceleme', 'leanfit'); ?>
																						</a>
																					</div>
							<?php endif; ?>

																					<?php if ($order->get_status() === 'pending' || $order->get_status() === 'processing') : ?>
																					<div>
																						<a href="#" class="cancel-button" onclick="cancelOrder(event, <?php echo $order->get_id(); ?>)">
																							<?php esc_html_e('Siparişi İptal Et', 'leanfit'); ?>
																						</a>
																					</div>
																					<?php endif; ?>
						</div>
																			</div>
																		</div>
																	</div>
																</div>
																<?php endforeach; ?>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									<?php endforeach; ?>

				<?php else : ?>
					<div class="no-orders">
						<div class="no-order-icon">
							<span uk-icon="icon: icn-bag-2"></span>
						</div>
						<div class="no-order-title"><?php esc_html_e('Henüz sipariş vermediniz.', 'leanfit'); ?></div>
						<div class="no-order-subtitle"><?php esc_html_e('Hızlı ve kolay sipariş vermek için hemen ürünlerinize göz atın.', 'leanfit'); ?></div>
						<div class="uk-text-center uk-text-uppercase">
							<a href="<?php echo esc_url(apply_filters('woocommerce_return_to_shop_redirect', wc_get_page_permalink('shop'))); ?>" class="home-button-red"><?php esc_html_e('Ürünlere Göz At', 'leanfit'); ?></a>
						</div>
					</div>
				<?php endif; ?>
				</div>
				
			</div>
		</div>
	</div>
</section>

<script>
    var woocommerce_orders = {
        cancelOrderNonce: '<?php echo wp_create_nonce('cancel_order_nonce'); ?>'
    };

	var detailOpen = function (id) {
		var tabContent = document.querySelector(".order-groups");
		var orderDetail = document.getElementById("detail-" + id);

		// Scroll to top smoothly
		window.scrollTo({ top: 0, behavior: 'smooth' });

		// Önce animasyonu çalıştır
		tabContent.style.opacity = "0";
		tabContent.style.transform = "translateX(-100%)";
		
		// Detay panelini hazırla
		orderDetail.style.transform = "translateX(100%)";
		orderDetail.style.opacity = "0";
		orderDetail.classList.remove("uk-hidden");
		
		// Animasyon bittikten sonra gizle
		setTimeout(function() {
			tabContent.classList.add("uk-hidden");
			orderDetail.style.transform = "translateX(0)";
			orderDetail.style.opacity = "1";
			orderDetail.classList.add("active");
		}, 300);
	}

	var detailClose = function () {
		var tabContent = document.querySelector(".order-groups");
		var orderDetails = document.getElementsByClassName("order-detail");

		// Scroll to top smoothly
		window.scrollTo({ top: 0, behavior: 'smooth' });

		Array.from(orderDetails).forEach(function(item) {
			item.classList.remove("active");
			item.style.transform = "translateX(100%)";
			item.style.opacity = "0";
			
			setTimeout(function() {
				item.classList.add("uk-hidden");
				// Stilleri temizle
				item.style.transform = "";
				item.style.opacity = "";
			}, 300);
		});

		tabContent.classList.remove("uk-hidden");
		tabContent.style.transform = "translateX(-100%)";
		tabContent.style.opacity = "0";
		
		// Görünürlüğü sıfırla
		setTimeout(function() {
			tabContent.style.opacity = "1";
			tabContent.style.transform = "translateX(0)";
		}, 50);
	}

	function cancelOrder(event, orderId) {
		event.preventDefault();
		
		if (!confirm('<?php esc_html_e('Are you sure you want to cancel this order?', 'woocommerce'); ?>')) {
			return;
		}

		jQuery.ajax({
			url: '<?php echo admin_url('admin-ajax.php'); ?>',
			type: 'POST',
			data: {
				action: 'cancel_order',
				order_id: orderId,
				nonce: woocommerce_orders.cancelOrderNonce
			},
			beforeSend: function() {
				// You can add loading state here if needed
			},
			success: function(response) {
				if (response.success) {
					alert(response.data.message);
					window.location.href = response.data.redirect;
				} else {
					alert(response.data);
				}
			},
			error: function() {
				alert('<?php esc_html_e('An error occurred. Please try again.', 'woocommerce'); ?>');
			}
		});
	}
</script>

<?php do_action( 'woocommerce_after_account_orders' ); ?>
