<?php
/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

defined( 'ABSPATH' ) || exit;

$customer_id = get_current_user_id();

if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing'  => __( 'Fatura Adresi', 'woocommerce' ),
			'shipping' => __( 'Teslimat Adresi', 'woocommerce' ),
		),
		$customer_id
	);
} else {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing' => __( 'Fatura Adresi', 'woocommerce' ),
		),
		$customer_id
	);
}

$oldcol = 1;
$col    = 1;
?>

<section class="section-account">
    <?php 
    // Nonce'ları ekle
    wp_nonce_field('update-order-review', 'woocommerce-address-nonce');
    $address_nonce = wp_create_nonce('update-order-review');
    ?>
    <script>
    var addressSecurityNonce = '<?php echo $address_nonce; ?>';
    </script>

    <?php wc_get_template('myaccount/account-header.php'); ?>

    <div class="account-tabs">
        <ul class="uk-tab uk-flex-center">
            <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>"><?php esc_html_e('Siparişlerim', 'woocommerce'); ?></a></li>
            <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-account')); ?>"><?php esc_html_e('Üyelik Bilgilerim', 'woocommerce'); ?></a></li>
            <li class="uk-active"><a href="<?php echo esc_url(wc_get_account_endpoint_url('edit-address')); ?>"><?php esc_html_e('Adreslerim', 'woocommerce'); ?></a></li>
            <li><a href="<?php echo esc_url(wc_get_account_endpoint_url('reviews')); ?>"><?php esc_html_e('Yorumlarım', 'woocommerce'); ?></a></li>
        </ul>

        <!-- Adres var ise / addresses Start -->
		 

        <div class="addresses uk-grid uk-flex-center" uk-grid>
			<div class="uk-width-8-12@l uk-width-11-12@m">
				<div class="address-items">
					<div class="custom-container">
						
					<div class="uk-grid uk-grid-small uk-flex-center">
						<?php
						global $wpdb;
						$user_id = get_current_user_id();
						
						// Kullanıcının adreslerini getir
						$addresses = $wpdb->get_results($wpdb->prepare(
							"SELECT * FROM {$wpdb->prefix}user_addresses 
							WHERE user_id = %d 
							ORDER BY id ASC",
							$user_id
						));

						if ($addresses) : 
							$counter = 0; // Sayaç ekle
							foreach ($addresses as $address) :
								$counter++; // Her adres için sayacı artır
								
								// İl, ilçe ve mahalle bilgilerini al
								$city_name = $wpdb->get_var($wpdb->prepare(
									"SELECT il_adi FROM {$wpdb->prefix}iller WHERE id = %d",
									$address->city_id
								));
								
								$district_name = $wpdb->get_var($wpdb->prepare(
									"SELECT ilce_adi FROM {$wpdb->prefix}ilceler WHERE id = %d",
									$address->district_id
								));
								
								$neighborhood_name = $wpdb->get_var($wpdb->prepare(
									"SELECT semt_adi FROM {$wpdb->prefix}semtler WHERE id = %d",
									$address->neighborhood_id
								));
						?>
						<div class="uk-width-1-1@s uk-width-1-2@m">
							<div class="address-item">
								
							<div class="address-info">
											<div class="uk-grid uk-child-width-1-1 uk-row-gap-20">
												<div>
													<div class="uk-grid uk-flex-between">
														<div>
															<h3><?php echo $address->address_type === 'billing' ? esc_html__('Fatura Adresi', 'woocommerce') : esc_html__('Teslimat Adresi', 'woocommerce'); ?></h3>
														</div>
														<div>
															<div class="uk-grid uk-grid-medium">
																<div>
																	<a onclick="detailOpen(<?php echo esc_attr($address->id); ?>)" class="button-text">
																		<?php esc_html_e('Düzenle', 'woocommerce'); ?>
																	</a>
																</div>
																<div>
																	<a href="#" class="button-text delete-address" data-address="<?php echo esc_attr($address->id); ?>">
																		<?php esc_html_e('Sil', 'woocommerce'); ?>
																	</a>
																</div>
															</div>
														</div>
													</div>
												</div>

												<div>
													<p>
														<?php if (!empty($address->address_title)) : ?>
															<?php echo esc_html($address->address_title); ?>,<br>
														<?php endif; ?>
														<?php echo esc_html($address->first_name . ' ' . $address->last_name); ?>
														<?php /*if (!empty($address->company)) : ?>
															<br><?php echo esc_html($address->company); ?>
														<?php endif; */?>
													</p>
												</div>
												<div>
													<p>
														<?php echo esc_html($address->address_1); ?><br>
														<?php if ($neighborhood_name) echo esc_html($neighborhood_name) . ' /'; ?>
														<?php if ($district_name) echo esc_html($district_name) . ' /'; ?>
														<?php echo esc_html($city_name); ?>
													</p>
												</div>
											</div>
										</div>
							</div>
						</div>

						<?php 
						// Her iki kayıttan sonra çizgi ekle
						if ($counter % 2 == 0 && $counter < count($addresses)) : ?>
							<div class="uk-width-1-1@s"><div class="uk-hr"></div></div>
						<?php endif; ?>

						<?php endforeach; ?>
						</div>
						<?php else : ?>
							<div class="uk-width-1-1 uk-margin-medium-top">
								<p class="woocommerce-Message uk-text-center">
									<?php esc_html_e('Henüz herhangi bir adres eklemediniz.', 'woocommerce'); ?>
								</p>
							</div>
						<?php endif; ?>

						<div class="uk-grid uk-flex-center">
							<div class="uk-section-small uk-text-center">
								<a onclick="detailOpen('new')" class="lean-button-red">
									<?php esc_html_e('YENİ ADRES EKLE', 'woocommerce'); ?>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
        <!-- addresses end -->

		<?php if ($addresses) : 
			foreach ($addresses as $address) : ?>
				<div class="address-edit uk-hidden" id="detail-<?php echo esc_attr($address->id); ?>">
					<div class="custom-container">
						<div class="uk-grid uk-flex-center">
							<div class="uk-width-4-11@l uk-width-5-11@m uk-width-7-11@s">
								<div class="uk-grid uk-flex-between align-items-center uk-margin-medium-bottom">
									<div>
										<h2 class="title uk-margin-remove">
											<?php printf(
												__('Edit %s', 'woocommerce'), 
												$address->address_type === 'billing' ? __('Billing Address', 'woocommerce') : __('Delivery Address', 'woocommerce')
											); ?>
										</h2>
									</div>
									<div>
										<button class="close-button" type="button" onclick="detailClose()"><span uk-icon="icon: icn-close"></span></button>
									</div>
								</div>

								<form method="post" class="lean-form edit-address-form" data-address-type="<?php echo esc_attr($address->address_type); ?>" data-address-id="<?php echo esc_attr($address->id); ?>">
									<?php wp_nonce_field('woocommerce-edit_address', 'woocommerce-edit-address-nonce'); ?>
									<input type="hidden" name="action" value="edit_address" />
									<input type="hidden" name="address_id" value="<?php echo esc_attr($address->id); ?>" />
									<input type="hidden" name="address_type" value="<?php echo esc_attr($address->address_type); ?>" />

									<div class="uk-margin form-floating">
										<input class="uk-input" type="text" name="address_title" id="<?php echo esc_attr($address->address_type); ?>_title_<?php echo esc_attr($address->id); ?>" value="<?php echo esc_attr($address->address_title); ?>" placeholder=" ">
										<label for="<?php echo esc_attr($address->address_type); ?>_title_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('Adres Başlığı', 'leanfit'); ?></label>
									</div>

									<div class="uk-margin form-floating">
										<input class="uk-input" type="text" name="first_name" id="<?php echo esc_attr($address->address_type); ?>_first_name_<?php echo esc_attr($address->id); ?>" value="<?php echo esc_attr($address->first_name); ?>" placeholder=" " required>
										<label for="<?php echo esc_attr($address->address_type); ?>_first_name_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('Ad', 'leanfit'); ?></label>
									</div>

									<div class="uk-margin form-floating">
										<input class="uk-input" type="text" name="last_name" id="<?php echo esc_attr($address->address_type); ?>_last_name_<?php echo esc_attr($address->id); ?>" value="<?php echo esc_attr($address->last_name); ?>" placeholder=" " required>
										<label for="<?php echo esc_attr($address->address_type); ?>_last_name_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('Soyad', 'leanfit'); ?></label>
									</div>

									<div class="uk-margin form-floating">
										<input class="uk-input" type="tel" name="phone" id="<?php echo esc_attr($address->address_type); ?>_phone_<?php echo esc_attr($address->id); ?>" value="<?php echo esc_attr($address->phone); ?>" placeholder=" " required>
										<label for="<?php echo esc_attr($address->address_type); ?>_phone_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('Telefon', 'leanfit'); ?></label>
									</div>

									<div class="uk-margin form-floating">
										<input class="uk-input" type="text" name="company" id="<?php echo esc_attr($address->address_type); ?>_company_<?php echo esc_attr($address->id); ?>" value="<?php echo esc_attr($address->company); ?>" placeholder=" ">
										<label for="<?php echo esc_attr($address->address_type); ?>_company_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('Şirket Adı (İsteğe Bağlı)', 'leanfit'); ?></label>
									</div>

									<div class="uk-margin form-floating">
										<input class="uk-input" type="text" name="country" id="<?php echo esc_attr($address->address_type); ?>_country_<?php echo esc_attr($address->id); ?>" value="Türkiye" placeholder=" " readonly>
										<label for="<?php echo esc_attr($address->address_type); ?>_country_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('Ülke', 'leanfit'); ?></label>
									</div>

									<div class="uk-margin form-floating">
										<select class="uk-select" name="city" id="<?php echo esc_attr($address->address_type); ?>_city_<?php echo esc_attr($address->id); ?>" required 
											data-selected="<?php echo esc_attr($address->city_id); ?>">
											<option value=""><?php esc_html_e('Select a city', 'woocommerce'); ?></option>
										</select>
										<label for="<?php echo esc_attr($address->address_type); ?>_city_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('Şehir', 'leanfit'); ?></label>
									</div>

									<div class="uk-margin form-floating">
										<select class="uk-select" name="district" id="<?php echo esc_attr($address->address_type); ?>_district_<?php echo esc_attr($address->id); ?>" required
											data-selected="<?php echo esc_attr($address->district_id); ?>">
											<option value=""><?php esc_html_e('Select a district', 'woocommerce'); ?></option>
										</select>
										<label for="<?php echo esc_attr($address->address_type); ?>_district_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('İlçe', 'leanfit'); ?></label>
									</div>

									<div class="uk-margin form-floating">
										<select class="uk-select" name="neighborhood" id="<?php echo esc_attr($address->address_type); ?>_neighborhood_<?php echo esc_attr($address->id); ?>" required
											data-selected="<?php echo esc_attr($address->neighborhood_id); ?>">
											<option value=""><?php esc_html_e('Select a neighborhood', 'woocommerce'); ?></option>
										</select>
										<label for="<?php echo esc_attr($address->address_type); ?>_neighborhood_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('Mahalle', 'leanfit'); ?></label>
									</div>

									<div class="uk-margin form-floating">
										<input class="uk-input" type="text" name="address_1" id="<?php echo esc_attr($address->address_type); ?>_address_1_<?php echo esc_attr($address->id); ?>" value="<?php echo esc_attr($address->address_1); ?>" placeholder=" " required>
										<label for="<?php echo esc_attr($address->address_type); ?>_address_1_<?php echo esc_attr($address->id); ?>"><?php esc_html_e('Sokak Adresi', 'woocommerce'); ?></label>
									</div>

									<div class="uk-text-center uk-section-small">
										<button type="submit" class="uk-button save-button uk-width-1-1@s uk-text-uppercase">
											<?php esc_html_e('Adresi Kaydet', 'leanfit'); ?>
										</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			<?php endforeach; 
		endif; ?>

		<!-- Yeni adres ekleme formu -->
		<div class="address-edit uk-hidden" id="detail-new">
			<div class="custom-container">
				<div class="uk-grid uk-flex-center">
					<div class="uk-width-4-11@l uk-width-5-11@m uk-width-7-11@s">
						<div class="uk-grid uk-flex-between align-items-center uk-margin-medium-bottom">
							<div>
								<h2 class="title uk-margin-remove"><?php esc_html_e('Yeni Adres Ekle', 'woocommerce'); ?></h2>
							</div>
							<div>
								<button class="close-button" type="button" onclick="detailClose()"><span uk-icon="icon: icn-close"></span></button>
							</div>
						</div>

						<form method="post" class="lean-form add-address-form">
							<?php wp_nonce_field('woocommerce-add_address', 'woocommerce-add-address-nonce'); ?>
							<input type="hidden" name="action" value="add_address" />

							<div class="uk-margin form-floating">
								<input class="uk-input" type="text" name="address_title" id="new_address_title" placeholder=" ">
								<label for="new_address_title"><?php esc_html_e('Adres Başlığı', 'leanfit'); ?></label>
							</div>

							<div class="uk-margin form-floating">
								<input class="uk-input" type="text" name="first_name" id="new_first_name" placeholder=" " required>
								<label for="new_first_name"><?php esc_html_e('Ad', 'leanfit'); ?></label>
							</div>

							<div class="uk-margin form-floating">
								<input class="uk-input" type="text" name="last_name" id="new_last_name" placeholder=" " required>
								<label for="new_last_name"><?php esc_html_e('Soyad', 'leanfit'); ?></label>
							</div>

							<div class="uk-margin form-floating">
								<input class="uk-input" type="tel" name="phone" id="new_phone" placeholder=" " required>
								<label for="new_phone"><?php esc_html_e('Telefon', 'leanfit'); ?></label>
							</div>

							<div class="uk-margin form-floating">
								<input class="uk-input" type="text" name="company" id="new_company" placeholder=" ">
								<label for="new_company"><?php esc_html_e('Şirket Adı (İsteğe Bağlı)', 'leanfit'); ?></label>
							</div>

							<div class="uk-margin form-floating">
								<input class="uk-input" type="text" name="country" id="new_country" value="Türkiye" placeholder=" " readonly>
								<label for="new_country"><?php esc_html_e('Ülke', 'leanfit'); ?></label>
							</div>

							<div class="uk-margin form-floating">
								<select class="uk-select" name="city" id="new_city" required>
									<option value=""><?php esc_html_e('Select a city', 'woocommerce'); ?></option>
								</select>
								<label for="new_city"><?php esc_html_e('Şehir', 'leanfit'); ?></label>
							</div>

							<div class="uk-margin form-floating">
								<select class="uk-select" name="district" id="new_district" required>
									<option value=""><?php esc_html_e('Select a district', 'leanfit'); ?></option>
								</select>
								<label for="new_district"><?php esc_html_e('İlçe', 'leanfit'); ?></label>
							</div>

							<div class="uk-margin form-floating">
								<select class="uk-select" name="neighborhood" id="new_neighborhood" required>
									<option value=""><?php esc_html_e('Select a neighborhood', 'woocommerce'); ?></option>
								</select>
								<label for="new_neighborhood"><?php esc_html_e('Mahalle', 'leanfit'); ?></label>
							</div>

							<div class="uk-margin form-floating">
								<input class="uk-input" type="text" name="address_1" id="new_address_1" placeholder=" " required>
								<label for="new_address_1"><?php esc_html_e('Sokak Adresi', 'leanfit'); ?></label>
							</div>

							<div class="uk-text-center uk-section-small">
								<button type="submit" class="uk-button save-button uk-width-1-1@s uk-text-uppercase">
									<?php esc_html_e('Adresi Kaydet', 'leanfit'); ?>
								</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
    </div>
</section>

<script>
jQuery(document).ready(function($) {
	// İlleri yükle ve seçili olanı işaretle
	function loadCities(selectElement, selectedCityId = null) {
		if (!selectElement) {
			console.error('Select element not found');
			return;
		}

		var $select = $(selectElement);
		
		$.ajax({
			url: woocommerce_params.ajax_url,
			type: 'POST',
			data: {
				action: 'get_cities',
				security: addressSecurityNonce
			},
			success: function(response) {
				if (response.success) {
					// Mevcut seçenekleri temizle (ilk seçenek hariç)
					$select.find('option:not(:first)').remove();
					
					// Yeni seçenekleri ekle
					$.each(response.data, function(index, item) {
						var $option = $('<option></option>')
							.val(item.id)
							.text(item.name);
							
						if (selectedCityId && selectedCityId == item.id) {
							$option.prop('selected', true);
						}
						
						$select.append($option);
					});
					
					// Seçili şehir varsa ilçeleri yükle
					if (selectedCityId) {
						var $districtSelect = $select.closest('form').find('select[name="district"]');
						loadDistricts($districtSelect[0], selectedCityId, $districtSelect.data('selected'));
					}
				}
			}
		});
	}

	// İlçeleri yükle ve seçili olanı işaretle
	function loadDistricts(selectElement, cityId, selectedDistrictId = null) {
		if (!cityId) return;
		
		var $select = $(selectElement);
		
		$.ajax({
			url: woocommerce_params.ajax_url,
			type: 'POST',
			data: {
				action: 'get_districts',
				city_id: cityId,
				security: addressSecurityNonce
			},
			success: function(response) {
				if (response.success) {
					$select.find('option:not(:first)').remove();
					$.each(response.data, function(index, item) {
						var $option = $('<option></option>')
							.val(item.id)
							.text(item.name);
							
						if (selectedDistrictId && selectedDistrictId == item.id) {
							$option.prop('selected', true);
						}
						
						$select.append($option);
					});
					
					// Seçili ilçe varsa semtleri yükle
					if (selectedDistrictId) {
						var $neighborhoodSelect = $select.closest('form').find('select[name="neighborhood"]');
						loadNeighborhoods($neighborhoodSelect[0], selectedDistrictId, $neighborhoodSelect.data('selected'));
					}
				}
			}
		});
	}

	// Semtleri yükle ve seçili olanı işaretle
	function loadNeighborhoods(selectElement, districtId, selectedNeighborhoodId = null) {
		if (!districtId) return;
		
		var $select = $(selectElement);
		
		$.ajax({
			url: woocommerce_params.ajax_url,
			type: 'POST',
			data: {
				action: 'get_neighborhoods',
				district_id: districtId,
				security: addressSecurityNonce
			},
			success: function(response) {
				if (response.success) {
					$select.find('option:not(:first)').remove();
					$.each(response.data, function(index, item) {
						var $option = $('<option></option>')
							.val(item.id)
							.text(item.name);
							
						if (selectedNeighborhoodId && selectedNeighborhoodId == item.id) {
							$option.prop('selected', true);
						}
						
						$select.append($option);
					});
				}
			}
		});
	}

	// İl değiştiğinde ilçeleri yükle
	$(document).on('change', 'select[name="city"]', function() {
		var cityId = $(this).val();
		var $form = $(this).closest('form');
		var $districtSelect = $form.find('select[name="district"]');
		var $neighborhoodSelect = $form.find('select[name="neighborhood"]');
		
		if (cityId) {
			loadDistricts($districtSelect[0], cityId);
			$districtSelect.find('option:not(:first)').remove();
			$neighborhoodSelect.find('option:not(:first)').remove();
		}
	});

	// İlçe değiştiğinde semtleri yükle
	$(document).on('change', 'select[name="district"]', function() {
		var districtId = $(this).val();
		var $form = $(this).closest('form');
		var $neighborhoodSelect = $form.find('select[name="neighborhood"]');
		
		if (districtId) {
			loadNeighborhoods($neighborhoodSelect[0], districtId);
		}
	});

	// detailOpen fonksiyonunu düzenle
	window.detailOpen = function(id) {
		var tabContent = document.querySelector(".address-items");
		var orderDetail = document.getElementById("detail-" + id);
		var addresses = document.querySelector(".addresses");

		// Scroll to top smoothly
		window.scrollTo({ top: 0, behavior: 'smooth' });

		// Önce animasyonu çalıştır
		tabContent.style.opacity = "0";
		tabContent.style.transform = "translateX(-100%)";
		
		// Detay panelini hazırla
		orderDetail.style.transform = "translateX(100%)";
		orderDetail.style.opacity = "0";
		orderDetail.classList.remove("uk-hidden");
		
		// Animasyon bittikten sonra gizle
		setTimeout(function() {
			tabContent.classList.add("uk-hidden");
			orderDetail.style.transform = "translateX(0)";
			orderDetail.style.opacity = "1";
			orderDetail.classList.add("active");
			addresses.classList.add("passive");
			
			// Form açıldıktan sonra illeri yükle
			var $form = $('#detail-' + id + ' form');
			
			// Yeni adres formu için
			if (id === 'new') {
				var $citySelect = $form.find('#new_city');
				loadCities($citySelect[0]);
			} 
			// Mevcut adres düzenleme formu için
			else {
				var $citySelect = $form.find('select[name="city"]');
				var selectedCityId = $citySelect.data('selected');
				
				// İlleri yükle ve seçili olanı işaretle
				loadCities($citySelect[0], selectedCityId);
			}
		}, 300);
	};

	// Mevcut adres formları için
	$('.edit-address-form').each(function() {
		var $form = $(this);
		var $citySelect = $form.find('[id$="_city"]');
		var $districtSelect = $form.find('[id$="_district"]');
		var $neighborhoodSelect = $form.find('[id$="_neighborhood"]');

		// Mevcut değerleri data attribute'larına kaydet
		$citySelect.data('selected', $citySelect.val());
		$districtSelect.data('selected', $districtSelect.val());
		$neighborhoodSelect.data('selected', $neighborhoodSelect.val());
	});

	// Adres düzenleme formu gönderimi
	$('.edit-address-form').on('submit', function(e) {
		e.preventDefault();
		var $form = $(this);
		var formData = $form.serialize();
		
		console.log('Form data:', formData); // Debug log
		
		$.ajax({
			url: woocommerce_params.ajax_url,
			type: 'POST',
			data: formData,
			beforeSend: function() {
				$form.find('button[type="submit"]').prop('disabled', true);
			},
			success: function(response) {				
				if (response.success) {
					location.reload();
				} else {
					alert(response.data.message || '<?php esc_html_e('An error occurred while updating the address', 'woocommerce'); ?>');
				}
			},
			error: function(xhr, status, error) {
				console.error('AJAX error:', {xhr: xhr, status: status, error: error}); // Debug log
				alert('<?php esc_html_e('An error occurred while updating the address', 'woocommerce'); ?>');
			},
			complete: function() {
				$form.find('button[type="submit"]').prop('disabled', false);
			}
		});
	});

	// Yeni adres ekleme formu gönderimi
	$('.add-address-form').on('submit', function(e) {
		e.preventDefault();
		var $form = $(this);
		var formData = new FormData(this);
		
		$.ajax({
			url: woocommerce_params.ajax_url,
			type: 'POST',
			data: formData,
			processData: false,
			contentType: false,
			beforeSend: function() {
				$form.find('button[type="submit"]').prop('disabled', true);
			},
			success: function(response) {
				if (response.success) {
					/*UIkit.notification({
						message: response.data.message,
						status: 'success',
						timeout: 3000
					});*/
					location.reload();
				} else {
					UIkit.notification({
						message: response.data.message,
						status: 'danger',
						timeout: 3000
					});
				}
			},
			error: function() {
				UIkit.notification({
					message: '<?php esc_html_e('An error occurred while adding the address', 'woocommerce'); ?>',
					status: 'danger',
					timeout: 3000
				});
			},
			complete: function() {
				$form.find('button[type="submit"]').prop('disabled', false);
			}
		});
	});

	// Adres silme işlemi
	$('.delete-address').on('click', function(e) {
		e.preventDefault();
		var $button = $(this);
		
		
		var addressId = $button.data('address');
			
			$.ajax({
				url: woocommerce_params.ajax_url,
				type: 'POST',
				data: {
					action: 'delete_address',
					address_type: addressId,
					security: '<?php echo wp_create_nonce('delete-address'); ?>'
				},
				beforeSend: function() {
					$button.prop('disabled', true);
				},
				success: function(response) {
					if (response.success) {
						/*UIkit.notification({
							message: response.data.message,
							status: 'success',
							timeout: 3000
						});*/
						$button.closest('.address-item').fadeOut(400, function() {
							$(this).remove();
							// Eğer hiç adres kalmadıysa sayfayı yenile
							if ($('.address-item').length === 0) {
								location.reload();
							}
						});
					} else {
						UIkit.notification({
							message: response.data.message,
							status: 'danger',
							timeout: 3000
						});
					}
				},
				error: function() {
					UIkit.notification({
						message: '<?php echo esc_js(__('An error occurred while deleting the address.', 'woocommerce')); ?>',
						status: 'danger',
						timeout: 3000
					});
				},
				complete: function() {
					$button.prop('disabled', false);
				}
			});
	});
});
</script>

<script>
        var detailClose = function () {
            var tabContent = document.querySelector(".address-items");
            var orderDetails = document.getElementsByClassName("address-edit");
            var addresses = document.querySelector(".addresses");

            // Scroll to top smoothly
            window.scrollTo({ top: 0, behavior: 'smooth' });

            Array.from(orderDetails).forEach(function(item) {
                item.classList.remove("active");
                addresses.classList.remove("passive");
                item.style.transform = "translateX(100%)";
                item.style.opacity = "0";
                
                setTimeout(function() {
                    item.classList.add("uk-hidden");
                    // Stilleri temizle
                    item.style.transform = "";
                    item.style.opacity = "";
                }, 300);
            });

            tabContent.classList.remove("uk-hidden");
            tabContent.style.transform = "translateX(-100%)";
            tabContent.style.opacity = "0";
            
            // Görünürlüğü sıfırla
            setTimeout(function() {
                tabContent.style.opacity = "1";
                tabContent.style.transform = "translateX(0)";
            }, 50);
        }
    </script>
