<?php
defined( 'ABSPATH' ) || exit;

$current_user = wp_get_current_user();
$first_name = $current_user->first_name;
$last_name = $current_user->last_name;
$display_name = !empty($first_name) ? $first_name . ' ' . $last_name : $current_user->display_name;
$initials = mb_substr($first_name, 0, 1) . mb_substr($last_name, 0, 1);
?>
    <div class="welcome">
        <div class="custom-container">
            <div class="uk-grid">
                <div class="uk-width-1-1@s">
                    <div class="uk-flex align-items-center align-items-center">
                        <span class="short-name uk-flex uk-flex-center align-items-center"><?php echo esc_html($initials); ?></span>
                        <div class="user-name">
                            <?php echo sprintf(__('Hoşgeldiniz, %s', 'leanfit'), esc_html($display_name)); ?><br>
                            <a href="<?php echo esc_url(wc_logout_url()); ?>" class="logout"><?php esc_html_e('Çıkış Yap', 'leanfit'); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>