<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

/*
 * @hooked wc_empty_cart_message - 10
 */
/*do_action( 'woocommerce_cart_is_empty' );
echo "1";
if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
	<p class="return-to-shop">
		<a class="button wc-backward<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
			<?php
				echo esc_html( apply_filters( 'woocommerce_return_to_shop_text', __( 'Sepete Git', 'leanfit' ) ) );
			?>
		</a>
	</p>
<?php endif;*/ ?>



<section class="section-login section-order-success m-center">
    <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1" uk-slideshow="animation: fade">
        <div class="uk-slideshow-items">
            <div>
                <div class="uk-position-relative uk-overflow-hidden">
                    <div class="banner-contents uk-position-z-index-2">
                        <div class="custom-container">
                            <div class="uk-grid align-items-center uk-flex-center">
                                <div class="uk-width-4-12@xxl uk-width-5-12@xl uk-width-6-12@l">
                                    <div class="login-form-">
                                        <div class="uk-width-1-1 uk-flex uk-flex-center icon-check">
                                            <span class="uk-icon" uk-icon="icon: icn-close"></span>
                                        </div>

                                        <div class="uk-text-center">
                                            <div class="welcome"><?php esc_html_e('Sepet Boş', 'leanfit'); ?></div>
                                            <div class="intro-success"><?php esc_html_e('Sepetinizde henüz ürün bulunmamaktadır.', 'leanfit'); ?></div>

                                            <div class="uk-text-center uk-margin-medium-top uk-padding-large uk-padding-remove-bottom uk-padding-remove-top uk-flex-center" uk-grid>
                                                
												<div class="uk-width-1-2@m" style="max-width: 400px;">
													<a href="<?php echo esc_url(home_url('/')); ?>" class="uk-button lean-button-red uk-margin-small">
														<?php esc_html_e('Anasayfaya Git', 'leanfit'); ?>
													</a>
												</div>
												<div class="uk-width-1-2@m" style="max-width: 400px;">
													<a href="<?php echo get_term_link(24, 'product_cat'); ?>" class="uk-button lean-button-dark">
														<?php esc_html_e('Ürünleri Görüntüle', 'leanfit'); ?>
													</a>
												</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
