<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $product;

if ( ! comments_open() ) {
    return;
}

?>
<div id="reviews" class="woocommerce-Reviews">
    <div id="comments">
        <h2 class="woocommerce-Reviews-title">
            <?php
            $count = $product->get_review_count();
            if ( $count && wc_review_ratings_enabled() ) {
                /* translators: 1: reviews count 2: product name */
                $reviews_title = sprintf( esc_html( _n( '%1$s review for %2$s', '%1$s reviews for %2$s', $count, 'woocommerce' ) ), esc_html( $count ), '<span>' . get_the_title() . '</span>' );
                echo apply_filters( 'woocommerce_reviews_title', $reviews_title, $count, $product ); // WPCS: XSS ok.
            } else {
                esc_html_e( 'Reviews', 'woocommerce' );
            }
            ?>
        </h2>

        <ol class="commentlist" id="product-reviews">
            <?php
            wp_list_comments(
                array(
                    'callback' => 'custom_woocommerce_product_review_list',
                    'style'    => 'ol',
                    'short_ping' => true,
                ),
                array_slice(get_comments(array(
                    'post_id' => $product->get_id(),
                    'status' => 'approve',
                    'orderby' => 'comment_date',
                    'order' => 'DESC',
                )), 0, 4)
            );
            ?>
        </ol>

        <?php if ( get_comment_count($product->get_id())['approved'] > 4 ) : ?>
            <button id="load-more-reviews" data-product-id="<?php echo $product->get_id(); ?>" data-page="2">Load More</button>
        <?php endif; ?>
    </div>

<!--    --><?php //if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) ) : ?>
<!--        <div id="review_form_wrapper">-->
<!--            <div id="review_form">-->
<!--                --><?php
//                $commenter    = wp_get_current_commenter();
//                $comment_form = array(
//                    'title_reply'         => have_comments() ? esc_html__( 'Add a review', 'woocommerce' ) : sprintf( esc_html__( 'Be the first to review &ldquo;%s&rdquo;', 'woocommerce' ), get_the_title() ),
//                    'title_reply_to'      => esc_html__( 'Leave a Reply to %s', 'woocommerce' ),
//                    'title_reply_before'  => '<span id="reply-title" class="comment-reply-title">',
//                    'title_reply_after'   => '</span>',
//                    'comment_notes_after' => '',
//                    'label_submit'        => esc_html__( 'Submit', 'woocommerce' ),
//                    'logged_in_as'        => '',
//                    'comment_field'       => '',
//                );
//
//                $name_email_required = (bool) get_option( 'require_name_email', 1 );
//                $fields              = array(
//                    'author' => array(
//                        'label'    => __( 'Name', 'woocommerce' ),
//                        'type'     => 'text',
//                        'value'    => $commenter['comment_author'],
//                        'required' => $name_email_required,
//                    ),
//                    'email'  => array(
//                        'label'    => __( 'Email', 'woocommerce' ),
//                        'type'     => 'email',
//                        'value'    => $commenter['comment_author_email'],
//                        'required' => $name_email_required,
//                    ),
//                );
//
//                $comment_form['fields'] = array();
//
//                foreach ( $fields as $key => $field ) {
//                    $field_html  = '<p class="comment-form-' . esc_attr( $key ) . '">';
//                    $field_html .= '<label for="' . esc_attr( $key ) . '">' . esc_html( $field['label'] );
//
//                    if ( $field['required'] ) {
//                        $field_html .= '&nbsp;<span class="required">*</span>';
//                    }
//
//                    $field_html .= '</label><input id="' . esc_attr( $key ) . '" name="' . esc_attr( $key ) . '" type="' . esc_attr( $field['type'] ) . '" value="' . esc_attr( $field['value'] ) . '" size="30" ' . ( $field['required'] ? 'required' : '' ) . ' /></p>';
//
//                    $comment_form['fields'][ $key ] = $field_html;
//                }
//
//                $account_page_url = wc_get_page_permalink( 'myaccount' );
//                if ( $account_page_url ) {
//                    /* translators: %s opening and closing link tags respectively */
//                    $comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf( esc_html__( 'You must be %1$slogged in%2$s to post a review.', 'woocommerce' ), '<a href="' . esc_url( $account_page_url ) . '">', '</a>' ) . '</p>';
//                }
//
//                comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ) );
//                ?>
<!--            </div>-->
<!--        </div>-->
<!--    --><?php //else : ?>
<!--        <p class="woocommerce-verification-required">--><?php //esc_html_e( 'Only logged in customers who have purchased this product may leave a review.', 'woocommerce' ); ?><!--</p>-->
<!--    --><?php //endif; ?>

    <div class="clear"></div>
</div>


<?php
// Yorum formunu ekleyin
comment_form();
?>
