<?php
get_header();

$category = get_queried_object();

$term_id = get_queried_object()->term_id;
$bottom_block = get_term_meta($term_id, 'category_bottom_block', true);
$top_block = get_term_meta($term_id, 'category_top_block', true);

if ($top_block) {
    echo do_shortcode($top_block);
}

?>

    <div id="product-category" class="custom-container">
        <div class="products-list">
            <div class="uk-container">
                <div class="uk-grid uk-flex-center" uk-grid>
                    <div class="uk-width-4-5@m uk-margin-medium-bottom">
                        <h1 class="section-title uk-text-center">
                            <?php
                            $term = get_queried_object();
                            $subtitle = get_term_meta($term->term_id, 'category_subtitle', true);

                            if ($subtitle) {
                                echo esc_html($subtitle);
                            }
                            ?>
                        </h1>
                    </div>
                </div>
            </div>

            <div class="uk-grid-small uk-margin-xlarge-bottom uk-margin-medium-top" uk-grid>
                <?php
                $args = array(
                    'post_type' => 'product',
                    'posts_per_page' => -1,
                    'orderby' => 'menu_order',
                    'order' => 'ASC',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'id',
                            'terms'    => get_queried_object_id(),
                            'operator' => 'IN',
                        ),
                    ),
                );
                $query = new WP_Query( $args );

                if ( $query->have_posts() ) :
                    $counter = 1;

                    while ( $query->have_posts() ) : $query->the_post();
                        /*if ( $counter > 2) {
                            $class = "uk-width-1-3@m uk-width-1-2@s uk-width-1-1";
                        } else {
                            $class = "uk-width-1-2@s uk-width-1-1 img-w-50";
                        }*/

                        $class = "uk-width-1-3@m uk-width-1-2@s uk-width-1-1";

                        global $product;
                        ?>
                        <div class="<?= $class; ?>">
                            <div class="leanfit-product-layout product-item" data-item-id="<?php the_ID(); ?>" data-item-name="<?php the_title(); ?>" data-item-price="<?php echo get_post_meta(get_the_ID(), '_price', true); ?>" data-item-currency="TRY" data-item-category="<?= $category->name; ?>" data-item-brand="LeanFit by Game">
                                <div class="uk-position-relative uk-overflow-hidden">
                                    <div class="uk-text-uppercase uk-position-absolute uk-position-z-index-2 product-icon"><i uk-icon="icn-vegan-green"></i> <?php echo get_post_meta($product->get_id(), '_custom_badge', true); ?></div>
                                    <div class="uk-position-relative uk-position-z-index-zero product-image-box">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php 
                                            $product_image = get_the_post_thumbnail_url();
                                            if ($product_image) {
                                                $image_url = $product_image;
                                            } else {
                                                $image_url = get_template_directory_uri() . '/assets/image/placeholder.png';
                                            }
                                            ?>
                                            <img src="<?php echo $image_url; ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>" class="img-responsive" />
                                        </a>
                                    </div>
                                </div>

                                <div class="uk-position-relative product-details">
                                    <div class="uk-flex uk-flex-between uk-items-center">
                                        <div class="product-stars">
                                            <?php
                                            $average_rating = $product->get_average_rating();
                                            $comment_count = get_comments_number( $product->get_id() ); // Ürün için yorum sayısını alıyoruz
                                            $average_rating = $comment_count > 0 ? round($average_rating, 1) : 5; // Yorum yoksa 5 yıldız göster

                                            for ($i = 1; $i <= 5; $i++) {
                                                if ($i <= floor($average_rating)) {
                                                    echo '<span uk-icon="icn-star" class="star filled"></span>';
                                                } elseif ($i - 0.5 <= $average_rating) {
                                                    echo '<span uk-icon="icn-star-half" class="star half-filled"></span>';
                                                } else {
                                                    echo '<span uk-icon="icn-star-null" class="star"></span>';
                                                }
                                            }
                                            ?>
                                        </div>
                                        <p class="product-gr"><?php echo get_post_meta($product->get_id(), '_custom_weight', true); ?></p>
                                    </div>

                                    <h3 class="product-name"><a href="<?php the_permalink(); ?>" class="text-decoration-none" tabindex="0"><?php the_title(); ?></a></h3>
                                    <p class="product-price">
                                        <span><?php echo price_format(get_post_meta(get_the_ID(), '_price', true)); ?></span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <?php
                        $counter++;
                    endwhile;
                else :
                    echo 'Bu kategoriye henüz ürün eklenmemiştir.';
                endif;

                wp_reset_postdata();
                ?>
            </div>
        </div>
    </div>


<?php

if ($bottom_block) {
    echo do_shortcode($bottom_block);
}

?>

    <section class="uk-section-xsmall">
        <div class="custom-container">
            <div class="uk-grid-small uk-margin-xlarge-bottom uk-margin-medium-top" uk-grid>
                <div class="uk-width-1-2@m uk-width-1-1 category-description">
                    <p><?= category_description($category->term_id); ?></p>
                </div>
            </div>
        </div>
    </section>

<?php //woocommerce_content(); ?>

<?php get_footer(); ?>