<?php
/**
 * Template Name: Track Order Page
 */

get_header();
?>

<script>document.querySelector(".header-all").classList.add("header-relative");</script>

<div class="uk-section-large">
    <div class="custom-container">
        <div class="uk-grid uk-flex-center">
            <div class="uk-width-1-1">
                <h1 class="uk-heading-small uk-text-center"><?php _e('Sipariş Takip', 'leanfit'); ?></h1>
                
                <div class="uk-margin-medium-top">
                    <form method="post" class="uk-form-stacked uk-width-1-3@m uk-margin-auto uk-text-center" id="track-order-form">
                        <div class="uk-margin">
                            <div class="uk-form-controls">
                                <input class="uk-input" type="text" id="order_id" name="order_id" placeholder="<?php _e('Sipariş Numarası', 'leanfit'); ?>" required>
                            </div>
                        </div>
                        
                        <button type="submit" class="uk-button uk-button-primary">
                            <?php _e('Sorgula', 'leanfit'); ?>
                        </button>
                    </form>

                    <div id="order-result" class="uk-margin-large-top" style="display: none;"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.order-tracking {
    position: relative;
    padding: 40px 0;
}
.timeline {
    position: relative;
    padding: 20px 0;
}
</style>

<script>
jQuery(document).ready(function($) {
    $('#track-order-form').on('submit', function(e) {
        e.preventDefault();
        
        var orderId = $('#order_id').val();
        
        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>',
            type: 'POST',
            data: {
                action: 'track_order',
                order_id: orderId,
                nonce: '<?php echo wp_create_nonce('track_order_nonce'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    var order = response.data;
                    
                    // Ana sipariş bilgilerini güncelle
                    var orderHtml = `
                        <section class="section-account uk-padding-large uk-padding-remove-left uk-padding-remove-right uk-padding-remove-bottom">
                            <div class="account-tabs">
                                <div class="order-detail active" style="transform: translateX(0px); opacity: 1;">
                                    <div class="custom-container no-desktop-container">
                                        <div class="order-back">Sipariş Detayı</div>

                                        <div class="order-summary">
                                            <div class="uk-grid">
                                                <div class="uk-width-2-12@l uk-width-4-12@m uk-width-6-12">
                                                    <div class="value-item">
                                                        Sipariş Numarası <span class="value">${order.order_number}</span>
                                                    </div>
                                                </div>

                                                <div class="uk-width-2-12@l uk-width-4-12@m uk-width-6-12">
                                                    <div class="value-item">
                                                        Sipariş Tarihi <span class="value">${order.date}</span>
                                                    </div>
                                                </div>

                                                <div class="uk-width-2-12@l uk-width-4-12@m uk-width-6-12">
                                                    <div class="value-item">
                                                        Sipariş Toplamı <span class="value">${order.total_items}</span>
                                                    </div>
                                                </div>

                                                <div class="uk-width-2-12@l uk-width-4-12@m uk-width-6-12">
                                                    <div class="value-item">
                                                        Sipariş Durumu <span class="value">${order.status_text}</span>
                                                    </div>
                                                </div>

                                                <div class="uk-width-2-12@l uk-width-4-12@m">
                                                    <div class="value-item">
                                                        Ödeme Yöntemi <span class="value">${order.payment_method}</span>
                                                    </div>
                                                </div>

                                                <div class="uk-width-2-12@l uk-width-4-12@m uk-flex uk-flex-right@m">
                                                    <div class="value-item">
                                                        Toplam Tutar <span class="value">${order.total}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="shopping-summary">
                                        <div class="custom-container no-desktop-container">
                                            <h3 class="summary-title">Sipariş Özeti</h3>
                                            <p class="summary-subtitle">Siparişleriniz teslimat durumuna göre görüntülenir.</p>
                                        </div>

                                        <div class="custom-container shopping-container no-desktop-container">
                                            <div class="shopping-detail">
                                                <div class="order-tracking">
                                                    <div class="custom-container">
                                                        <div class="timeline">
                                                            <div class="progress-bar">
                                                                <div class="progress" data-progress="${order.progress}" style="width: ${order.progress}%;"></div>
                                                            </div>
                                                            <div class="steps">
                                                                <div class="step ${order.progress >= 25 ? 'completed' : ''}">
                                                                    <div class="step-point"></div>
                                                                    <div class="step-label">Sipariş Verildi</div>
                                                                    <div class="step-date">${order.dates.created}</div>
                                                                </div>
                                                                <div class="step ${order.progress >= 50 ? 'completed' : ''}">
                                                                    <div class="step-point"></div>
                                                                    <div class="step-label">Hazırlanıyor</div>
                                                                    <div class="step-date">${order.dates.processing}</div>
                                                                </div>
                                                                <div class="step ${order.progress >= 75 ? 'completed' : ''} ${order.progress == 75 ? 'current' : ''}">
                                                                    <div class="step-point"></div>
                                                                    <div class="step-label">Kargolandı</div>
                                                                    <div class="step-date">${order.dates.shipped}</div>
                                                                </div>
                                                                <div class="step ${order.progress >= 100 ? 'completed' : ''}">
                                                                    <div class="step-point"></div>
                                                                    <div class="step-label">Teslim Edildi</div>
                                                                    <div class="step-date">${order.dates.completed}</div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="order-cargo">
                                                    <div class="custom-container">
                                                        <div class="uk-grid uk-child-width-auto@l uk-child-width-1-2@l align-items-center">
                                                            <div>
                                                                <div class="value-item">
                                                                    Tahmini Teslimat <span class="value">${order.estimated_delivery}</span>
                                                                </div>
                                                            </div>

                                                            <div>
                                                                <div class="value-item">
                                                                    Kargo Şirketi <span class="value">${order.shipping_method}</span>
                                                                </div>
                                                            </div>
                                                            ${order.tracking_number ? `
                                                            <div>
                                                                <div class="cargo-number">
                                                                    <span class="uk-icon" uk-icon="icon: icn-cargo"></span>
                                                                    Kargo Takip: ${order.tracking_number}
                                                                </div>
                                                            </div>
                                                            ` : ''}
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="order-products">
                                                    <div class="custom-container">
                                                        ${order.items.map(item => `
                                                        <div class="uk-grid align-items-center">
                                                            <div class="uk-width-9-12@l align-items-center">
                                                                <div class="uk-grid uk-grid-xsmall uk-flex-start@m uk-flex-between align-items-center">
                                                                    <div class="uk-width-5-11@m uk-width-7-11">
                                                                        <div class="order-product uk-flex align-items-center">
                                                                            <div class="order-product-image">
                                                                                <img src="${item.image}" class="attachment-woocommerce_thumbnail size-woocommerce_thumbnail" alt="${item.name}">
                                                                            </div>
                                                                            <div class="order-product-name">
                                                                                ${item.name}
                                                                                <span class="order-product-quantity uk-hidden@s">
                                                                                    Adet 
                                                                                    <span class="value">${item.quantity} ${item.quantity > 1 ? 'Ürünler' : 'Ürün'}</span>
                                                                                </span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="uk-width-6-11@m uk-width-auto">
                                                                        <div class="uk-grid uk-child-width-auto@m uk-child-width-1-1@s align-items-center">
                                                                            <div>
                                                                                <div class="uk-flex@m uk-flex-right@m uk-flex-between align-items-center">
                                                                                    ${item.discount_percentage > 0 ? `
                                                                                    <span class="order-discount-rate uk-visible@s">%${item.discount_percentage} İndirim</span>
                                                                                    ` : ''}
                                                                                    <span class="order-price">${formatPrice(item.sale_price)}</span>
                                                                                    ${item.discount_percentage > 0 ? `
                                                                                    <span class="order-discount-price">${formatPrice(item.regular_price)}</span>
                                                                                    <span class="order-discount-rate uk-hidden@s">%${item.discount_percentage} İndirim</span>
                                                                                    ` : ''}
                                                                                </div>
                                                                            </div>

                                                                            <div class="uk-visible@s">
                                                                                <span class="order-product-quantity">
                                                                                    Adet 
                                                                                    <span class="value">${item.quantity} ${item.quantity > 1 ? 'Ürünler' : 'Ürün'}</span>
                                                                                </span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="uk-width-3-12@l">
                                                                <div class="uk-grid align-items-center uk-flex-between">
                                                                    <div class="uk-width-auto@m uk-width-1-1">
                                                                        <div class="order-status">
                                                                            <span class="pin pin-${getStatusPinClass(order.status)}"></span>
                                                                            ${order.status_text}
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        `).join('')}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                    `;
                    
                    $('#order-result').show().html(orderHtml);
                    
                } else {
                    UIkit.notification({
                        message: response.data,
                        status: 'danger',
                        pos: 'top-center',
                        timeout: 3000
                    });
                }
            }
        });
    });

    // Fiyat formatla
    function formatPrice(price) {
        return '₺' + parseFloat(price).toLocaleString('tr-TR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }

    // Durum pin sınıfını belirle
    function getStatusPinClass(status) {
        switch (status) {
            case 'processing':
                return 'black';
            case 'on-hold':
            case 'pending':
                return 'yellow';
            case 'completed':
                return 'green';
            case 'cancelled':
                return 'red';
            default:
                return 'black';
        }
    }
});
</script>

<?php get_footer(); ?> 