<?php

function add_custom_weight_field() {
    woocommerce_wp_text_input(array(
        'id' => '_custom_weight',
        'label' => __('Ağırlık (ml/gr)', 'woocommerce'),
        'description' => __('Ürünün ağırlığını ve birimini girin (örneğin: 100 ml veya 600 gr).', 'woocommerce'),
        'desc_tip' => 'true',
        'type' => 'text',
        'placeholder' => '100 ml veya 600 gr',
    ));
}
add_action('woocommerce_product_options_general_product_data', 'add_custom_weight_field');

function save_custom_weight_field($post_id) {
    $custom_weight = isset($_POST['_custom_weight']) ? sanitize_text_field($_POST['_custom_weight']) : '';
    update_post_meta($post_id, '_custom_weight', $custom_weight);
}
add_action('woocommerce_process_product_meta', 'save_custom_weight_field');

function display_custom_weight() {
    global $post;
    $custom_weight = get_post_meta($post->ID, '_custom_weight', true);
    if ($custom_weight) {
        echo '<p class="product-weight">Ağırlık: ' . esc_html($custom_weight) . '</p>';
    }
}
add_action('woocommerce_single_product_summary', 'display_custom_weight', 20);

// Admin paneline özel badge alanı ekleme
function add_custom_badge_field() {
    woocommerce_wp_text_input(array(
        'id' => '_custom_badge',
        'label' => __('Ürün Rozeti', 'woocommerce'),
        'description' => __('Ürün için bir rozet etiketi girin (Örn: Sale, Vegan, Yeni).', 'woocommerce'),
        'desc_tip' => 'true',
        'type' => 'text',
        'placeholder' => '100% Vegan, Yeni',
    ));
}
add_action('woocommerce_product_options_general_product_data', 'add_custom_badge_field');

// Badge değerini kaydetme
function save_custom_badge_field($post_id) {
    $custom_badge = isset($_POST['_custom_badge']) ? sanitize_text_field($_POST['_custom_badge']) : '';
    update_post_meta($post_id, '_custom_badge', $custom_badge);
}
add_action('woocommerce_process_product_meta', 'save_custom_badge_field');

// Ürün sayfasında badge gösterme
function display_custom_badge() {
    global $post;
    $custom_badge = get_post_meta($post->ID, '_custom_badge', true);

    if ($custom_badge) {
        echo '<div class="custom-badge">' . esc_html($custom_badge) . '</div>';
    }
}
add_action('woocommerce_before_single_product', 'display_custom_badge');


// Admin paneline özel badge alanı ekleme
function add_custom_background_color_field() {
    woocommerce_wp_text_input(array(
        'id' => '_custom_background_color',
        'label' => __('Ürün Arka Plan Rengi', 'woocommerce'),
        'description' => __('Ürün için bir arka plan rengi girin (Örn: #e0bab4).', 'woocommerce'),
        'desc_tip' => 'true',
        'type' => 'color',
        'placeholder' => '#e0bab4',
    ));
}
add_action('woocommerce_product_options_general_product_data', 'add_custom_background_color_field');

// Badge değerini kaydetme
function save_custom_background_color_field($post_id) {
    $custom_background_color = isset($_POST['_custom_background_color']) ? sanitize_text_field($_POST['_custom_background_color']) : '';
    update_post_meta($post_id, '_custom_background_color', $custom_background_color);
}
add_action('woocommerce_process_product_meta', 'save_custom_background_color_field');


function add_category_subtitle_field() {
    // Sadece ürün kategorileri için ekleyelim
    if ('product_cat' === get_current_screen()->taxonomy) {
        ?>
        <div class="form-field">
            <label for="category_subtitle"><?php _e('Alt Başlık', 'your-text-domain'); ?></label>
            <input type="text" name="category_subtitle" id="category_subtitle" value="" />
            <p class="description"><?php _e('Bu kategori için alt başlık girin.', 'your-text-domain'); ?></p>
        </div>
        <?php
    }
}
add_action('product_cat_add_form_fields', 'add_category_subtitle_field');

function edit_category_subtitle_field($term) {
    $subtitle = get_term_meta($term->term_id, 'category_subtitle', true);
    ?>
    <tr class="form-field">
        <th scope="row" valign="top"><label for="category_subtitle"><?php _e('Alt Başlık', 'your-text-domain'); ?></label></th>
        <td>
            <input type="text" name="category_subtitle" id="category_subtitle" value="<?php echo esc_attr($subtitle); ?>" />
            <p class="description"><?php _e('Bu kategori için alt başlık girin.', 'your-text-domain'); ?></p>
        </td>
    </tr>
    <?php
}
add_action('product_cat_edit_form_fields', 'edit_category_subtitle_field');

function save_category_subtitle($term_id) {
    if (isset($_POST['category_subtitle'])) {
        update_term_meta($term_id, 'category_subtitle', sanitize_text_field($_POST['category_subtitle']));
    }
}
add_action('created_product_cat', 'save_category_subtitle');
add_action('edited_product_cat', 'save_category_subtitle');

function add_category_blocks_field() {
    if ('product_cat' === get_current_screen()->taxonomy) {
        ?>

        <div class="form-field">
            <label for="category_top_block"><?php _e('Üst Bloklar', ''); ?></label>
            <textarea class="form-control" name="category_top_block" id="category_top_block" rows="5"></textarea>
            <p class="description"><?php _e('Bu alana ekleyeceğiniz bloklar kategori sayfasının üstünde görüntülenecektir.', ''); ?></p>
        </div>

        <div class="form-field">
            <label for="category_bottom_block"><?php _e('Alt Bloklar', ''); ?></label>
            <textarea class="form-control" name="category_bottom_block" id="category_bottom_block" rows="5"></textarea>
            <p class="description"><?php _e('Bu alana ekleyeceğiniz bloklar kategori sayfasının altında görüntülenecektir.', ''); ?></p>
        </div>

        <?php
    }
}
add_action('product_cat_add_form_fields', 'add_category_blocks_field');


function edit_category_blocks_field($term) {
    $bottom_block = get_term_meta($term->term_id, 'category_bottom_block', true);
    $top_block = get_term_meta($term->term_id, 'category_top_block', true);
    ?>

    <tr class="form-field">
        <th scope="row" valign="top"><label for="category_top_block"><?php _e('Üst Bloklar', ''); ?></label></th>
        <td>
            <textarea class="form-control" name="category_top_block" id="category_top_block" rows="5"><?php echo esc_attr($top_block); ?></textarea>
            <p class="description"><?php _e('Bu alana ekleyeceğiniz bloklar kategori sayfasının üstünde görüntülenecektir.', ''); ?></p>
        </td>
    </tr>

    <tr class="form-field">
        <th scope="row" valign="top"><label for="category_bottom_block"><?php _e('Alt Bloklar', ''); ?></label></th>
        <td>
            <textarea class="form-control" name="category_bottom_block" id="category_bottom_block" rows="5"><?php echo esc_attr($bottom_block); ?></textarea>
            <p class="description"><?php _e('Bu alana ekleyeceğiniz bloklar kategori sayfasının altında görüntülenecektir.', ''); ?></p>
        </td>
    </tr>

    <?php
}
add_action('product_cat_edit_form_fields', 'edit_category_blocks_field');

function save_category_blocks($term_id) {
    if (isset($_POST['category_bottom_block'])) {
        update_term_meta($term_id, 'category_bottom_block', sanitize_text_field($_POST['category_bottom_block']));
    }

    if (isset($_POST['category_top_block'])) {
        update_term_meta($term_id, 'category_top_block', sanitize_text_field($_POST['category_top_block']));
    }
}
add_action('created_product_cat', 'save_category_blocks');
add_action('edited_product_cat', 'save_category_blocks');