<?php


// İletişim Bilgileri / Panel
function custom_theme_settings_menu() {
    add_menu_page(
        'İletişim Bilgileri',       // Menü başlığı
        'İletişim Bilgileri',       // Admin panelindeki görünen isim
        'manage_options',      // Kullanıcı yetkisi
        'custom-theme-options',// Menü slug
        'custom_theme_settings_page' // Çağrılacak fonksiyon
    );
}
add_action('admin_menu', 'custom_theme_settings_menu');

function custom_theme_settings_page() {
    ?>
    <div class="wrap">
        <h1>İletişim Bilgileri</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('custom_theme_options_group');
            do_settings_sections('custom-theme-options');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

function custom_theme_settings_init() {
    register_setting('custom_theme_options_group', 'phone_number');
    register_setting('custom_theme_options_group', 'email_address');
    register_setting('custom_theme_options_group', 'company_address');

    add_settings_section(
        'custom_theme_main_section',
        'İletişim Bilgileri',
        null,
        'custom-theme-options'
    );

    add_settings_field(
        'phone_number_field',
        'Telefon Numarası',
        'custom_phone_number_callback',
        'custom-theme-options',
        'custom_theme_main_section'
    );

    add_settings_field(
        'email_address_field',
        'E-Posta Adresi',
        'custom_email_address_callback',
        'custom-theme-options',
        'custom_theme_main_section'
    );

    add_settings_field(
        'company_address_field',
        'Adres',
        'custom_company_address_callback',
        'custom-theme-options',
        'custom_theme_main_section'
    );
}
add_action('admin_init', 'custom_theme_settings_init');

function custom_phone_number_callback() {
    $phone = get_option('phone_number');
    echo '<input type="text" name="phone_number" value="' . esc_attr($phone) . '" />';
}

function custom_email_address_callback() {
    $email = get_option('email_address');
    echo '<input type="email" name="email_address" value="' . esc_attr($email) . '" />';
}

function custom_company_address_callback() {
    $address = get_option('company_address');
    echo '<textarea name="company_address">' . esc_textarea($address) . '</textarea>';
}