


<div class="uk-position-relative uk-section uk-section-large pb-mobile-zero uk-flex uk-flex-middle uk-height-viewport section-scroll-product-night">
    <div class="uk-width-1-1">
        <div class="uk-visible uk-grid tm-grid-expand uk-child-width-1-1 uk-grid-margin">
            <div class="uk-grid-item-match uk-width-1-1 uk-visible">
                <div class="uk-panel uk-width-1-1">
                    <div id="product-container" class="uk-position-relative">
                        <div id="product-image" class="uk-position-absolute uk-width-1-1 uk-text-left uk-visible@s"
                            uk-parallax="y: 25vh,70vh; x: 0,10vh; scale: 1.1,.7; rotate: -10deg,0; easing: 1"
                            style="left: 45%; bottom: 20vh; z-index: 1;"
                        >
                            <picture>
                                <source id="day-image" srcset="<?= $block->image; ?>" sizes="(min-width: 400px) 400px" />
                                <img id="product-img" decoding="async" src="<?= $block->mobile_image; ?>" width="450" height="589" class="el-image" alt="Product" loading="lazy" />
                            </picture>


                            <div id="mode-switch-container" class="uk-position-absolute" style="opacity: 0; transition: opacity 0.5s ease; width: 19%;">
                                <div class="uk-flex uk-flex-center w-full uk-margin-top">
                                        <div class="toggle-container">
                                            <input type="checkbox" id="mode-switch" />
                                            <label for="mode-switch" class="toggle-switch">
                                                <span class="toggle-handle">
                                                    <span class="toggle-day"></span>
                                                    <span class="toggle-night"></span>
                                                </span>
                                            </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="product-image-mobile" class="uk-hidden@s uk-position-absolute uk-width-1-1 uk-text-left" uk-parallax="y: 25vh,45vh; x: -10, -10vh; scale: 1.1,.9; rotate: -10deg,0; easing: 1" style="left: 45%; bottom: 20vh; z-index: 1;">
                            <picture>
                                <source id="day-image-mobile" srcset="<?= $block->image; ?>" sizes="(min-width: 400px) 400px" />
                                <img id="product-img-mobile" decoding="async" src="<?= $block->mobile_image; ?>" width="200" class="el-image" alt="Product" loading="lazy" />
                            </picture>

                            <div id="mode-switch-container-mobile" class="uk-position-absolute" style="opacity: 0; transition: opacity 0.5s ease; width: 20%;">
                                <div class="uk-flex uk-flex-center w-full uk-margin-top">
                                    <div class="toggle-container">
                                        <input type="checkbox" id="mode-switch-mobile" />
                                        <label for="mode-switch-mobile" class="toggle-switch">
                                            <span class="toggle-handle">
                                                <span class="toggle-day"></span>
                                                <span class="toggle-night"></span>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>



                    </div>
                </div>
            </div>
        </div>


        <div class="uk-hidden@s uk-section-xlarge"></div>


        <div class="uk-grid-margin uk-container">
            <div class="uk-grid tm-grid-expand uk-child-width-1-1">
                <article class="uk-width-1-1">
                    <h2 class="uk-heading-large uk-width-xlarge@m uk-position-relative uk-margin-remove-top uk-width-1-1 uk-text-normal section-title" style="z-index: 3;"><?= $block->title; ?></h2>
                    <div class="uk-panel uk-width-large@m uk-position-relative uk-margin uk-width-1-1 section-description" style="z-index: 3;"><?= $block->description; ?></div>


                    <div class="uk-position-relative uk-margin-medium" style="z-index: 3;">
                        <a class="el-content uk-button uk-button-primary" href="<?= $block->button_link; ?>">
                            <?= $block->button_text; ?>
                        </a>
                    </div>
                </article>

            </div>
        </div>

        <section class="nutrition-icons uk-margin-xlarge-top">
            <div class="custom-container">
                <div class="nutrition-icon-items">
                    <?php foreach ($data_array as $item) : ?>
                    <div>
                        <div class="nutrition-icon-item">
                            <span uk-icon="<?= $item['banner_class']; ?>"></span>
                            <h3><?= $item['text']; ?></h3>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
    </div>
</div>


<style>
    /* Gölge efekti için overlay */
    .overlay-product {
        position: absolute;
        /* top: 100%; */
        /* left: 0; */
        width: 450px;
        height: 41px;
        border-radius: 50%;
        z-index: 2;
        background: rgb(0, 0, 0);
        /*background: radial-gradient(circle, rgba(0, 0, 0, 1) 0%, rgba(255, 255, 255, 0) 100%);*/
        /* background: linear-gradient(0deg, rgba(0, 0, 0, 1) 0%, rgba(255, 255, 255, 0) 100%); */
        background: radial-gradient(#000000, #3b3b3b00, #00000000);
    }

    /* Görselin konumunu ayarlama */
    #product-image {
        position: relative; /* Gölgenin doğru konumlanabilmesi için */
        z-index: 1; /* Görseli üstte tutalım */
    }

    /* Toggle Switch Styles */
    .toggle-container {
        position: relative;
        width: 80px;
        height: 40px;
    }

    .toggle-switch {
        position: relative;
        display: block;
        width: 100%;
        height: 100%;
        background: #fff;
        border-radius: 40px;
        border: 2px solid #e8e8e8;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .toggle-handle {
        position: absolute;
        top: 2px;
        left: 2px;
        width: 32px;
        height: 32px;
        background: #fff;
        border-radius: 50%;
        transition: all 0.3s ease;
    }

    .toggle-day {
        position: absolute;
        top: 4px;
        left: 4px;
        width: 24px;
        height: 24px;
        background: #FFD700;
        border-radius: 50%;
        transition: all 0.3s ease;
    }

    .toggle-night {
        position: absolute;
        top: 4px;
        left: 4px;
        width: 24px;
        height: 24px;
        background: #152C70;
        border-radius: 50%;
        opacity: 0;
        transition: all 0.3s ease;
    }

    /* Switch aktif durumu */
    #mode-switch, #mode-switch-mobile {
        display: none;
    }

    #mode-switch:checked + .toggle-switch, #mode-switch-mobile:checked + .toggle-switch {
        background: #152C70;
    }

    #mode-switch:checked + .toggle-switch .toggle-handle, #mode-switch-mobile:checked + .toggle-switch .toggle-handle {
        transform: translateX(40px);
    }

    #mode-switch:checked + .toggle-switch .toggle-day, #mode-switch-mobile:checked + .toggle-switch .toggle-day {
        opacity: 0;
    }

    #mode-switch:checked + .toggle-switch .toggle-night, #mode-switch-mobile:checked + .toggle-switch .toggle-night {
        opacity: 1;
    }
</style>
<script>
    document.addEventListener("DOMContentLoaded", () => {
        const productImage = document.querySelector("#product-image");
        const switchContainer = document.querySelector("#mode-switch-container");
        
        // Başlangıçta switch'i gizle
        switchContainer.style.opacity = "0";
        
        // Scroll event listener
        window.addEventListener("scroll", () => {
            const productRect = productImage.getBoundingClientRect();
            const windowHeight = window.innerHeight;
            
            // Ürünün son pozisyonunu kontrol et
            // Bottom: 20vh, left: 45%, scale: 0.7 olduğu konum
            const isInFinalPosition = 
                productRect.top > 0 && // Viewport'ta görünür
                productRect.top < windowHeight && // Viewport'un altında değil
                Math.abs(productRect.left - (window.innerWidth * 0.45)) < 20 && // %45 pozisyonuna yakın
                window.scrollY > windowHeight * 0.3; // Sayfanın yeterince aşağısında
            
            // Transform scale değerini kontrol et (yaklaşık 0.7 olmalı)
            const transform = window.getComputedStyle(productImage).transform;
            const matrix = new DOMMatrix(transform);
            const scale = Math.hypot(matrix.a, matrix.b);
            
            const isScaledDown = scale < 0.8; // Scale 0.7'ye yakın
            
            if (isScaledDown) {
                switchContainer.style.opacity = "1";
            } else {
                switchContainer.style.opacity = "0";
            }
        });
        
        // Switch kontrolü
        const modeSwitch = document.querySelector("#mode-switch");
        const productImg = document.querySelector("#product-img");
        const dayImageSource = document.querySelector("#day-image");
        
        const dayImage = "<?php bloginfo('template_url'); ?>/assets/catalog/view/theme/leanfit/image/lean_protein.png";
        const nightImage = "<?php bloginfo('template_url'); ?>/assets/catalog/view/theme/leanfit/image/lean_protein_night.png";
        
        modeSwitch.addEventListener("change", () => {
            const isNightMode = modeSwitch.checked;
            productImg.src = isNightMode ? nightImage : dayImage;
            dayImageSource.srcset = isNightMode ? nightImage : dayImage;
        });

        // Mobil için scroll kontrolü
        const productImageMobile = document.querySelector("#product-image-mobile");
        const switchContainerMobile = document.querySelector("#mode-switch-container-mobile");
        
        window.addEventListener("scroll", () => {
            // Desktop kontrolü
            // ... existing desktop scroll code ...

            // Mobil kontrolü
            if (productImageMobile) {
                const mobileRect = productImageMobile.getBoundingClientRect();
                const windowHeight = window.innerHeight;
                
                const isMobileInPosition = 
                    mobileRect.top > 0 &&
                    mobileRect.top < windowHeight &&
                    window.scrollY > windowHeight * 0.2;
                
                const mobileTransform = window.getComputedStyle(productImageMobile).transform;
                const mobileMatrix = new DOMMatrix(mobileTransform);
                const mobileScale = Math.hypot(mobileMatrix.a, mobileMatrix.b);
                
                const isMobileScaledDown = mobileScale < 0.91;
                
                if (isMobileScaledDown) {
                    switchContainerMobile.style.opacity = "1";
                } else {
                    switchContainerMobile.style.opacity = "0";
                }
            }
        });

        // Mobil switch kontrolü
        const mobileModeSwitch = document.querySelector("#mode-switch-mobile");
        const mobileImg = document.querySelector("#product-img-mobile");
        const mobileImageSource = document.querySelector("#day-image-mobile");
        
        if (mobileModeSwitch) {
            mobileModeSwitch.addEventListener("change", () => {
                const isNightMode = mobileModeSwitch.checked;
                mobileImg.src = isNightMode ? nightImage : dayImage;
                mobileImageSource.srcset = isNightMode ? nightImage : dayImage;
            });
        }
    });
</script>