jQuery(document).ready(function($) {
    // Görsel yükleme işlemi
    $('.upload-images-button').on('click', function(e) {
        e.preventDefault();
        
        var fileInput = $('input[name="admin_review_images[]"]');
        var files = fileInput[0].files;
        var commentId = $('.delete-review-image').first().data('comment-id');
        
        if (files.length === 0) {
            $('.upload-status').html('<p style="color: red;">Lütfen görsel seçin.</p>');
            return;
        }

        var formData = new FormData();
        formData.append('action', 'upload_review_images');
        formData.append('nonce', reviewImagesAdmin.nonce);
        formData.append('comment_id', commentId);

        // Görselleri formData'ya ekle
        for (var i = 0; i < files.length; i++) {
            formData.append('images[]', files[i]);
        }

        // Upload status'u güncelle
        $('.upload-status').html('<p>Yükleniyor...</p>');

        $.ajax({
            url: reviewImagesAdmin.ajaxurl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    $('.upload-status').html('<p style="color: green;">' + response.data.message + '</p>');
                    
                    // Eğer henüz görsel yoksa, mevcut "Henüz görsel eklenmemiş" mesajını kaldır
                    if ($('.existing-images p').length > 0) {
                        $('.existing-images').html('<h4>Mevcut Görseller:</h4><ul style="display: flex; flex-wrap: wrap; gap: 10px; list-style: none; padding: 0;"></ul>');
                    }
                    
                    // Yeni görselleri ekle
                    var $imageList = $('.existing-images ul');
                    var currentIndex = $imageList.find('li').length;
                    
                    response.data.images.forEach(function(imageUrl) {
                        var $newImage = $('<li style="position: relative;">' +
                            '<a href="' + imageUrl + '" target="_blank">' +
                            '<img src="' + imageUrl + '" style="max-width: 100px; max-height: 100px; border: 1px solid #ccc;"/>' +
                            '</a>' +
                            '<br>' +
                            '<a href="#" class="delete-review-image" data-comment-id="' + commentId + '" data-image-index="' + currentIndex + '" style="color:red; text-decoration:none;">Sil</a>' +
                            '<input type="hidden" name="review_images[]" value="' + imageUrl + '" />' +
                            '</li>');
                        
                        $imageList.append($newImage);
                        currentIndex++;
                    });
                    
                    // Input'u temizle
                    fileInput.val('');
                } else {
                    $('.upload-status').html('<p style="color: red;">' + response.data + '</p>');
                }
            },
            error: function() {
                $('.upload-status').html('<p style="color: red;">Bir hata oluştu.</p>');
            }
        });
    });

    // Görsel silme işlemi - Event delegation kullan
    $(document).on('click', '.delete-review-image', function(e) {
        e.preventDefault();
        
        var $this = $(this);
        var commentId = $this.data('comment-id');
        var imageIndex = $this.data('image-index');
        
        if (confirm('Bu görseli silmek istediğinizden emin misiniz?')) {
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'delete_review_image',
                    comment_id: commentId,
                    image_index: imageIndex
                },
                success: function(response) {
                    if (response.success) {
                        $this.closest('li').fadeOut(300, function() {
                            $(this).remove();
                            
                            // Eğer hiç görsel kalmadıysa mesaj göster
                            if ($('.existing-images li').length === 0) {
                                $('.existing-images').html('<p>Henüz görsel eklenmemiş.</p>');
                            } else {
                                // Kalan görsellerin indekslerini güncelle
                                $('.existing-images li').each(function(index) {
                                    $(this).find('.delete-review-image').data('image-index', index);
                                });
                            }
                        });
                    }
                }
            });
        }
    });
}); 