var checkout = {
    'count': {
        'init' : function (elem, position = "down", product_id = 0) {
            var total_count;
            var input_elem = $(elem).closest('.count-input').find('.product-quantity');
            total_count = parseInt($(input_elem).val()) - 1;

            if (position === "up") {
                total_count = parseInt($(input_elem).val()) + 1;
            }

            if (total_count && total_count > 0) {
                $(input_elem).val(total_count);
            }
        },

        'cart_init' : function (elem, position = "down", product_id = 0) {
            var total_count;
            var input_elem = $(elem).closest('.count-input').find('.product-quantity');
            total_count = parseInt($(input_elem).val()) - 1;

            if (position === "up") {
                total_count = parseInt($(input_elem).val()) + 1;
            }

            if (total_count && total_count > 0) {
                $(input_elem).val(total_count);

                if (product_id > 0) {
                    jQuery.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'update_cart_item_quantity',
                            product_id: product_id,
                            quantity: total_count
                        },
                        success: function(response) {
                            if(response.success) {
                                loadCartContents();
                            }
                        }
                    });
                }
            }
        }
    },

    coupons: {
        init: function() {
            if (document.getElementById('apply_coupon')) {
                document.getElementById('apply_coupon').addEventListener('click', this.applyCoupon);
            }
        },

        applyCoupon: function() {
            const couponCode = document.getElementById('coupon_code').value;
            const responseDiv = document.getElementById('coupon_response');

            if (!couponCode) {
                checkout.coupons.showMessage('Lütfen bir kupon kodu girin.', 'error');
                return;
            }

            jQuery.ajax({
                type: 'POST',
                url: ajaxurl,
                data: {
                    action: 'apply_coupon',
                    coupon_code: couponCode,
                    security: ajax_object.nonce
                },
                beforeSend: function() {
                    document.getElementById('apply_coupon').textContent = 'Uygulanıyor...';
                },
                success: function(response) {
                    if (response.success) {
                        checkout.coupons.showMessage('Kupon başarıyla uygulandı!', 'success');
                        loadCartContents();
                    } else {
                        checkout.coupons.showMessage(response.data.message || 'Kupon uygulanamadı.', 'error');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', error);
                    checkout.coupons.showMessage('Bir hata oluştu. Lütfen tekrar deneyin.', 'error');
                },
                complete: function() {
                    document.getElementById('apply_coupon').textContent = 'Uygula';
                }
            });
        },

        showMessage: function(message, type) {
            const responseDiv = document.getElementById('coupon_response');
            responseDiv.innerHTML = message;
            responseDiv.className = `uk-text-small uk-text-${type === 'success' ? 'success' : 'danger'}`;
            responseDiv.style.display = 'block';

            setTimeout(() => {
                responseDiv.style.display = 'none';
            }, 3000);
        }
    }
};

document.addEventListener('DOMContentLoaded', function () {
    const addToCartBtn = document.getElementById('add-to-cart-btn');

    if (addToCartBtn) {
        addToCartBtn.addEventListener('click', function() {
            var productId = document.querySelector('input[name="product_id"]').value;
            var quantity = document.getElementById('input-quantity').value;

            // AJAX request to add product to cart
            var data = {
                action: 'add_to_cart',  // WordPress AJAX action hook
                product_id: productId,
                quantity: quantity
            };

            // Make the AJAX request
            jQuery.post(ajaxurl, data, function(response) {
                if (response.success) {
                    // Show cart modal after successful add
                    showCartModal();
                } else {
                    alert('There was an error adding the product to your cart.');
                }
            });
        });
    }
});

function showCartModal() {
    setTimeout(function () {
        UIkit.offcanvas('#offcanvas-basket').show();
    }, 750);
    loadCartContents();
}

function loadCartContents() {
    jQuery.post(ajaxurl, { action: 'get_cart_contents' }, function(response) {
        if (response.success) {
            var cartHtml = response.data.cart_html;
            document.getElementById('cart').innerHTML = cartHtml;
        }
    });
}


function removeFromCart(button) {
    var itemId = button.getAttribute('data-item-id');

    jQuery.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
            action: 'remove_from_cart',
            item_id: itemId // Ürün ID'si
        },
        success: function(response) {
            if(response.success) {
                loadCartContents();
            }
        }
    });
}

function toggleFavorite(button) {
    var itemId = button.getAttribute('data-item-id');
    var action = button.classList.contains('added-to-favorites') ? 'remove_from_favorites' : 'add_to_favorites';

    jQuery.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
            action: action,
            item_id: itemId // Ürün ID'si
        },
        success: function(response) {
            if(response.success) {
                updateFavoriteButton(button, action);
            }
        }
    });
}

function updateFavoriteButton(button, action) {
    if (action === 'add_to_favorites') {
        button.classList.add('added-to-favorites');
        button.textContent = 'Favorilerden Çıkar';
    } else {
        button.classList.remove('added-to-favorites');
        button.textContent = 'Favorilere Ekle';
    }
}

// Checkout sayfası için kupon işlemleri
var checkoutCoupons = {
    init: function() {
        // Kupon ekleme butonu
        $(document).on('click', '#checkout-add-coupon', function(e) {
            e.preventDefault();
            checkoutCoupons.applyCoupon();
        });

        // Enter tuşu ile kupon ekleme
        $(document).on('keypress', '#checkout-input-coupon', function(e) {
            if (e.which == 13) {
                e.preventDefault();
                checkoutCoupons.applyCoupon();
            }
        });

        // Kupon kaldırma
        $(document).on('click', '.remove-coupon', function(e) {
            e.preventDefault();
            checkoutCoupons.removeCoupon($(this));
        });

        // console.log('Checkout coupon handlers initialized');
    },

    applyCoupon: function() {
        var couponCode = $('#checkout-input-coupon').val();
        var $button = $('#checkout-add-coupon');
        var $input = $('#checkout-input-coupon');

        if (!couponCode) {
            this.showMessage('Lütfen bir kupon kodu girin.', 'error');
            return;
        }

        $button.prop('disabled', true);
        $input.prop('disabled', true);

        $.ajax({
            type: 'POST',
            url: wc_checkout_params.wc_ajax_url.toString().replace('%%endpoint%%', 'apply_coupon'),
            data: {
                security: wc_checkout_params.apply_coupon_nonce,
                coupon_code: couponCode
            },
            beforeSend: function() {
                console.log('Kupon uygulanıyor...');
                //$button.text('Uygulanıyor...');
            },
            success: function(response) {
                //console.log('Kupon yanıtı:', response);
                
                // HTML yanıt kontrolü
                if (typeof response === 'string' && response.includes('woocommerce-message')) {
                    //checkoutCoupons.showMessage('Kupon başarıyla uygulandı!', 'success');
                    window.location.reload();
                    return;
                }
                
                // JSON yanıt kontrolü
                if (response.success) {
                    //checkoutCoupons.showMessage('Kupon başarıyla uygulandı!', 'success');
                    window.location.reload();
                } else {
                    var errorMessage = response.data && response.data.message ? 
                        response.data.message : 
                        'Kupon uygulanamadı.';
                    checkoutCoupons.showMessage(errorMessage, 'error');
                }
            },
            error: function(xhr, status, error) {
                /*console.error('Kupon hatası:', error);
                console.error('XHR Durumu:', status);
                console.error('XHR Yanıtı:', xhr.responseText);*/
                
                // Hata yanıtında HTML mesajı kontrolü
                if (xhr.responseText && xhr.responseText.includes('woocommerce-error')) {
                    var $temp = $('<div>').html(xhr.responseText);
                    var errorMessage = $temp.find('.woocommerce-error').text() || 'Bir hata oluştu. Lütfen tekrar deneyin.';
                    checkoutCoupons.showMessage(errorMessage, 'error');
                } else {
                    checkoutCoupons.showMessage('Bir hata oluştu. Lütfen tekrar deneyin.', 'error');
                }
            },
            complete: function() {
                $button.prop('disabled', false);
                $input.prop('disabled', false);
                //$button.text('Uygula');
            }
        });
    },

    removeCoupon: function($button) {
        var couponCode = $button.data('coupon');
        var $item = $button.closest('.coupon-item');

        $item.css('opacity', '0.5');

        $.ajax({
            type: 'POST',
            url: wc_checkout_params.ajax_url,
            data: {
                action: 'remove_coupon',
                security: $('#apply-coupon-nonce').val(),
                coupon_code: couponCode
            },
            success: function(response) {
                //console.log('Kupon kaldırma yanıtı:', response);
                
                // HTML yanıt kontrolü
                if (typeof response === 'string' && response.includes('woocommerce-message')) {
                    checkoutCoupons.showMessage('Kupon başarıyla kaldırıldı!', 'success');
                    window.location.reload();
                    return;
                }
                
                // JSON yanıt kontrolü
                if (response.success) {
                    $item.slideUp(300, function() {
                        $(this).remove();
                    });
                    //checkoutCoupons.showMessage('Kupon başarıyla kaldırıldı!', 'success');
                    window.location.reload();
                } else {
                    $item.css('opacity', '1');
                    var errorMessage = response.data && response.data.message ? 
                        response.data.message : 
                        'Kupon kaldırılırken bir hata oluştu.';
                    checkoutCoupons.showMessage(errorMessage, 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error('Kupon kaldırma hatası:', error);
                console.error('XHR Durumu:', status);
                console.error('XHR Yanıtı:', xhr.responseText);
                
                $item.css('opacity', '1');
                
                // Hata yanıtında HTML mesajı kontrolü
                if (xhr.responseText && xhr.responseText.includes('woocommerce-error')) {
                    var $temp = $('<div>').html(xhr.responseText);
                    var errorMessage = $temp.find('.woocommerce-error').text() || 'Kupon kaldırılırken bir hata oluştu.';
                    checkoutCoupons.showMessage(errorMessage, 'error');
                } else {
                    checkoutCoupons.showMessage('Kupon kaldırılırken bir hata oluştu.', 'error');
                }
            }
        });
    },

    showMessage: function(message, type) {
        $('.coupon-message').remove();

        var $messageDiv = $('<div>', {
            class: 'coupon-message uk-alert uk-alert-' + (type === 'success' ? 'success' : 'danger') + ' uk-margin-small-top',
            text: message
        });

        $('.coupon-input').after($messageDiv);

        setTimeout(function() {
            $messageDiv.fadeOut(300, function() {
                $(this).remove();
            });
        }, 3000);
    }
};

var cartCoupons = {
    init: function() {
        // Kupon ekleme butonu
        $(document).on('click', '#cart-add-coupon', function(e) {
            e.preventDefault();
            cartCoupons.applyCoupon();
        });

        // Enter tuşu ile kupon ekleme
        $(document).on('keypress', '#cart-input-coupon', function(e) {
            if (e.which == 13) {
                e.preventDefault();
                cartCoupons.applyCoupon();
            }
        });

        // Kupon kaldırma
        $(document).on('click', '.cart-remove-coupon', function(e) {
            e.preventDefault();
            cartCoupons.removeCoupon($(this));
        });
    },

    applyCoupon: function() {
        var couponCode = $('#cart-input-coupon').val();
        var $button = $('#cart-add-coupon');
        var $input = $('#cart-input-coupon');

        if (!couponCode) {
            this.showMessage('Lütfen bir kupon kodu girin.', 'error');
            return;
        }

        $button.prop('disabled', true);
        $input.prop('disabled', true);

        $.ajax({
            type: 'POST',
            url: wc_cart_params.wc_ajax_url.toString().replace('%%endpoint%%', 'apply_coupon'),
            data: {
                security: wc_cart_params.apply_coupon_nonce,
                coupon_code: couponCode
            },
            success: function(response) {
                if (typeof response === 'string' && response.includes('woocommerce-message')) {
                    window.location.reload();
                    return;
                }
                
                if (response.success) {
                    window.location.reload();
                } else {
                    var errorMessage = response.data && response.data.message ? 
                        response.data.message : 
                        'Kupon uygulanamadı.';
                    cartCoupons.showMessage(errorMessage, 'error');
                }
            },
            error: function(xhr, status, error) {
                if (xhr.responseText && xhr.responseText.includes('woocommerce-error')) {
                    var $temp = $('<div>').html(xhr.responseText);
                    var errorMessage = $temp.find('.woocommerce-error').text() || 'Bir hata oluştu. Lütfen tekrar deneyin.';
                    cartCoupons.showMessage(errorMessage, 'error');
                } else {
                    cartCoupons.showMessage('Bir hata oluştu. Lütfen tekrar deneyin.', 'error');
                }
            },
            complete: function() {
                $button.prop('disabled', false);
                $input.prop('disabled', false);
            }
        });
    },

    removeCoupon: function($button) {
        var couponCode = $button.data('coupon');
        var $item = $button.closest('.cart-coupon-item');

        $item.css('opacity', '0.5');

        $.ajax({
            type: 'POST',
            url: wc_cart_params.ajax_url,
            data: {
                action: 'remove_coupon',
                security: $('#cart-coupon-nonce').val(),
                coupon_code: couponCode
            },
            success: function(response) {
                if (typeof response === 'string' && response.includes('woocommerce-message')) {
                    cartCoupons.showMessage('Kupon başarıyla kaldırıldı!', 'success');
                    window.location.reload();
                    return;
                }
                
                if (response.success) {
                    $item.slideUp(300, function() {
                        $(this).remove();
                    });
                    window.location.reload();
                } else {
                    $item.css('opacity', '1');
                    var errorMessage = response.data && response.data.message ? 
                        response.data.message : 
                        'Kupon kaldırılırken bir hata oluştu.';
                    cartCoupons.showMessage(errorMessage, 'error');
                }
            },
            error: function(xhr, status, error) {
                $item.css('opacity', '1');
                
                if (xhr.responseText && xhr.responseText.includes('woocommerce-error')) {
                    var $temp = $('<div>').html(xhr.responseText);
                    var errorMessage = $temp.find('.woocommerce-error').text() || 'Kupon kaldırılırken bir hata oluştu.';
                    cartCoupons.showMessage(errorMessage, 'error');
                } else {
                    cartCoupons.showMessage('Kupon kaldırılırken bir hata oluştu.', 'error');
                }
            }
        });
    },

    showMessage: function(message, type) {
        $('.cart-coupon-message').remove();

        var $messageDiv = $('<div>', {
            class: 'cart-coupon-message uk-alert uk-alert-' + (type === 'success' ? 'success' : 'danger') + ' uk-margin-small-top',
            text: message
        });

        $('.cart-coupon-input').after($messageDiv);

        setTimeout(function() {
            $messageDiv.fadeOut(300, function() {
                $(this).remove();
            });
        }, 3000);
    }
};

// Initialize both coupon handlers
document.addEventListener('DOMContentLoaded', function() {
    checkout.coupons.init();
    checkoutCoupons.init();
    cartCoupons.init();
});