
/*** MAIN JS ***/

/** Function Js **/
$(function () {
    $.pageJsPlugin = {

        swiperCarousel: function() {

            if ($('.swiper-product-detail-thumbs').length > 0) {
                var productDetailSwiperThumbs = new Swiper('.swiper-product-detail-thumbs', {
                    direction: 'vertical',
                    loop: false,
                    spaceBetween: 15,
                    slidesPerView: 'auto',
                    slideToClickedSlide: false,
                    watchSlidesVisibility: true,
                    preventClicks: false,
                    preventClicksPropagation: false,
                    mousewheel: true,
                    touchRatio: 0,
                    breakpoints: {
                        // when window width is >= 320px
                        320: {
                            touchRatio: 1
                        }
                    },
                    on: {
                        init: function () {
                            setTimeout(function () {
                                productDetailSwiperThumbs.update(true);
                                productDetailSwiperThumbs.slideTo(0, 0)
                            }, 100);
                        }
                    }
                });
            }

            if ($('.swiper-product-detail').length > 0) {
                var productDetailSwiper = new Swiper(".swiper-product-detail", {
                    speed: 600,
                    dots: false,
                    slideToClickedSlide: false,
                    preventClicks: true,
                    preventClicksPropagation: true,
                    navigation: {
                        nextEl: ".product-detail-button-next",
                        prevEl: ".product-detail-button-prev",
                        clickable: true
                    },
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: true,
                    },
                    thumbs: {
                        swiper: productDetailSwiperThumbs
                    },
                    on: {
                        transitionEnd: function (el) {
                            $('.swiper-product-detail-thumbs .swiper-slide-thumb-active img').trigger("click");
                        },
                        imagesReady: function () {
                            $.pageJsPlugin.easyZoom();
                        }
                    },
                });
            }

            if ($('.swiper-products').length > 0) {
                new Swiper(".swiper-products", {
                    loop: true,
                    speed: 600,
                    spaceBetween: 10,
                    slidesPerView: 1,
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                        clickable: true
                    },
                    // Responsive breakpoints
                    breakpoints: {
                        // when window width is >= 480px
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 20,
                        },
                        // when window width is >= 480px
                        991: {
                            slidesPerView: 3,
                            spaceBetween: 20,
                        },
                        // when window width is >= 640px
                        1280: {
                            slidesPerView: 5,
                            spaceBetween: 20,
                        },
                    },
                });
            }

            if ($('.swiper-recommend-products').length > 0) {
                new Swiper(".swiper-recommend-products", {
                    loop: true,
                    speed: 600,
                    spaceBetween: 10,
                    slidesPerView: 2.5,
                    autoplay: {
                        delay: 3000,
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: null,
                        prevEl: null,
                        clickable: true
                    },
                    // Responsive breakpoints
                    breakpoints: {
                        // when window width is >= 480px
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 20,
                        },
                        // when window width is >= 480px
                        991: {
                            slidesPerView: 3,
                            spaceBetween: 20,
                        },
                        // when window width is >= 640px
                        1280: {
                            slidesPerView: 4,
                            spaceBetween: 20,
                        },
                    },
                });
            }

            if ($('.swiper-banner_layout').length > 0) {
                new Swiper(".swiper-banner_layout", {
                    loop: true,
                    speed: 600,
                    autoplay: false,
                    spaceBetween: 10,
                    slidesPerView: 1.5,
                    draggable: false,
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                        clickable: true
                    },
                    // Responsive breakpoints
                    breakpoints: {
                        // when window width is >= 319px
                        319.9: {
                            touchRatio: 1,
                            slidesPerView: 1,
                            spaceBetween: 20,
                            pagination: {
                                el: ".swiper-pagination",
                                clickable: true,
                            },
                        },
                        // when window width is >= 768px
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 20,
                            pagination: {}
                        },
                        // when window width is >= 991px
                        991: {
                            slidesPerView: 2,
                            spaceBetween: 20,
                        },
                        // when window width is >= 1280px
                        1280: {
                            slidesPerView: 3,
                            spaceBetween: 20,
                            draggable: false,
                            touchRatio: 0
                        },
                    },
                });
            }

            if ($('.swiper-banner_layout_full').length > 0) {
                new Swiper(".swiper-banner_layout_full", {
                    loop: true,
                    speed: 1000,
                    autoplay: true,
                    spaceBetween: 0,
                    slidesPerView: 1,
                    navigation: false,
                    draggable: false,
                    breakpoints: {
                        320: {
                            pagination: {
                                el: ".swiper-pagination",
                                clickable: true,
                            },
                        },
                        992: {
                            pagination: {},
                        }
                    }
                });
            }

            if ($('.section-rdd__carousel-carousel').length > 0) {
                new Swiper(".section-rdd__carousel-carousel", {
                    loop: false,
                    speed: 1000,
                    navigation: false,
                    draggable: false,
                    autoplay: {
                        delay: 8000,
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: ".section-rdd__carousel-pagination",
                        clickable: true,
                    },
                });
            }

            if ($('.swiper-product-related').length > 0) {
                new Swiper(".swiper-product-related", {
                    loop: true,
                    speed: 600,
                    spaceBetween: 10,
                    slidesPerView: 1.5,
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                        clickable: true
                    },
                    // Responsive breakpoints
                    breakpoints: {
                        // when window width is >= 480px
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 20,
                        },
                        // when window width is >= 480px
                        991: {
                            slidesPerView: 3,
                            spaceBetween: 20,
                        },
                        // when window width is >= 640px
                        1280: {
                            slidesPerView: 4,
                            spaceBetween: 20,
                        },
                    },
                });
            }

            if ($('.swiper-product-recently').length > 0) {
                new Swiper(".swiper-product-recently", {
                    loop: false,
                    speed: 600,
                    spaceBetween: 10,
                    slidesPerView: 1.5,
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                        clickable: true
                    },
                    // Responsive breakpoints
                    breakpoints: {
                        // when window width is >= 480px
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 20,
                        },
                        // when window width is >= 480px
                        991: {
                            slidesPerView: 3,
                            spaceBetween: 20,
                        },
                        // when window width is >= 640px
                        1280: {
                            slidesPerView: 4,
                            spaceBetween: 20,
                        },
                    },
                });
            }
        },

        swiperDenimJs: function (){
            if ($('.swiper-denim').length > 0) {
                var denim_swiper = new Swiper(".swiper-denim", {
                    loop: false,
                    speed: 600,
                    spaceBetween: 10,
                    slidesPerView: 2,
                    preventClicks: false,
                    preventClicksPropagation: false,
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                        clickable: true
                    },
                    // Responsive breakpoints
                    breakpoints: {
                        320: {
                            slidesPerView: 2.5,
                            spaceBetween: 10,
                        },
                        // when window width is >= 768px
                        768: {
                            slidesPerView: 3.5,
                            spaceBetween: 10,
                        },
                        // when window width is >= 991px
                        991: {
                            slidesPerView: 4,
                            spaceBetween: 10,
                        },
                        // when window width is >= 1280px
                        1280: {
                            slidesPerView: 6,
                            spaceBetween: 10,
                            loop: false,
                        },
                    },
                    on: {
                        init: function (evt) {
                            var getSlideIndexByClass = function getSlideIndexByClass(className) {
                                var index = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                                $.each($('.swiper-wrapper').children(), function (i, item) {
                                    if ($(item).hasClass(className)) {
                                        index = i;
                                        return false;
                                    }
                                });
                                return index;
                            };
                            let index_currentSlide = evt.activeIndex;
                            evt.slideTo(getSlideIndexByClass('active-item', index_currentSlide));
                        }
                    }
                });
            }
        },

        // PARALLAX JS
        parallaxJs: function () {
            if ($('.parallax').length > 0) {
                simpleParallax($('.parallax'));
            }

            function simpleParallax(element) {
                $(window).scroll(function () {
                    var scrolled = $(window).scrollTop();
                    element.each(function (index, element) {
                        var initY = $(this).offset().top;
                        var height = $(this).height();
                        var endY = initY + $(this).height();

                        // Check if the element is in the viewport.
                        var visible = $.pageJsPlugin.isInViewport(this);
                        if (visible) {
                            var diff = scrolled - initY;
                            var ratio = Math.round((diff / height) * 100);
                            var scroll_ratio = $.pageJsPlugin.mobileCheck() ? 0.4 : 0.4;
                            $(this).css('transform', 'translateY(' + parseInt(-(ratio * scroll_ratio)) + 'px)');
                        }
                    });
                });
            }
        },

        isInViewport: function(node){
            var rect = node.getBoundingClientRect()
            return (
                (rect.height > 0 || rect.width > 0) &&
                rect.bottom >= 0 &&
                rect.right >= 0 &&
                rect.top <= (window.innerHeight || document.documentElement.clientHeight) &&
                rect.left <= (window.innerWidth || document.documentElement.clientWidth)
            )
        },

        easyZoom: function () {
            if ($('.easyzoom').length > 0) {
                var $easyzoom = $('.easyzoom').easyZoom();
                var api1 = $easyzoom.filter('.easyzoom--with-thumbnails').data('easyZoom');
                var api2 = $easyzoom.filter('.easyzoom--with-toggle').data('easyZoom');
                var thumbnailsEvent = true;

                var owlResize = function owlResize(api2) {
                    if ($.pageJsPlugin.mobileCheck()) {
                        api2.teardown();
                        thumbnailsEvent = false;
                    } else {
                        api2._init();
                        thumbnailsEvent = true;
                    }
                };

                $(document).on('click', '.easyzoom-thumbnails', function (e) {
                    var $this = $(this);
                    e.preventDefault();
                    if (thumbnailsEvent) {
                        api1.swap($this.data('standard'), $this.attr('data-easy'));
                    }
                });

                owlResize(api2);
                $(window).resize(function () {
                    owlResize(api2);
                });
            }
        },

        generalPlaceholder : function(){
            var textarea = $("textarea");
            var input = $("input");
            var attrClass = "has";

            // Input value control
            $(input).each(function () {
                if(this.value){
                    this.classList.add(attrClass);
                }else{
                    this.classList.remove(attrClass);
                }
            });

            $(input).bind('input focus blur', function() {
                var text = $(this).val();
                if(text.length > 0){
                    $(this).addClass(attrClass);
                }else{
                    $(this).removeClass(attrClass);
                }
            });

            // Textarea value control
            $(textarea).each(function () {
                if(this.value){
                    this.classList.add(attrClass);
                }else{
                    this.classList.remove(attrClass)
                }
            });

            $(textarea).bind('input propertychange', function() {
                var text = $(this).val();
                if(text.length > 0){
                    $(this).addClass(attrClass);
                }else{
                    $(this).removeClass(attrClass);
                }
            });
        },

        slideVimeo : function(){
            if ($('.swiper-hero-banner').length > 0) {
                var swiper_hero_banner = ".swiper-hero-banner";
                var hero_swiper = new Swiper(swiper_hero_banner, {
                    loop: true,
                    speed: 500,
                    // Disable preloading of all images
                    preloadImages: true,
                    // Enable lazy loading
                    lazy: true,
                    autoplay: {
                        delay: 6000,
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: '.swiper-hero-button-next',
                        prevEl: '.swiper-hero-button-prev'
                    },
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: true,
                    },
                    on: {
                        init: function() {
                            iframe_load.playDeviceVideo();

                            this.el.addEventListener('mouseenter', () => {
                                this.autoplay.stop();
                            });

                            this.el.addEventListener('mouseleave', () => {
                                this.autoplay.start();
                            });
                        },
                        transitionStart: function() {
                            iframe_load.playDeviceVideo();
                        },
                        transitionEnd : function() {
                            iframe_load.playDeviceVideo();
                        }
                    },
                });
            }
        },

        selectJs : function(){
            if ($('select.select-theme').length > 0) {
                var $theme_select;
                $theme_select = $("select.select-theme").select2({
                    width: '200',
                    minimumResultsForSearch: Infinity
                });
            }
        },

        copyUrl: function(){
            var url = document.getElementById("copy_url");
            if(url){
                url.select();
                document.execCommand("copy");
            }
        },

        tooltips: function(){
            $("[data-toggle_tooltips]").on("click", function () {
                var toggle = $(this).attr("data-toggle_tooltips");
                $("[data-label_tooltips*="+toggle+"]").addClass("tooltips_active");
                setTimeout(function () {
                    $("[data-label_tooltips*="+toggle+"]").removeClass("tooltips_active");
                }, 750);
            });
        },

        vimeoControl: function () {
            let all_video = $('.vimeo');
            if(all_video.length){
                $.each(all_video, function(key, vimeo){
                    var player = new Vimeo.Player($(vimeo).find('iframe'));
                    player.setMuted(true);

                    $(vimeo).click(function (e) {
                        player.getPaused().then(function (paused) {
                            if (paused) {
                                player.play();
                                $(vimeo).addClass('play');
                            }else{
                                console.log("b");
                                player.pause();
                            }
                        });
                        e.preventDefault();
                    });

                    player.on('pause', function() {
                        $(vimeo).removeClass('play');
                    });

                    player.on('play', function() {
                        $(vimeo).addClass('play');
                    });
                });
            }
        },

        popup_basket_add: function(evt){
            var url = $(evt).attr("data-basket");
            if(url) {
                product.modal(url.turkishToLower());
            }
        },

        parentIcon: function(scroll_height,client_height){
            var div = $(".page-parent-scroll");
            if(div.length > 0){
                if(scroll_height > client_height){
                    $(div).addClass("opacityActive");
                }else{
                    $(div).removeClass("opacityActive");
                }
            }
        },

        timeout: function (t, v) {
            return new Promise(function (resolve) {
                setTimeout(resolve.bind(null, v), t)
            });
        },

        mobileCheck : function(){
            let windowScreenSize = $(window).width();
            let mobile = false;

            function detectmob() {
                if( navigator.userAgent.match(/Android/i)
                    || navigator.userAgent.match(/webOS/i)
                    || navigator.userAgent.match(/iPhone/i)
                    || navigator.userAgent.match(/iPad/i)
                    || navigator.userAgent.match(/iPod/i)
                    || navigator.userAgent.match(/BlackBerry/i)
                    || navigator.userAgent.match(/Windows Phone/i)
                ){
                    return true;
                }
                else {
                    return false;
                }
            }

            if(detectmob() || windowScreenSize <= 768){
                mobile = true;
            }

            return mobile;
        },

        init: function() {
            this.swiperCarousel();
            this.swiperDenimJs();
            this.generalPlaceholder();
            this.slideVimeo();
            this.tooltips();
            this.selectJs();
            this.vimeoControl();
            this.parallaxJs();
        }

    }
}(jQuery));

String.prototype.turkishToUpper = function(){
    var string = this;
    var letters = { "i": "İ", "ş": "Ş", "ğ": "Ğ", "ü": "Ü", "ö": "Ö", "ç": "Ç", "ı": "I" };
    string = string.replace(/(([iışğüçö]))/g, function(letter){ return letters[letter]; })
    return string.toUpperCase();
};

String.prototype.turkishToLower = function(){
    var string = this;
    var letters = { "İ": "i", "I": "ı", "Ş": "ş", "Ğ": "ğ", "Ü": "ü", "Ö": "ö", "Ç": "ç" };
    string = string.replace(/(([İIŞĞÜÇÖ]))/g, function(letter){ return letters[letter]; })
    return string.toLowerCase();
};
var storage;

var kvkk = localStorage.getItem("kvkk");


var header_search = {
    search:function () {
        var val = $('#search').val();
        if (val.length < 1) {
            $('.search-result').addClass("uk-hidden");
            $("body").removeClass("search");
        } else {
            $('.search-result').removeClass("uk-hidden");
            $("body").addClass("search");

            $.ajax({
                url: 'index.php?route=common/search/search&search=' +  encodeURIComponent(val),
                //url: 'index.php?route=common/search/search',
                //type: 'post',
                //data: {'filter_name' : val},
                beforeSend: function() {
                    $('.search-result').html('');
                },
                success: function(html) {
                    $('.search-result').html(html);
                    lazy.scroll();
                }
            });
        }
    }
}

var collapse = {
    init:function () {
        var cookie_status = arguments.length >= 1 && arguments[0] !== undefined ? arguments[0] : true;
        storage  = $.localStorage;

        // Toggle plus minus icon on show hide of collapse element
        $(".collapse")
            .on("show.bs.collapse", function () {
                storage.set('open_' + this.id, true);
                $(this).prev(".card-header").removeClass("plus").addClass("minus");
            })
            .on("hide.bs.collapse", function () {
                storage.remove('open_' + this.id);
                $(this).prev(".card-header").removeClass("minus").addClass("plus");
            });

        $('.collapse').each(function () {
            if(cookie_status){
                if (storage.get('open_' + this.id) == true) {
                    $(this).collapse('show');
                }
            }
        });

        // Add minus icon for collapse element which is open by default
        $(".collapse.show").each(function () {
            $(this).prev(".card-header").addClass("minus").removeClass("plus");
        });
    }
}


// Cart List
function isMobile() {
    return window.innerWidth <= 767;
}
function isTablet() {
    return window.innerWidth <= 1023;
}

var mobile_detect = {
    init : function () {
        let isMobile = false;
        if($.pageJsPlugin.mobileCheck()){
            isMobile = true;
        }

        $(window).resize(function () {
            if($.pageJsPlugin.mobileCheck()){
                isMobile = true;
            }
        });
        return isMobile;
    }
};

var accordion_scroll_event = {
    'filter_event': function () {
        if($('#product-filter .collapse').length > 0){
            $('#product-filter .collapse').on('shown.bs.collapse', function (e) {
                if(mobile_detect.init()){
                    var default_height = 44;
                    var curr = $(this);
                    if(curr){
                        var scrollPosition = $(curr)[0].offsetTop;
                        if(scrollPosition){
                            var scrollPositionTop = (scrollPosition - default_height);
                            setTimeout(function(){
                                $("#product-filter").animate({scrollTop : scrollPositionTop}, {
                                    duration: 600,
                                    easing: 'swing'
                                });
                            }, 250);
                        }
                    }
                }
            });
        }
    },
    'init': function () {
        this.filter_event();
    }
};

var video_status = {
    'video': function () {
        var feed_video = "feed_video";
        document.addEventListener("scroll", function () {
            let position = video_status.getPosition(feed_video);
            if($(".feed_video").length > 0){
                if(position){
                    $(".feed_video").get(0).play(0);
                }else{
                    $(".feed_video").get(0).pause(0);
                }
            }
        });
    },
    'getPosition': function (el) {
        if (el) {
            var id = document.querySelector("[data-position='" + el + "']");
            if (id) {
                var rect = id.getBoundingClientRect();
                return (
                    rect.top >= 0
                    && rect.left >= 0
                    && rect.top <= (window.innerHeight || document.documentElement.clientHeight)
                )
            }
        } else {
            return false;
        }
    },
    'init': function () {
        this.video();
    }
}

/*** CUSTOM JS ***/
var iframe_load = {
    parent: document.getElementsByClassName("slider"),
    get: function get() {
        return this.parent[0].getElementsByTagName("iframe");
    },
    process: function process(data) {
        var play = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
        var prmse = new Promise(function (resolve, reject) {
            var player = new Vimeo.Player(data);
            player.setMuted(true);

            if (player) {
                resolve(player);
            } else {
                reject("error");
            }
        });
        prmse.then(function (data) {
            data.getPaused().then(function (paused) {
                if (paused && play) {
                    data.play();
                }

                if (!paused && !play) {
                    data.pause();
                }
            });
        }).catch(function (e) {
            console.log(e);
        });
    },
    findDeviceFilter: function findDeviceFilter() {
        var playDevice = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "desktop";
        var getList = this.get();
        setTimeout(function () {
            for (var i = 0; i < getList.length; i++) {
                if (getList[i].getAttribute("data-load") !== playDevice) {
                    iframe_load.process(getList[i], false);
                } else {
                    var parentClass = $(getList[i]).closest('div');

                    if (parentClass.hasClass('swiper-slide-active')) {
                        iframe_load.process(getList[i]);
                    } else {
                        iframe_load.process(getList[i], false);
                    }
                }
            }
        }, 0);
    },
    playDeviceVideo: function playDeviceVideo() {
        function resizeDevice() {
            var isMobile = window.matchMedia("only screen and (max-width: 767.9px)").matches;

            if (isMobile) {
                iframe_load.findDeviceFilter("mobile");
            } else {
                iframe_load.findDeviceFilter("desktop");
            }
        }

        window.addEventListener("resize", function () {
            resizeDevice();
        });
        resizeDevice();
    }
};

var lazy = {
    'scroll' : function () {
        var scrollTop = $(window).scrollTop() + $(window).height();
        $("[data-src]").each(function () {
            if( $(this).offset().top < scrollTop ) {
                $(this).attr('src', $(this).data('src'));
                let ths = $(this);
                let image = $(this);
                image.on('load', function(){
                    setTimeout(function () {
                        ths.closest('.lazy-hide').addClass('loaded');
                        ths.removeAttr('data-src');
                    }, 50);
                });
            }
        })
    }
}


$(document).ready(function () {

    collapse.init(false);
    video_status.init();
    accordion_scroll_event.init();
    lazy.scroll();

    $.pageJsPlugin.init();

    $("[data-trigger]").on("click", function (e) {
        e.preventDefault();
        e.stopPropagation();
        var offcanvas_id = $(this).attr("data-trigger");
        $(offcanvas_id).toggleClass("show");
        $("body").toggleClass("offcanvas-active");
        $(".screen-overlay").toggleClass("show");
    });

    $(document).on('click', '.btn-close, .screen-overlay', function () {
        $(".screen-overlay").removeClass("show");
        $(".offcanvas").removeClass("show");
        $("body").removeClass("offcanvas-active");
    })

    /**
     * Show Password
     */

    $(".show-password").on("click", function () {
        var $pwd = $(".input-password");
        if ($pwd.attr("type") === "password") {
            $pwd.attr("type", "text");
            $(".show-password img").attr("src", "catalog/view/theme/leanfit/image/icons/show-password.svg");
        } else {
            $pwd.attr("type", "password");
            $(".show-password img").attr("src", "catalog/view/theme/leanfit/image/icons/hide-password.svg");
        }
    });


    /**
     * Search Bar
     */
    $(".nav-search").on("click", function (e) {
        $("#search-wrapper").toggleClass("open");
        if ($("#search-wrapper").hasClass("open")) {
            search_status('show');
        } else {
            search_status('hide');
        }
        e.preventDefault();
    });

    if($(".close-search").length > 0) {
        $(".close-search").on("click", function () {
            search_status('hide');
        });
    }

    $(document).delegate(".search-bar", "click", function (e) {
        search_status('hide');
    });


    function search_status() {
        var arg = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "show";
        if(arg == "show"){
            $(".nav-search img").attr("src", "catalog/view/theme/leanfit/image/icons/close-b.svg");
            $("body").append($("<div></div>").addClass("search-bar modal-backdrop"));
            setTimeout(function () {$('#search').focus();}, 300);
        }else{
            $(".nav-search img").attr("src", "catalog/view/theme/leanfit/image/icons/search-b.svg");
            $('.search-result').addClass("d-none");
            $('#search').val('');
            $("#search-wrapper").removeClass("open");
            $("body").removeClass("search");
            $(".search-bar").remove();
        }
    }
    /**
     * Search Bar End
     */


    $(".header .navbar-nav .nav-link").on("mouseover", function () {
        $("body").removeClass("search");
        $("#search-wrapper").removeClass("open");
        $('.search-result').addClass("d-none");
        $('#search').val('');
        $(".nav-search img").attr("src", "catalog/view/theme/leanfit/image/icons/search-b.svg");
    });

    $('.close-search').click(function (e) {
        e.preventDefault();
        $("body").removeClass("search");
        $("#search-wrapper").removeClass("open");
        $('.search-result').addClass("d-none");
        $('#search').val('');

        $(".nav-search img").attr("src", "catalog/view/theme/leanfit/image/icons/search-b.svg");
    });


    $(document).delegate(".product-filter-button .filter", "click", function (e) {
        e.preventDefault();

        $('body').css('overflow', 'hidden');
        $('.product-filter').addClass('open');
    });

    $(document).delegate(".product-filter .close-filter", "click", function (e) {
        e.preventDefault();
        $('body').css('overflow', 'visible');
        $('.product-filter').removeClass('open');
    });


    $('#modalMobileMenu .modal-body > ul > li:not(".pointer-event-click") > a').click(function(e) {
        e.preventDefault();

        var dataId = $(this).attr('data-id');
        $('#modalMobileMenu .submenu').removeClass('open');
        $('#modalMobileMenu .submenu[data-id="' + dataId + '"]').addClass('open');
    });

    $('#modalMobileMenu .submenu > a').click(function(e) {
        e.preventDefault();
        $(this).parent().removeClass('open');
    });


    $("[type=checkbox]").on("click", function(){
        if ($(this).attr("checked")==undefined) {
            $(this).attr("checked","checked");
        } else {
            $(this).attr("checked",false);
        }
    });
    $('.remove-animation').removeClass('remove-animation');

    // Get on top action
    $(".page-parent-scroll").find('a[href^="javascript:;"]').on('click', function(event) {
        event.preventDefault();
        var target = this.getAttribute('data-element');
        if($(target).length) {
            $('html, body').stop().animate({
                scrollTop: $(target).offset().top
            }, 1000);
        }
    });

    /**
     * Readmore
     */
    var $el, $ps, $up, totalHeight;
    $(".category_seo .description_more").click(function() {
        totalHeight = 0;

        $el = $(this);
        $p  = $el.parent();
        $up = $p.parent();
        $ps = $up.find(".description *:not(b)");

        $ps.each(function() {
            totalHeight += $(this).outerHeight(true);
        });

        if(!$(this).hasClass('active')){
            $up.find(".description").css({"height": $up.find(".description").height(), "max-height": 9999}).animate({
                "height": totalHeight
            }).addClass('open_description');

            $(this).html($(this).attr("data-close")).addClass('active');
        }else{
            $up.find(".description").css({"height": $up.find(".description").height()}).animate({
                "height": 180
            }).removeClass('open_description');

            $(this).html($(this).attr("data-readmore")).removeClass('active');
        }

        return false;
    });

    /**
     * Search
     */
    if($('#search').length){
        $(document).on("keyup touchend keydown", "#search", function() {
            header_search.search();
        });
    }

    /**
     * Iphone Fixed
     */
    if(navigator.platform == 'iPad' || navigator.platform == 'iPhone' || navigator.platform == 'iPod') {
        $("#cookies").addClass("ios-fixed");
    };
    /**
     * Iphone Fixed End
     */


    $(document).on('click', '[data-toggle="ajaxModal"]', function (e) {
        $('#ajaxModal').remove();
        e.preventDefault();
        var $this = $(this);
        var $remote = $this.data('remote') || $this.attr('href');
        var $title = $this.data('title');
        $.get($remote, function (data) {
            var $modal = '<div class="modal fade" id="ajaxModal" tabindex="-1" role="dialog" aria-labelledby="ajaxModalLabel" aria-hidden="true">\n' +
                '  <div class="modal-dialog modal-lg" role="document">\n' +
                '    <div class="modal-content">\n' +
                '      <div class="modal-header">\n' +
                '        <h5 class="modal-title" id="ajaxModalLabel">'+$title+'</h5>\n' +
                '        <button type="button" class="close" data-dismiss="modal" aria-label="Close">\n' +
                '          <span aria-hidden="true">&times;</span>\n' +
                '        </button>\n' +
                '      </div>\n' +
                '      <div class="modal-body">'+ data + '</div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>';

            $('body').append($modal);
            $('#ajaxModal').modal('show');
        });
    });

    // $('[data-toggle="tooltip"]').tooltip();
    // $('[data-toggle="popover"]').popover();

    WindowScroll.infinity();
});


window.addEventListener('popstate', function(e){
    location.reload();
});

window.addEventListener('scroll', function(e){
    lazy.scroll();

    // Get on top function
    $.pageJsPlugin.parentIcon((document.documentElement.scrollTop + document.body.scrollTop),document.documentElement.clientHeight);
});

document.addEventListener("DOMContentLoaded", function () {
    var elementExists = document.getElementById("search-wrapper");
    if (typeof(elementExists) != 'undefined' && elementExists != null){
        elementExists.addEventListener('scroll',
            function() { lazy.scroll(); }, false
        )
    }
});
var WindowScroll = {
    exist:false,
    element:null,
    'infinity':function () {
        if($('.pagination__next').length > 0){


            if(WindowScroll.element)
                WindowScroll.element.destroy();

            WindowScroll.element = new InfiniteScroll( '.product-container', {
                path: '.pagination__next',
                append: '.scroll-product-item',
                status: '.scroller-status',
                scrollThreshold: $(window).height() * 2,
                history: false,
                //debug:true,
                //hideNav: '.pagination',
            });



            $(WindowScroll.element).on( 'load.infiniteScroll', function( event, body, path, response ) {
                setTimeout(function () {
                    lazy.scroll();
                },10)
            });
        }
    }
}

// Modal menü açıldığında
UIkit.util.on('#modal-menu', 'beforeshow', function () {
    document.documentElement.classList.add('modal-menu-popup');
    window.scrollTo(0, 0);
});

// Modal menü kapatıldığında
UIkit.util.on('#modal-menu', 'beforehide', function () {
    document.documentElement.classList.remove('modal-menu-popup');
});

// -------------------------
// about header
$(".information-information-4").each(() => {
    document.getElementById("top").classList.add("fixed-header")
    document.querySelector(".mobile-header").classList.add("fixed-header")
});

// password input
document.addEventListener('DOMContentLoaded', function () {
    var showPasswordBtns = document.querySelectorAll('.show-password-btn');

    showPasswordBtns.forEach(function(btn) {
        btn.addEventListener('click', function () {
            var parentContainer = btn.closest('.uk-inline');
            var passwordInput = parentContainer.querySelector('input');
            var iconContainer = btn.querySelector('.input-password-icon');

            var isPasswordVisible = passwordInput.type === 'text';
            passwordInput.type = isPasswordVisible ? 'password' : 'text';

            var newText = isPasswordVisible ? btn.getAttribute('data-text-show') : btn.getAttribute('data-text-hide');
            btn.innerHTML = newText;
        });
    });
});

// History detail
document.addEventListener('DOMContentLoaded', function () {

    var historyBtn = document.querySelectorAll('.history-box');

    historyBtn.forEach(function(btn) {
        btn.addEventListener('click', function () {
            var id = $(this).attr('data-id');
            var a = document.getElementById("history-btn-" + id);
            a.click();
        });
    });
});

$(document).ready(function() {
    $("#search_filter_toggler").on("click", function() {
        $("#filter-button-old").addClass("hidden");
        $("#search_filter_ok_old").removeClass("hidden");
        $("#filter-column").removeClass("d-none");
        document.documentElement.style.overflow = "hidden";
    });

    $(".ok").on("click", function() {
        $("#search_filter_ok_old").addClass("hidden");
        $("#filter-button-old").removeClass("hidden");
        $("#filter-column").addClass("d-none");
        document.documentElement.style.overflow = "auto";
    });

    if (isMobile()) {
        var sortColumnHtml = $("#sort-column").html();
        var filterColumnContent = $("#filter-column").html();
        $("#filter-column").html(sortColumnHtml + filterColumnContent);
    }

    // summary checkout cart
    var header = document.querySelector('.header-all');
    var summary_footer = document.querySelector('.summary-footer');
    var checkout_box = document.getElementById('checkout-box');
    var summary_products = document.getElementById('summary-products');
    var cart_product_list = document.getElementById('cart-product-list');

    if (!isTablet() && header && summary_footer && summary_products && cart_product_list) {

        header = header.offsetHeight;
        summary_footer = summary_footer.offsetHeight;
        checkout_box.style.height = "calc(100vh - " + header + "px)";
        checkout_box.style.overflow = "hidden";

        var total_height = checkout_box.offsetHeight;
        summary_footer += document.querySelector('.summary-footer-2').offsetHeight;
        total_height -= summary_footer;
        total_height -= 320;
        summary_products.style.maxHeight = total_height + "px"

        var cart_product_list_height = checkout_box.offsetHeight;
        cart_product_list_height -= 100;

        cart_product_list.style.maxHeight = cart_product_list_height + "px"
    }
});

// telefon numara inputlarına sadece sayı yazılsın
$(document).ready(function() {
    var phoneInput = document.querySelector('.phone-number');

    if (phoneInput) {
        phoneInput.addEventListener('keypress', function (event) {
            if (/\D/.test(String.fromCharCode(event.keyCode))) {
                event.preventDefault();
            }
        });
    }
});