<?php
/**
* Login Form
*
* This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
*
* HOWEVER, on occasion WooCommerce will need to update template files and you
* (the theme developer) will need to copy the new files to your theme to
* maintain compatibility. We try to do this as little as possible, but it does
* happen. When this occurs the version of the template file will be bumped and
* the readme will list any important changes.
*
* @see     https://docs.woocommerce.com/document/template-structure/
* @package WooCommerce/Templates
* @version 3.6.0
*/

if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly.
}

do_action( 'woocommerce_before_customer_login_form' ); ?>

<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>



<div style="float:left;" class="col-lg-12">
<div class="beyaz">
<?php echo do_shortcode('[woo_social_login]'); ?>
</div>
</div>

<div style="float:left;" class="col-lg-6">
<div class="beyaz">

<?php endif; ?>

<h1>GİRİŞ YAP</h1>

<form class="woocommerce-form woocommerce-form-login login" method="post">

<?php do_action( 'woocommerce_login_form_start' ); ?>

<!-- Özelleştirme // Üye Girişi -->
<div style="margin-top:10px;font-size:13px;" class="input-group">
<input type="text" class="woocommerce-Input woocommerce-Input--text input-text form-control" name="username" id="username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" placeholder="Kullanıcı adı veya Eposta" />
</div>

<div style="margin-top:10px;font-size:13px;margin-bottom:12px;" class="input-group">
<input class="woocommerce-Input woocommerce-Input--text input-text form-control" type="password" name="password" id="password" autocomplete="current-password" placeholder="Parolanız" />
</div>



<?php do_action( 'woocommerce_login_form' ); ?>

<p class="form-row">
<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e( 'Remember me', 'woocommerce' ); ?></span>
</label>
<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
<button style="margin-left:15px;" type="submit" class="btn btn-success" name="login" value="<?php esc_attr_e( 'Log in', 'woocommerce' ); ?>"><?php esc_html_e( 'Log in', 'woocommerce' ); ?></button>
</p>
<p class="woocommerce-LostPassword lost_password">
<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'woocommerce' ); ?></a>
</p>

<?php do_action( 'woocommerce_login_form_end' ); ?>

</form>

<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

</div>

</div>

<div style="float:left;" class="col-lg-6">
<div class="beyaz">
<h1>ÜYELİK OLUŞTUR</h1>
<form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action( 'woocommerce_register_form_tag' ); ?> >

<?php do_action( 'woocommerce_register_form_start' ); ?>

<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

<p class="form-row kayitform col-12">
<span class="woocommerce-input-wrapper">
<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" placeholder="Kullanıcı Adı" />
</span>
</p>

<?php endif; ?>

<p class="form-row kayitform col-12">
<span class="woocommerce-input-wrapper">
<input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" placeholder="Eposta Adresi"/>
</span>
</p>

<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

<p class="form-row kayitform col-12">
<span class="woocommerce-input-wrapper">
<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" placeholder="Parolanız" />
</span>
</p>

<?php else : ?>

<p><?php esc_html_e( 'A password will be sent to your email address.', 'woocommerce' ); ?></p>

<?php endif; ?>

<?php do_action( 'woocommerce_register_form' ); ?>

<p class="woocommerce-FormRow form-row">
<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
<button type="submit" style="margin-top:10px;background:#F69100;border:none;" class="btn btn-danger" name="register" value="<?php esc_attr_e( 'Register', 'woocommerce' ); ?>">Ücretsiz Üyelik Oluştur</button>
</p>

<?php do_action( 'woocommerce_register_form_end' ); ?>

</form>

</div>
</div>


<?php endif; ?>

<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
