<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<div class="row">

<div class="col-12 col-lg-12">
<div class="hosgeldin">
Merhaba, 
<?php
      $user_info = get_userdata(get_current_user_id());
      $first_name = $user_info->first_name;
     echo '<b>'; 
	  echo "$first_name $last_name";
	  echo '</b>';
?>
</div>
</div>

<div class="col-lg-3 col-6">
<a href="<?php bloginfo('url'); ?>/odeme/">
<div style="background:#FF8A00;color:#000;" class="panelhizlibuton"><i style="font-size:27px" class="fas fa-shopping-basket"></i> <br> Kasaya Git</div>
</a>
</div>

<div class="col-lg-3 col-6">
<a href="<?php bloginfo('url'); ?>/hesabim/3d-sanal-pos/"><div class="panelhizlibuton"><i style="font-size:27px" class="far fa-credit-card"></i> <br> 3D Sanal Pos</div></a>
</div>

<div class="col-lg-3 col-6">
<a href="<?php bloginfo('url'); ?>/hesabim/kredilerim/"><div class="panelhizlibuton"><i style="font-size:27px" class="fas fa-gift"></i> <br> Puan ve Krediler</div></a>
</div>

<div class="col-lg-3 col-6">
<a href="<?php bloginfo('url'); ?>/hesabim/hesabi-duzenle/"><div class="panelhizlibuton"><i style="font-size:27px" class="far fa-user"></i> <br> Profili Güncelle</div></a>
</div>

<div class="col-lg-3 col-6">
<a href="<?php bloginfo('url'); ?>/sepet/"><div class="panelhizlibuton"><i style="font-size:27px" class="fas fa-shopping-basket"></i> <br> Alışveriş Sepeti</div></a>
</div>

<div class="col-lg-3 col-6">
<a href="<?php bloginfo('url'); ?>/hesabim/siparisler/"><div class="panelhizlibuton"><i style="font-size:27px" class="fas fa-shopping-basket"></i> <br> Tüm Siparişler</div></a>
</div>

<div class="col-lg-3 col-6">
<a href="<?php bloginfo('url'); ?>/hesabim/adres-duzenle/fatura/"><div class="panelhizlibuton"><i style="font-size:27px" class="far fa-file-alt"></i> <br>Fatura Adresi</div></a>
</div>

<div class="col-lg-3 col-6">
<a href="<?php bloginfo('url'); ?>/hesabim/adres-duzenle/gonderim/"><div class="panelhizlibuton"><i style="font-size:27px" class="fas fa-truck"></i> <br>Kargo Adresi</div></a>
</div>

<div class="col-lg-3 col-6">
<a href="<?php bloginfo('url'); ?>/favorilerim/"><div class="panelhizlibuton"><i style="font-size:27px" class="far fa-heart"></i><br>Favorilerim</div></a>
</div>

<div class="col-lg-3 col-6">
<?php echo do_shortcode("[fc id='5' type='popup' font_color='black']<div style='cursor:pointer;' class='panelhizlibuton'><i style='font-size:27px;margin-bottom:5px;' class='fas fa-exchange-alt'></i><br>Ürün İade Talebi</div>[/fc]"); ?>
</div>

<div class="col-lg-3 col-6">
<?php echo do_shortcode("[fc id='6' type='popup' font_color='black']<div style='cursor:pointer;' class='panelhizlibuton'><i style='font-size:27px;margin-bottom:5px;' class='fas fa-smile'></i><br>Müşteri Desteği</div>[/fc]"); ?>
</div>

<div class="col-lg-3 col-6">
<?php echo do_shortcode("[fc id='3' type='popup' font_color='black']<div style='cursor:pointer' class='panelhizlibuton'><i style='font-size:27px;margin-bottom:5' class='far fa-envelope'></i><br>Havale Bildirimi</div>[/fc]"); ?>
</div>

</div>

<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
