<?php
require_once( TEMPLATEPATH."/a/codestar-framework.php" ); 

if (!isset($content_width)){ $content_width = 900; }

if (function_exists('add_theme_support'))
{
add_theme_support('menus');
add_theme_support('post-thumbnails');
add_image_size('large', 700, '', true); 
add_image_size('medium', 250, '', true);
add_image_size('small', 120, '', true);
add_image_size('custom-size', 700, 200, true);
}

function html5blank_nav()
{
wp_nav_menu(
array(
'theme_location'  => 'header-menu',
'menu'            => '',
'container'       => 'div',
'container_class' => 'menu-{menu slug}-container',
'container_id'    => '',
'menu_class'      => '',
'menu_id'         => '',
'echo'            => true,
'fallback_cb'     => 'wp_page_menu',
'before'          => '',
'after'           => '',
'link_before'     => '',
'link_after'      => '',
'items_wrap'      => '%3$s',
'depth'           => 0,
'walker'          => ''
)
);
}


function register_html5_menu(){register_nav_menus(array('header-menu' => __('Üst Menü', 'html5blank')));}
function my_wp_nav_menu_args($args = ''){$args['container'] = false;return $args;}
function my_css_attributes_filter($var){return is_array($var) ? array() : '';}
function remove_category_rel_from_category_list($thelist){return str_replace('rel="category tag"', 'rel="tag"', $thelist);}
function remove_admin_bar(){return false;}
function html5_style_remove($tag){return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);}
function remove_thumbnail_dimensions( $html ){$html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);return $html;}
function html5blankgravatar ($avatar_defaults){$myavatar = get_template_directory_uri() . '/img/gravatar.jpg';$avatar_defaults[$myavatar] = "Custom Gravatar";return $avatar_defaults;}

add_action('init', 'register_html5_menu');
remove_action('wp_head', 'feed_links_extra', 3);
remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'index_rel_link');
remove_action('wp_head', 'parent_post_rel_link', 10, 0);
remove_action('wp_head', 'start_post_rel_link', 10, 0);
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0);
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
remove_action('wp_head', 'rel_canonical');
remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');
remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
remove_action( 'admin_print_styles', 'print_emoji_styles' );

add_filter('avatar_defaults', 'html5blankgravatar');
add_filter('body_class', 'add_slug_to_body_class');
add_filter('wp_nav_menu_args', 'my_wp_nav_menu_args');
add_filter('the_category', 'remove_category_rel_from_category_list');
add_filter('show_admin_bar', 'remove_admin_bar');
add_filter('style_loader_tag', 'html5_style_remove');
add_filter('post_thumbnail_html', 'remove_thumbnail_dimensions', 10);
add_filter('image_send_to_editor', 'remove_thumbnail_dimensions', 10);
add_shortcode('html5_shortcode_demo', 'html5_shortcode_demo');
add_shortcode('html5_shortcode_demo_2', 'html5_shortcode_demo_2');
add_filter('use_block_editor_for_post_type', '__return_false', 100);

function html5_shortcode_demo($atts, $content = null){return '<div class="shortcode-demo">' . do_shortcode($content) . '</div>';}
function html5_shortcode_demo_2($atts, $content = null){return '<h2>' . $content . '</h2>';}

add_filter( 'wp_handle_upload_prefilter', 'dosya_tr_karakter_degistir' );   
function dosya_tr_karakter_degistir( $file ){$bul = array('İ','Ü','Ğ','Ö','Ç','Ş','ş','ç','ö','ğ','ü','ı');$degistir = array('I','U','G','O','C','S','s','c','o','g','u','i');$file['name'] = str_replace($bul,$degistir,$file['name']);return $file;}

function icerik_kisalt($char) {
$content = get_the_content($post->ID);
$content = mb_substr($content,0,$char,"UTF-8");
$bereyibul = array('<br/>','<br />');
$bereyidegistir = array('');
$string1 = get_the_content();
$content = strip_tags($content);
$content = str_replace($bereyibul,$bereyidegistir,$content);
echo $content;
}

function baslik_kisalt($char) {
$title = get_the_title($post->ID);
$title = mb_substr($title,0,$char,"UTF-8");
$bereyibul = array('<br/>','<br />');
$bereyidegistir = array('');
$string1 = get_the_title();
$title = strip_tags($title);
$title = str_replace($bereyibul,$bereyidegistir,$title);
echo $title;
}

// unregister all default WP Widgets
function unregister_default_wp_widgets() {
unregister_widget('WP_Widget_Pages');
unregister_widget('WP_Widget_Calendar');
unregister_widget('WP_Widget_Archives');
unregister_widget('WP_Widget_Links');
unregister_widget('WP_Widget_Meta');
unregister_widget('WP_Widget_Search');
unregister_widget('WP_Widget_Categories');
unregister_widget('WP_Widget_Recent_Posts');
unregister_widget('WP_Widget_Recent_Comments');
unregister_widget('WP_Widget_RSS');
unregister_widget('WP_Widget_Tag_Cloud');
}
add_action('widgets_init', 'unregister_default_wp_widgets', 1);


function shapeSpace_remove_toolbar_nodes($wp_admin_bar) {
$wp_admin_bar->remove_node('wp-logo');
$wp_admin_bar->remove_node('comments');
$wp_admin_bar->remove_node('comments');
$wp_admin_bar->remove_node('new-content');
$wp_admin_bar->remove_node('site-name');
$wp_admin_bar->remove_node('customize');
$wp_admin_bar->remove_node('customize-background');
$wp_admin_bar->remove_node('customize-header');
}

add_action( 'init', 'sozlesme' );
function sozlesme() {
register_post_type( 'sozlesme',
array(
'labels' => array(
'name' => __( 'Sözleşmeler' ),
'singular_name' => __( 'sozlesme' ),
),
'supports' => array( 'title','editor'),
'public' => true,
'menu_icon' => 'dashicons-editor-alignleft',
'has_archive' => true,
)
);
}

add_action('admin_bar_menu', 'shapeSpace_remove_toolbar_nodes', 999);
add_filter('use_block_editor_for_post', '__return_false');
add_filter( 'contextual_help', 'mycontext_remove_help', 999, 3 );  function mycontext_remove_help($old_help, $screen_id, $screen){$screen->remove_help_tabs(); return $old_help;}


add_action( 'after_setup_theme', function() {
add_theme_support( 'woocommerce' );
} );

define( 'WPEX_WOOCOMMERCE_ACTIVE', class_exists( 'WooCommerce' ) );
if ( WPEX_WOOCOMMERCE_ACTIVE ) {}
add_action( 'after_setup_theme', function() {
add_theme_support( 'woocommerce' );
} );

// Ürün Türlerinden Bazılarını Kaldırıyoruz..
function remove_product_types( $types ){
unset( $types['grouped'] );
unset( $types['external'] );

return $types;
}
add_filter( 'product_type_selector', 'remove_product_types' );


// Sipariş Durumlarının Adını Değiştiriyoruz.
add_filter( 'wc_order_statuses', 'ts_rename_order_status_msg', 20, 1 );
function ts_rename_order_status_msg( $order_statuses ) {
$order_statuses['wc-completed'] = _x( 'Tamamlandı', 'Order status', 'woocommerce' );
$order_statuses['wc-processing'] = _x( 'İşleme Alındı', 'Order status', 'woocommerce' );
$order_statuses['wc-on-hold'] = _x( 'İşlem Bekliyor', 'Order status', 'woocommerce' );
$order_statuses['wc-pending'] = _x( 'Ödeme Bekliyor', 'Order status', 'woocommerce' );
return $order_statuses;
}


//+++ Seçeneli Ürünlerdeki Fiyat Aralığını Gizliyoruz..
add_filter( 'woocommerce_variable_sale_price_html', 
'lw_variable_product_price', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 
'lw_variable_product_price', 10, 2 );

function lw_variable_product_price( $v_price, $v_product ) {

// Regular Price
$v_prices = array( $v_product->get_variation_price( 'min', true ), 
                            $v_product->get_variation_price( 'max', true ) );
$v_price = $v_prices[0]!==$v_prices[1] ? sprintf(__('%1$s', 'woocommerce'), 
                       wc_price( $v_prices[0] ) ) : wc_price( $v_prices[0] );

// Sale Price
$v_prices = array( $v_product->get_variation_regular_price( 'min', true ), 
                          $v_product->get_variation_regular_price( 'max', true ) );
sort( $v_prices );
$v_saleprice = $v_prices[0]!==$v_prices[1] ? sprintf(__('%1$s','woocommerce')
                      , wc_price( $v_prices[0] ) ) : wc_price( $v_prices[0] );

if ( $v_price !== $v_saleprice ) {
$v_price = '<del>'.$v_saleprice. '</del> <ins>' . 
                       $v_price . $v_product->get_price_suffix() . '</ins>';
}
return $v_price;
}


// Mağazaya Sidebar Yeteneği Kazandırıyoruz
if ( function_exists('register_sidebar') )
register_sidebar(array(
'before_widget' => '<div class="bilesen">',
'after_widget' => '</div>',
'before_title' => '<div class="bilesenbaslik"><i class="icon-chevron-sign-right"></i> ',
'after_title' => '</div>',
));

remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart');


// İndirim Oranını Gösterir
function custom_product_sale_flash( $output, $post, $product ) {
global $product;
if($product->is_on_sale()) {
if($product->is_type( 'variable' ) )
{
$regular_price = $product->get_variation_regular_price();
$sale_price = $product->get_variation_price();
} else {
$regular_price = $product->get_regular_price();
$sale_price = $product->get_sale_price();
}
$percent_off = (($regular_price - $sale_price) / $regular_price) * 100;
return '<span class="onsale">' . round($percent_off) . '%</span>';
}
}
add_filter( 'woocommerce_sale_flash', 'custom_product_sale_flash', 11, 3 );

// Stok Adedini Gizler
add_filter( 'woocommerce_get_availability', 'wcs_custom_get_availability', 1, 2);
function wcs_custom_get_availability( $availability, $_product ) {

if ( $_product->is_in_stock() ) {
$availability['availability'] = __('Stokta var', 'woocommerce');
}

if ( ! $_product->is_in_stock() ) {
$availability['availability'] = __('Tükendi!', 'woocommerce');
}
return $availability;
}

// Kayıt Ol Formu

function wooc_extra_register_fields() {
?>

<p class="form-row form-row-wide">
<input style="font-size:13px;" type="text" class="input-text" name="billing_first_name" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" placeholder="Ad Soyad"/>
</p>

<p class="form-row form-row-wide">
<input style="font-size:13px;" type="text" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php if ( ! empty( $_POST['billing_phone'] ) ) esc_attr_e( $_POST['billing_phone'] ); ?>"  placeholder="Cep Telefonu"/>
</p>

<p class="form-row form-row-wide">
<select style="font-size:13px;padding:6px;border:1px solid #ddd;border-radius:5px;" class="state_select" name="billing_state" id="reg_billing_state">
<option value="">Şehir Seçiniz&hellip;</option>
<option value="TR01">Adana</option>
<option value="TR02">Adıyaman</option>
<option value="TR03">Afyonkarahisar</option>
<option value="TR04">Ağrı</option>
<option value="TR05">Amasya</option>
<option value="TR06">Ankara</option>
<option value="TR07">Antalya</option>
<option value="TR08">Artvin</option>
<option value="TR09">Aydın</option>
<option value="TR10">Balıkesir</option>
<option value="TR11">Bilecik</option>
<option value="TR12">Bingöl</option>
<option value="TR13">Bitlis</option>
<option value="TR14">Bolu</option>
<option value="TR15">Burdur</option>
<option value="TR16">Bursa</option>
<option value="TR17">Çanakkale</option>
<option value="TR18">Çankırı</option>
<option value="TR19">Çorum</option>
<option value="TR20">Denizli</option>
<option value="TR21">Diyarbakır</option>
<option value="TR22">Edirne</option>
<option value="TR23">Elazığ</option>
<option value="TR24">Erzincan</option>
<option value="TR25">Erzurum</option>
<option value="TR26">Eskişehir</option>
<option value="TR27">Gaziantep</option>
<option value="TR28">Giresun</option>
<option value="TR29">Gümüşhane</option>
<option value="TR30">Hakkâri</option>
<option value="TR31">Hatay</option>
<option value="TR32">Isparta</option>
<option value="TR33">Mersin</option>
<option value="TR34">İstanbul</option>
<option value="TR35">İzmir</option>
<option value="TR36">Kars</option>
<option value="TR37">Kastamonu</option>
<option value="TR38">Kayseri</option>
<option value="TR39">Kırklareli</option>
<option value="TR40">Kırşehir</option>
<option value="TR41">Kocaeli</option>
<option value="TR42">Konya</option>
<option value="TR43">Kütahya</option>
<option value="TR44">Malatya</option>
<option value="TR45">Manisa</option>
<option value="TR46">Kahramanmaraş</option>
<option value="TR47">Mardin</option>
<option value="TR48">Muğla</option>
<option value="TR49">Muş</option>
<option value="TR50">Nevşehir</option>
<option value="TR51">Niğde</option>
<option value="TR52">Ordu</option>
<option value="TR53">Rize</option>
<option value="TR54">Sakarya</option>
<option value="TR55">Samsun</option>
<option value="TR56">Siirt</option>
<option value="TR57">Sinop</option>
<option value="TR58">Sivas</option>
<option value="TR59">Tekirdağ</option>
<option value="TR60">Tokat</option>
<option value="TR61">Trabzon</option>
<option value="TR62">Tunceli</option>
<option value="TR63">Şanlıurfa</option>
<option value="TR64">Uşak</option>
<option value="TR65">Van</option>
<option value="TR66">Yozgat</option>
<option value="TR67">Zonguldak</option>
<option value="TR68">Aksaray</option>
<option value="TR69">Bayburt</option>
<option value="TR70">Karaman</option>
<option value="TR71">Kırıkkale</option>
<option value="TR72">Batman</option>
<option value="TR73">Şırnak</option>
<option value="TR74">Bartın</option>
<option value="TR75">Ardahan</option>
<option value="TR76">Iğdır</option>
<option value="TR77">Yalova</option>
<option value="TR78">Karabük</option>
<option value="TR79">Kilis</option>
<option value="TR80">Osmaniye</option>
<option value="TR81">Düzce</option>
</select>
</p>

<p class="form-row form-row-wide">
<input style="font-size:13px;" type="text" class="input-text" name="billing_city" id="reg_billing_city" value="<?php if ( ! empty( $_POST['billing_city'] ) ) esc_attr_e( $_POST['billing_city'] ); ?>"  placeholder="İlçe Giriniz"/>
</p>

<p class="form-row form-row-wide">
<input style="font-size:13px;" type="text" class="input-text" name="billing_address_1" id="reg_billing_address_1" value="<?php if ( ! empty( $_POST['billing_address_1'] ) ) esc_attr_e( $_POST['billing_address_1'] ); ?>"  placeholder="Adres"/>
</p>


<?php
}

add_action( 'woocommerce_register_form_start', 'wooc_extra_register_fields' );


function wooc_validate_extra_register_fields( $username, $email, $validation_errors ) {
if ( isset( $_POST['billing_first_name'] ) && empty( $_POST['billing_first_name'] ) ) {
$validation_errors->add( 'billing_first_name_error', __( 'Ad ve Soyadınızı Eklemeniz Gerekmektedir.', 'woocommerce' ) );
}


if ( isset( $_POST['billing_phone'] ) && empty( $_POST['billing_phone'] ) ) {
$validation_errors->add( 'billing_phone_error', __( 'Cep Telefonunuzu Eklemeniz Gerekmektedir.', 'woocommerce' ) );
}

if ( isset( $_POST['billing_address_1'] ) && empty( $_POST['billing_address_1'] ) ) {
$validation_errors->add( 'billing_address_1_error', __( 'Adres Eklemeniz Gerekmektedir.', 'woocommerce' ) );
}

if ( isset( $_POST['billing_city'] ) && empty( $_POST['billing_city'] ) ) {
$validation_errors->add( 'billing_city_error', __( 'İlçenizi Belirtmeniz Gerekmektedir.', 'woocommerce' ) );
}

}

add_action( 'woocommerce_register_post', 'wooc_validate_extra_register_fields', 10, 3 );


function wooc_save_extra_register_fields( $customer_id ) {
if ( isset( $_POST['billing_first_name'] ) ) {
update_user_meta( $customer_id, 'first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
update_user_meta( $customer_id, 'billing_first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
}

if ( isset( $_POST['billing_last_name'] ) ) {
update_user_meta( $customer_id, 'last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
update_user_meta( $customer_id, 'billing_last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
}

if ( isset( $_POST['billing_phone'] ) ) {
update_user_meta( $customer_id, 'billing_phone', sanitize_text_field( $_POST['billing_phone'] ) );
}

if ( isset( $_POST['billing_address_1'] ) ) {
update_user_meta( $customer_id, 'billing_address_1', sanitize_text_field( $_POST['billing_address_1'] ) );
}

if ( isset( $_POST['billing_city'] ) ) {
update_user_meta( $customer_id, 'billing_city', sanitize_text_field( $_POST['billing_city'] ) );
}

if ( isset( $_POST['billing_state'] ) ) {
update_user_meta( $customer_id, 'billing_state', sanitize_text_field( $_POST['billing_state'] ) );
}
}

add_action( 'woocommerce_created_customer', 'wooc_save_extra_register_fields' );

// +++ Üyelik Sözleşmesi Onayı Alınıyor..

add_action( 'woocommerce_register_form', 'bbloomer_add_registration_privacy_policy', 11 );

function bbloomer_add_registration_privacy_policy() {
woocommerce_form_field( 'privacy_policy_reg', array(
'type'          => 'checkbox',
'class'         => array('kayitsozlesme'),
'required'      => true,
'label'         => 'Üyelik Sözleşmesini <a href="'.get_bloginfo('url').'/uyelik-sozlesmesi" target="_blank">Okudum, Kabul ediyorum.</a>',
));
}
add_filter( 'woocommerce_registration_errors', 'bbloomer_validate_privacy_registration', 10, 3 );

function bbloomer_validate_privacy_registration( $errors, $username, $email ) {
if ( ! is_checkout() ) {
if ( ! (int) isset( $_POST['privacy_policy_reg'] ) ) {
$errors->add( 'privacy_policy_reg_error', __( 'Lütfen Üyelik Sözleşmesini Onaylayın!', 'woocommerce' ) );
}
}
return $errors;
}

// +++ Fatura ve Kargo Alanlarının İptali
add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );
add_filter( 'woocommerce_billing_fields' , 'custom_override_billing_fields' );
add_filter( 'woocommerce_shipping_fields' , 'custom_override_shipping_fields' );

function custom_override_checkout_fields( $fields ) {
unset($fields['billing']['billing_postcode']);
unset($fields['billing']['billing_last_name']);
unset($fields['billing']['billing_address_2']);	
return $fields;
}

function custom_override_billing_fields( $fields ) {
unset($fields['billing_postcode']);
unset($fields['billing_last_name']);
unset($fields['billing_address_2']);
return $fields;
}

function custom_override_shipping_fields( $fields ) {
unset($fields['shipping_postcode']);
unset($fields['shipping_address_2']);
unset($fields['shipping_last_name']);
return $fields;
}

add_filter( 'woocommerce_checkout_fields' , 'alter_woocommerce_checkout_fields' );
function alter_woocommerce_checkout_fields( $fields ) {
unset($fields['order']['order_comments']);
return $fields;
}

add_filter("woocommerce_checkout_fields", "custom_override_checkout_fields123", 1);
function custom_override_checkout_fields123($fields) {
$fields['billing']['billing_first_name']['priority'] = 3;
$fields['billing']['billing_company']['priority'] = 2;
$fields['billing']['billing_country']['priority'] = 4;
$fields['billing']['billing_state']['priority'] = 5;
$fields['billing']['billing_address_1']['priority'] = 6;
$fields['billing']['billing_email']['priority'] = 10;
$fields['billing']['billing_phone']['priority'] = 11;
return $fields;
}

add_filter( 'woocommerce_default_address_fields', 'custom_override_default_locale_fields' );
function custom_override_default_locale_fields( $fields ) {
$fields['state']['priority'] = 5;
$fields['city']['priority'] = 8;
$fields['address_1']['priority'] = 6;
return $fields;
}

// +++ Siparişi İptal Et Butonu Ekliyoruz..
add_filter( 'woocommerce_valid_order_statuses_for_cancel', 'custom_valid_order_statuses_for_cancel', 10, 2 );
function custom_valid_order_statuses_for_cancel( $statuses, $order ){
    $custom_statuses    = array( 'completed', 'pending', 'processing', 'on-hold', 'failed' );
    $duration = 3;
	
    if( isset($_GET['order_id']))
        $order = wc_get_order( absint( $_GET['order_id'] ) );

    $delay = $duration*24*60*60;
    $date_created_time  = strtotime($order->get_date_created());
    $date_modified_time = strtotime($order->get_date_modified());
    $now = strtotime("now");
    if ( ( $date_created_time + $delay ) >= $now ) return $custom_statuses;
    else return $statuses;
}

// +++ Soyad Alanının Zorunluluğunu Kaldırıyoruz..
add_filter('woocommerce_save_account_details_required_fields', 'ts_hide_last_name');
function ts_hide_last_name($required_fields)
{
unset($required_fields["account_last_name"]);
return $required_fields;
}

// +++ Alışveriş Sepeti Butonu
function my_wc_cart_count() {

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

$count = WC()->cart->cart_contents_count;
?><a class="cart-contents" href="<?php echo WC()->cart->get_cart_url(); ?>" title="Alışveriş Sepetiniz"><?php
if ( $count > 0 ) {
?>
<span class="cart-contents-count"><?php echo esc_html( $count ); ?></span>
<?php
}
?></a><?php
}

}
add_action( 'your_theme_header_top', 'my_wc_cart_count' );

function my_header_add_to_cart_fragment( $fragments ) {

ob_start();
$count = WC()->cart->cart_contents_count;
?><a class="cart-contents" href="<?php echo WC()->cart->get_cart_url(); ?>" title="Alışveriş Sepetiniz"><?php
if ( $count > 0 ) {
?>
<span class="cart-contents-count"><?php echo esc_html( $count ); ?></span>
<?php            
}
?></a><?php

$fragments['a.cart-contents'] = ob_get_clean();

return $fragments;
}
add_filter( 'woocommerce_add_to_cart_fragments', 'my_header_add_to_cart_fragment' );
// +++ Alışveriş Sepeti Butonu Bitti


// +++ Kurumsal ve Bireysel Alışveriş Fonksiyonu
add_filter('woocommerce_checkout_fields', 'tc_vergi_icin_new_checkout_field');
function tc_vergi_icin_new_checkout_field($fields)
{
$fields['billing']['checkbox_trigger'] = array(
'type'      => 'checkbox',
'priority' => 1,
'label'     => __('Kurumsal Fatura', 'woocommerce'),
'class'     => array('kurumsalsecim'),
'clear'     => true
);
$fields['billing']['billing_vergi_dairesi'] = array(
'label'     => __('Vergi Dairesi', 'woocommerce'),
'placeholder'   => _x('Vergi Dairesi', 'placeholder', 'woocommerce'),
'class'     => array('form-row form-row-first'),
'required' => true,
'priority' => 2,
'clear'     => true
);
$fields['billing']['billing_vergi_nosu'] = array(
'label'     => __('Vergi No', 'woocommerce'),
'placeholder'   => _x('Vergi No', 'placeholder', 'woocommerce'),
'class'     => array('form-row form-row-last'),
'required' => true,
'priority' => 2,
'clear'     => true
);
$fields['billing']['shipping_tc'] = array(
'label'     => __('TC Kimlik No', 'woocommerce'),
'placeholder'   => _x('Faturanız İçin kullanılacaktır.', 'placeholder', 'woocommerce'),
'class'     => array('form-row-wide'),
'priority' => 2,
'clear'     => true
);
if (!isset($_POST['checkbox_trigger'])) {
$fields['billing']['shipping_tc']['required'] = true;
$fields['billing']['billing_company']['required'] = false;
$fields['billing']['billing_vergi_dairesi']['required'] = false;
$fields['billing']['billing_vergi_nosu']['required'] = false;
} else {
$fields['billing']['shipping_tc']['required'] = false;
$fields['billing']['billing_company']['required'] = true;
$fields['billing']['billing_vergi_dairesi']['required'] = true;
$fields['billing']['billing_vergi_nosu']['required'] = true;
}
return $fields;
}


function isTcKimlik($tc)
{
// Array içindeki denemeler tc kriterine uyduğu için hariç tuttuk.
$exclude = array('11111111110', '22222222220', '33333333330', '44444444440', '55555555550', '66666666660', '7777777770', '88888888880', '99999999990'); //Bunlar aşağıdaki fonksiyonu yanıltan numaralar dilerseniz kaldırabilirsiniz satırı.
if (in_array($tc, $exclude)) {
return false;
}
if (strlen($tc) < 11) {
return false;
}
if ($tc[0] == '0') {
return false;
}
$plus = ($tc[0] + $tc[2] + $tc[4] + $tc[6] + $tc[8]) * 7;
$minus = $plus - ($tc[1] + $tc[3] + $tc[5] + $tc[7]);
$mod = $minus % 10;
if ($mod != $tc[9]) {
return false;
}
$all = 0;
for ($i = 0; $i < 10; $i++) {
$all += $tc[$i];
}
if ($all % 10 != $tc[10]) {
return false;
}
return true;
}

add_action('woocommerce_checkout_process', 'tc_numara_dogrula');
function tc_numara_dogrula()
{
$tcno = $_POST['shipping_tc'];
if (!empty($tcno)) {
if (!is_numeric($tcno) && !isset($_POST['checkbox_trigger'])) {
wc_add_notice(__('T.C alanına lütfen sayısal bir değer girin yada siparişiniz 5.000,00 TL den küçük ise boş bırakın.'), 'error');
} else if (!empty($tcno) && !isset($_POST['checkbox_trigger'])) {
if (!isTcKimlik($tcno))
wc_add_notice(__('Lütfen doğru bir TC kimlik no girin yada siparişiniz 5.000,00 TL den küçük ise boş bırakın.'), 'error');
}
}
}


//Adminin Sipariş Detayında Fatura Bilgilerinde TC No ve Vergi Dairesi Görebilmesi İçin
add_action('woocommerce_admin_order_data_after_billing_address', 'vergi_no_dairesi', 10, 1);
function vergi_no_dairesi($order)
{
if (get_post_meta($order->get_id(), '_billing_company', true) == null) {
if (get_post_meta($order->get_id(), '_shipping_tc', true) == null) {
echo '<p><strong>' . __('TC Kimlik No') . ':</strong> ' . 11111111111 . '</p>';
} else {
echo '<p><strong>' . __('TC Kimlik No') . ':</strong> ' . get_post_meta($order->get_id(), '_shipping_tc', true) . '</p>';
}
} else {
echo '<p><strong>' . __('Vergi Dairesi') . ':</strong> ' . $vergiDaire = get_post_meta($order->get_id(), '_billing_vergi_dairesi', true) . '</p>';
echo '<p><strong>' . __('Vergi No') . ':</strong> ' . $vergiNum = get_post_meta($order->get_id(), '_billing_vergi_nosu', true) . '</p>';
}
}
//Koşullara göre alanları göstermek için gerekli javascript kodları
add_action('woocommerce_after_checkout_form', 'kosullu_alan_goster', 6);
function kosullu_alan_goster()
{
?>
<script type="text/javascript">
jQuery('#billing_vergi_dairesi').hide();
jQuery('#billing_vergi_nosu').hide();
jQuery('#billing_company').hide();
jQuery('#billing_vergi_dairesi_field  > label').hide();
jQuery('#billing_vergi_nosu_field  > label').hide();
jQuery('#billing_company_field  > label').hide();
jQuery("#billing_company_field > label > span").remove();
jQuery("#billing_company_field > label").append("<abbr class='required' title='gerekli'>*</abbr>");
jQuery("#billing_vergi_dairesi_field > label").append("<abbr class='required' title='gerekli'>*</abbr>");
jQuery("#billing_vergi_nosu_field > label").append("<abbr class='required' title='gerekli'>*</abbr>");
jQuery('input#checkbox_trigger').change(function() {
if (this.checked) {
jQuery('#shipping_tc_field  > label').hide();
jQuery('#shipping_tc').hide();
jQuery('#billing_vergi_dairesi').fadeIn();
jQuery('#billing_company').fadeIn();
jQuery('#billing_vergi_nosu').fadeIn();
jQuery('#billing_vergi_dairesi_field  > label').fadeIn();
jQuery('#billing_vergi_nosu_field  > label').fadeIn();
jQuery('#billing_vergi_dairesi_field > label > span').remove();
jQuery('#billing_vergi_nosu_field > label > span').remove();
jQuery('#billing_vergi_dairesi_field').addClass('validate-required');
jQuery('#billing_company_field  > label').fadeIn();
jQuery('#billing_company_field').addClass('validate-required');
jQuery('#billing_vergi_nosu_field').addClass('validate-required');
} else {
jQuery('#billing_vergi_dairesi').fadeOut();
jQuery('#billing_vergi_dairesi_field > label').fadeOut();
jQuery('#billing_vergi_dairesi').fadeOut();
jQuery('#billing_vergi_nosu').fadeOut();
jQuery('#billing_vergi_dairesi_field > label').fadeOut();
jQuery('#billing_vergi_nosu_field  > label').fadeOut();
jQuery('#shipping_tc_field  > label').fadeIn();
jQuery('#shipping_tc').fadeIn();
jQuery('#billing_company').fadeOut();
jQuery('#billing_company_field  > label').fadeOut();
}
});
</script>
<?php
}

add_filter( 'woocommerce_product_tabs', 'misha_remove_description_tab', 11 );

function misha_remove_description_tab( $tabs ) {

unset( $tabs['description'] );
unset( $tabs['additional_information'] );
return $tabs;

}
?>
