<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( empty( $my_comments ) || ! is_array( $my_comments ) || empty( $settings ) ) {
	return;
}
$prefix       = $is_shortcode ? 'shortcode_' : '';
$prefix_class = $is_shortcode ? 'shortcode-' : '';
global $product;
$return_product = $product;
$grid_class     = '';
$grid_tag_html  = ! empty( $parent_tag_html ) && in_array( $parent_tag_html, [ 'ul', 'ol' ] ) ? 'li' : 'div';
if ( isset( $cols ) ) {
	$grid_class = array(
		$prefix_class . 'wcpr-masonry-style',
		$prefix_class . 'wcpr-grid',
		$prefix_class . 'wcpr-masonry-' . $cols . '-col',
		$prefix_class . 'wcpr-masonry-popup-' . $masonry_popup,
	);
	if ( $enable_box_shadow ) {
		$grid_class[] = $prefix_class . 'wcpr-enable-box-shadow';
	}
	if ( ! empty( $loadmore_button ) && in_array( $loadmore_button, [ 'on', '1' ] ) ) {
		$grid_class[] = 'wcpr-grid-loadmore';
	}
}
$countries           = VI_WOOCOMMERCE_PHOTO_REVIEWS_Admin_Import_Ali::get_countries();
$show_review_country = $settings->get_params( 'show_review_country' );
$review_title_enable = $settings->get_params( 'review_title_enable' );
$auto_play_video = $settings->get_params( 'auto_play_video' );
$updated_cmt_meta    = get_option( 'wcpr_comment_meta_updated' );
$is_wpml_active      = is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' );
$user                = wp_get_current_user();
if ( $user ) {
	if ( ! empty( $user->ID ) ) {
		$vote_info = $user->ID;
		if ( $settings->get_params( 'review_edit_enable' ) ) {
			$user_id = $vote_info;
		}
	} else {
		$vote_info = VI_WOOCOMMERCE_PHOTO_REVIEWS_DATA::get_the_user_ip();
	}
} else {
	$vote_info = VI_WOOCOMMERCE_PHOTO_REVIEWS_DATA::get_the_user_ip();
}
$full_image_size    = $settings->get_params( 'photo', 'full_image_size' );
$caption_enable     = $settings->get_params( 'image_caption_enable' );
$product_gallery_enable     = $settings->get_params( 'photo', 'product_gallery_enable' );
$image_title        = $masonry_popup === 'off' ? '' : esc_attr__( 'Click to view full screen', 'woocommerce-photo-reviews' );
$max_content_length = intval( wp_is_mobile() ? ( $settings->get_params( 'photo', 'max_content_length_mobile' ) ?? $settings->get_params( 'photo', 'max_content_length' ) ) : $settings->get_params( 'photo', 'max_content_length' ) );

// Add UIkit CSS and JS
wp_enqueue_style('uikit', 'https://cdn.jsdelivr.net/npm/uikit@3.16.19/dist/css/uikit.min.css');
wp_enqueue_script('uikit', 'https://cdn.jsdelivr.net/npm/uikit@3.16.19/dist/js/uikit.min.js', array(), '3.16.19', true);
wp_enqueue_script('uikit-icons', 'https://cdn.jsdelivr.net/npm/uikit@3.16.19/dist/js/uikit-icons.min.js', array('uikit'), '3.16.19', true);

// Custom CSS for modern design
?>
<style>

.review-item .uk-grid + .uk-grid-medium {
	margin-top: 0 !important;
}

.product-stars {
	margin-right: 15px;
}

.star {
	margin-right: 2px;
}

.star.filled path {
	fill: #FFD700;
}

.star:not(.filled) path {
	fill: #E0E0E0;
}

.author-name {
	font-weight: 600;
	color: #333;
}

.review-text {
	margin-top: 20px;
}

.review-text h3 {
	margin-bottom: 10px;
	color: #222;
	font-size: 18px;
}

.review-text p {
	color: #666;
	line-height: 1.6;
	margin: 0;
}

.review-images img {
	border-radius: 8px;
	width: 100%;
	height: auto;
	transition: transform 0.3s ease;
}

.review-images a {
	display: block;
	margin: 5px;
	border-radius: 8px;
	overflow: hidden;
}

.review-images img:hover {
	transform: scale(1.05);
}

.wcpr-load-more-wrapper {
	text-align: center;
	margin: 30px 0;
}

.wcpr-load-more-button {
	background: #1e87f0;
	color: white !important;
	padding: 10px 30px;
	border-radius: 5px;
	transition: all 0.3s ease;
	cursor: pointer;
	text-decoration: none !important;
}

.wcpr-load-more-button:hover {
	background: #0f7ae5;
	transform: translateY(-2px);
	box-shadow: 0 2px 10px rgba(30,135,240,0.2);
}

.wcpr-load-more-button.loading {
	opacity: 0.7;
	cursor: wait;
}
.align-items-center {
	align-items: center !important;
}
.shortcode-wcpr-filter-container .shortcode-wcpr-filter-button {
	margin: 0 !important;
}
</style>

<?php
if ( $grid_class ) {
	printf( '<%s class="%s" data-wcpr_columns="%s">', $grid_tag_html, esc_attr( trim( implode( ' ', $grid_class ) ) ), esc_attr( $cols ?? '3' ) );
}

// Initialize variables for load more functionality
$reviews_per_page = 5;
$total_reviews = count($my_comments);
$total_pages = ceil($total_reviews / $reviews_per_page);
$current_page = 1;

// Slice the reviews array for initial load
$displayed_reviews = array_slice($my_comments, 0, $reviews_per_page);

echo '<div class="wcpr-reviews-container" data-total-pages="' . esc_attr($total_pages) . '" data-current-page="1">';

foreach ( $displayed_reviews as $comment ) {
	if ( $comment->comment_parent ) {
		continue;
	}
	
	$rating = intval( get_comment_meta( $comment->comment_ID, 'rating', true ) );
	$review_title = get_comment_meta( $comment->comment_ID, 'wcpr_review_title', true );
	$img_post_ids = get_comment_meta( $comment->comment_ID, 'reviews-images', true );
	?>
	<div class="review-item" id="comment-<?php echo esc_attr( $comment->comment_ID ); ?>">
		<div class="uk-grid uk-grid-small uk-items-center align-items-center">
			<div class="product-stars">
					<?php
				for ( $i = 1; $i <= 5; $i++ ) {
					$star_class = $i <= $rating ? 'filled' : '';
					?>
					<span uk-icon="icn-star-2" class="star <?php echo esc_attr( $star_class ); ?> uk-icon">
						<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 23 22" width="23" height="22">
							<path d="m11.5 0 2.694 8.291h8.719l-7.053 5.125 2.693 8.292-7.053-5.124-7.053 5.124 2.693-8.291L.087 8.291h8.719L11.5 0Z"></path>
						</svg>
					</span>
				<?php
				}
				?>
            </div>
			<div class="author-name"><?php comment_author( $comment ); ?></div>
		</div>

		<div class="uk-grid-medium uk-items-center uk-grid" uk-grid>
			<div class="uk-width-8-12@m">
				<div class="review-text">
					<?php if ( $review_title ): ?>
						<h3><?php echo esc_html( $review_title ); ?></h3>
					<?php endif; ?>
					<?php echo wpautop( $comment->comment_content ); ?>
                </div>
                        </div>

			<?php if ( is_array( $img_post_ids ) && !empty( $img_post_ids ) ): ?>
			<div class="uk-width-4-12@m">
				<div class="review-images">
					<div class="uk-grid uk-flex-right@m uk-child-width-1-6@xl uk-child-width-1-5@l uk-child-width-1-4 uk-grid-xsmall uk-grid-match" uk-lightbox>
						<?php
						foreach ( $img_post_ids as $img_post_id ) {
							if ( ! villatheme_is_url( $img_post_id ) ) {
								$image_url = wp_get_attachment_image_url( $img_post_id, 'large' );
								$thumb_url = wp_get_attachment_image_url( $img_post_id, 'thumbnail' );
								if ( $image_url && $thumb_url ) {
									?>
									<a href="<?php echo esc_url( $image_url ); ?>">
										<img src="<?php echo esc_url( $thumb_url ); ?>" alt="<?php comment_author( $comment ); ?>">
									</a>
							<?php
								}
							}
						}
						?>
                    </div>
                    </div>
                </div>
			<?php endif; ?>
                            </div>
                        </div>
						<?php
					}

echo '</div>';

// Add load more button if there are more reviews
if ( $total_reviews > $reviews_per_page ): ?>
	<div class="wcpr-load-more-wrapper">
		<button class="wcpr-load-more-button uk-button uk-button-primary" data-loading-text="Loading...">
			<span uk-spinner="ratio: 0.8" class="uk-margin-small-right uk-hidden"></span>
			<?php esc_html_e('Daha Fazla Yorum Gör', 'leanfit'); ?>
		</button>
                </div>


<?php endif; ?>

<script>
// Add smooth scroll behavior
document.addEventListener('DOMContentLoaded', function() {
	UIkit.scroll('.wcpr-modern-review', {
		duration: 500,
		offset: 100
	});
});
</script>
