<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class Paytr_Gateway_Blocks extends AbstractPaymentMethodType {

    protected $name = 'paytr_payment_gateway';

    private array $gateways;

    public function initialize()
    {
        $this->settings = [
            'iframe' => get_option('woocommerce_paytr_payment_gateway_settings', []),
            'eft' => get_option('woocommerce_paytr_payment_gateway_eft_settings', [])
        ];

        // Varsayılan değerler tanımla
        $default_iframe_settings = [
            'title' => 'PayTR Sanal POS',
            'description' => 'Güvenli ödeme altyapısı',
            'enabled' => 'no',
            'logo' => 'no'
        ];

        // Iframe ayarlarını varsayılan değerlerle birleştir
        $this->settings['iframe'] = wp_parse_args($this->settings['iframe'], $default_iframe_settings);

        $this->gateways['paytr_payment_gateway'] = [
            'title' => $this->settings['iframe']['title'] ?? $default_iframe_settings['title'],
            'description' => $this->settings['iframe']['description'] ?? $default_iframe_settings['description'],
            'enabled' => $this->settings['iframe']['enabled'] ?? $default_iframe_settings['enabled'],
            'icon' => ($this->settings['iframe']['logo'] ?? $default_iframe_settings['logo']) === 'yes'
                ? plugin_dir_url(__DIR__) . '/' . plugin_basename(__DIR__) . '/assets/img/logo.svg'
                : null
        ];

        // EFT ayarları varsa ve etkinse ekle
        if (!empty($this->settings['eft']) && isset($this->settings['eft']['enabled']) && $this->settings['eft']['enabled'] === 'yes') {
            $default_eft_settings = [
                'title' => 'PayTR EFT/Havale',
                'description' => 'EFT/Havale ile ödeme',
                'enabled' => 'no',
                'logo' => 'no'
            ];

            // EFT ayarlarını varsayılan değerlerle birleştir
            $this->settings['eft'] = wp_parse_args($this->settings['eft'], $default_eft_settings);

            $this->gateways['paytr_payment_gateway_eft'] = [
                'title' => $this->settings['eft']['title'] ?? $default_eft_settings['title'],
                'description' => $this->settings['eft']['description'] ?? $default_eft_settings['description'],
                'enabled' => $this->settings['eft']['enabled'] ?? $default_eft_settings['enabled'],
                'icon' => ($this->settings['eft']['logo'] ?? $default_eft_settings['logo']) === 'yes'
                    ? plugin_dir_url(__DIR__) . '/' . plugin_basename(__DIR__) . '/assets/img/logo.svg'
                    : null
            ];
        }
    }

    public function is_active()
    {
        return isset($this->settings['iframe']['enabled']) && $this->settings['iframe']['enabled'] === 'yes';
    }


    public function get_payment_method_script_handles()
    {
        wp_register_script(
            'paytr-payment-gateway-blocks-integration',
            plugin_dir_url(__FILE__) . 'checkout.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
                'wp-i18n',
            ],
            null,
            true
        );
        return [ 'paytr-payment-gateway-blocks-integration' ];
    }

    public function get_payment_method_data()
    {
        $data = [];
        foreach ($this->gateways as $key => $gateway) {
            if($gateway['enabled'] === 'yes') {
                $data[$key] = [
                    'title' => $gateway['title'],
                    'description' => $gateway['description'],
                    'icon'         => $gateway['icon'],
                ];
            }
        }
        return $data;
    }
}
