
var mediaFrame = function (id) {
    let mediaFrame;

    if (mediaFrame) {
        mediaFrame.open();
        return;
    }

    mediaFrame = wp.media({
        title: 'Medya Seçin',
        button: {
            text: 'Medya Seç'
        },
        multiple: false
    });

    mediaFrame.on('select', function() {
        const selectedAttachment = mediaFrame.state().get('selection').first().toJSON();
        const fileUrl = selectedAttachment.url;
        const fileId = selectedAttachment.id;

        const siteUrl = window.location.origin;
        const relativeUrl = fileUrl.replace(siteUrl, '');

        document.getElementById(id).value = relativeUrl;
    });

    mediaFrame.open();
}
