<?php
if (!defined('ABSPATH')) {
    exit; // Güvenlik önlemi
}

// Düzenleme modunda mı?
$block_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$block = null;

if ($block_id) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'blocks';
    $block = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $block_id));
}

$languages = get_available_languages();

?>

<!--<script src="http://wp1.test/wp-content/plugins/dn-blocks/scripts/font-awesome/js/fontawesome.js" id="fontawesome-js"></script>-->
<!--<link rel='stylesheet' href='http://wp1.test/wp-content/plugins/dn-blocks/scripts/font-awesome/css/fontawesome.css' media='all' />-->

<link rel='stylesheet' id='jquery-ui-css-css' href='https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css?ver=6.7.1' media='all' />
<link rel='stylesheet' id='bootstrap-css-css' href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css?ver=5.3.2' media='all' />
<link rel='stylesheet' id='iconpicker-css' href='/wp-content/plugins/dn-blocks/scripts/menu-editor/css/bootstrap-iconpicker.min.css?ver=6.7.1' media='all' />

<style>
    .btn, select { border-radius: 0 !important; }
    select, input, textarea { min-height: 35px !important; border-color: #e2e2e2 !important; }
    .w-full { width: 100% !important; }
</style>

<div class="wrap">

    <div class="d-flex justify-content-between mb-3">
        <h1><?php echo $block ? 'Edit Block ('.esc_attr($block->name ?? '').')' : 'New Block'; ?></h1>
    </div>

    <div class="panel panel-default">

        <div class="panel-heading">
            <div class="row">
                <div class="col-md-6">
                    <h3 class="panel-title"><div data-code="f464" class="dashicons dashicons-edit"></div></h3>
                </div>

                <div class="col-md-6 text-end">
                    <button type="submit" form="form-filter" data-toggle="tooltip" title="" class="btn btn-success" data-original-title="Save Block">
                        <i class="fa fa-save"></i> Save Block
                    </button>
                </div>
            </div>
        </div>
        <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" enctype="multipart/form-data" id="form-filter" class="form-horizontal">
            <div class="panel-body">

                <input type="hidden" name="action" value="dn_save_block">
                <input type="hidden" name="block_id" value="<?php echo esc_attr($block_id); ?>">
                <?php wp_nonce_field('dn_save_block_nonce', 'dn_save_block_nonce_field'); ?>

                <fieldset>
                    <div class="form-group row required">
                        <label class="col-sm-2 control-label" for="input-name">Block Name</label>
                        <div class="col-sm-9">
                            <input type="text" name="name" value="<?= esc_attr($block->name ?? ''); ?>" id="input-name" class="form-control">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-title">Title</label>
                        <div class="col-sm-9">
                            <input type="text" name="title" value="<?= esc_attr($block->title ?? ''); ?>" id="input-title" class="form-control">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-subtitle">Subtitle</label>
                        <div class="col-sm-9">
                            <input type="text" name="subtitle" value="<?= esc_attr($block->subtitle ?? ''); ?>" id="input-subtitle" class="form-control">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-description">Description</label>
                        <div class="col-sm-9">
                            <textarea name="description" id="input-description" rows="5" class="form-control"><?= stripslashes(esc_textarea($block->description ?? '')); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-description_2">Description 2</label>
                        <div class="col-sm-9">
                            <textarea name="description_2" id="input-description_2" rows="5" class="form-control"><?= stripslashes(esc_textarea($block->description_2 ?? '')); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group row required">
                        <label class="col-sm-2 control-label" for="input-language_id">Language</label>
                        <div class="col-sm-9">
                            <select name="language_id" id="input-language_id" class="form-control">

                                <?php
                                foreach ($languages as $language) {
                                    $locale = explode('_', $language)[0];
                                    $language_name = get_locale_name($locale);

                                    echo "<option value='$language' ".selected($block->language_id ?? '', $language).">$language_name</option>";
                                }
                                ?>

                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-view">Block Type</label>
                        <div class="col-sm-9">
                            <select name="block_type" id="input-view" class="form-control" required>
                                <?php
                                foreach (block_types() as $k => $v) {
                                    echo "<option value='$k' ".selected($block->block_type ?? '', $k).">$v</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-button_link">Button Link</label>
                        <div class="col-sm-9">
                            <input type="text" name="button_link" value="<?= esc_attr($block->button_link ?? ''); ?>" id="input-button-link" class="form-control">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-button_link">Button Text</label>
                        <div class="col-sm-9">
                            <input type="text" name="button_text" value="<?= esc_attr($block->button_text ?? ''); ?>" id="input-button-text" class="form-control">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-status">Status</label>
                        <div class="col-sm-9">
                            <select name="status" id="input-status" class="form-control">
                                <option value="1" <?php selected($block->status ?? '', '1'); ?>>Active</option>
                                <option value="0" <?php selected($block->status ?? '', '0'); ?>>Passive</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-image">Image</label>
                        <div class="col-sm-9">
                            <div class="input-group">
                                <input type="text" name="image" id="input-image" value="<?= esc_attr($block->image ?? ''); ?>" class="form-control">
                                <span class="input-group-btn">
                                    <button type="button" onclick="mediaFrame('input-image')" class="btn btn-primary">
                                        <i data-code="f464" class="dashicons dashicons-edit"></i>
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 control-label" for="input-mobile-image">Mobile Image</label>
                        <div class="col-sm-9">
                            <div class="input-group">
                                <input type="text" name="mobile_image" id="input-mobile-image" value="<?= esc_attr($block->mobile_image ?? ''); ?>" class="form-control">
                                <span class="input-group-btn">
                                    <button type="button" onclick="mediaFrame('input-mobile-image')" class="btn btn-primary">
                                        <i data-code="f464" class="dashicons dashicons-edit"></i>
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <div class="form-group row d-none">
                    <div class="col-sm-12">
                        <textarea id="data" name="data" class="form-control"><?= esc_attr($block->data ?? ''); ?></textarea>
                    </div>
                </div>
            </div>

            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-6">
                        <button type="button" class="btn btn-primary modal-show"><i class="fa fa-plus"></i> Content Add</button>
                    </div>
                </div>
            </div>
        </form>

    </div>
</div>

<div class="py-5 pe-md-4">
    <ul id="myEditor" class="sortableLists list-group"></ul>
</div>

<!-- Modal -->
<div class="modal fade" id="dnModal" aria-labelledby="dnModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="dnModalLabel">New Content Create</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="frmEdit">
                    <fieldset>
                        <div class="form-group" style="padding-top: 0">
                            <label class="control-label">Title</label>
                            <input type="text" class="form-control item-menu" name="text" id="text">
                        </div>

                        <div class="form-group">
                            <label class="control-label">Subtitle</label>
                            <input type="text" class="form-control item-menu" name="text2" id="text2">
                        </div>

                        <div class="form-group">
                            <label class="control-label">Description</label>
                            <textarea class="form-control item-menu" name="text3" id="text3"></textarea>
                        </div>

                        
                        <!-- Yeni alanlar başlangıcı -->
                        <div class="form-group">
                            <div class="row">
                                <div class="col-12 col-sm-6">
                                    <label class="control-label">Malzemeler</label>
                                    <textarea class="form-control item-menu" name="ingredients" id="ingredients" rows="5" 
                                            placeholder="Her malzemeyi yeni satıra yazın:&#10;- 1 su bardağı süt&#10;- 2 yemek kaşığı şeker"></textarea>
                                </div>
                                <div class="col-12 col-sm-6">
                                    <label class="control-label">Hazırlanışı</label>
                                    <textarea class="form-control item-menu" name="instructions" id="instructions" rows="5"
                                            placeholder="Hazırlama adımlarını yazın:&#10;1. Önce süt ve şekeri karıştırın&#10;2. Diğer malzemeleri ekleyin"></textarea>
                                </div>
                            </div>
                        </div>
                        <!-- Yeni alanlar sonu -->

                        <div class="form-group">
                            <div class="row">
                                <div class="col-12 col-sm-6">
                                    <label class="control-label">Content Class</label>
                                    <input type="text" class="form-control item-menu" name="banner_class" id="banner_class">
                                </div>

                                <div class="col-12 col-sm-6">
                                    <label class="control-label">
                                        YouTube Video Id
                                        <span class="woocommerce-help-tip" tabindex="0" aria-label="<strong>Video Id <br>Aşağıdaki modüller ile çalışıyor</strong> <br> - Story Slideshow"></span>
                                    </label>
                                    <input type="text" class="form-control item-menu" name="video_id" id="video_id" placeholder="YouTube Video Id">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-12 col-sm-4">
                                    <label class="control-label">Button Title</label>
                                    <input type="text" class="form-control item-menu" name="sub_text" id="sub_text">
                                </div>

                                <div class="col-12 col-sm-5">
                                    <label class="control-label">Button Url</label>
                                    <input type="text" class="form-control item-menu" name="href" id="href" autocomplete="off">
                                </div>

                                <div class="col-12 col-sm-3">
                                    <label class="control-label">Target</label>
                                    <select name="target" id="target" class="form-control item-menu">
                                        <option value="_self">Current Tab</option>
                                        <option value="_blank">New Tab</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset class="row">
                        <div class="form-group col-sm-6">
                            <label class="control-label">Image</label>
                            <div class="input-group">
                                <input type="text" name="image" id="image" value="" class="form-control item-menu">
                                <span class="input-group-btn">
                                    <button type="button" onclick="mediaFrame('image')" class="btn btn-primary"><i data-code="f464" class="dashicons dashicons-edit"></i></button>
                                </span>
                            </div>
                        </div>

                        <div class="form-group col-sm-6">
                            <label class="control-label">Mobile Image (Optional)</label>
                            <div class="input-group">
                                <input type="text" name="mobile_image" id="mobile_image" value="" class="form-control item-menu">
                                <span class="input-group-btn">
                                    <button type="button" onclick="mediaFrame('mobile_image')" class="btn btn-primary"><i data-code="f464" class="dashicons dashicons-edit"></i></button>
                                </span>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <div class="form-group">
                            <label class="control-label">Product</label>
                            <div>
                                <select class="form-control item-menu w-full" name="selected_product" id="selected_product">
                                    <option value=""></option>
                                    <?php
                                    foreach (get_all_products_for_select() as $product) {
                                        $product_id = $product->ID;
                                        $product_title = get_the_title($product_id);
                                        echo '<option value="'.$product_id.'">'.$product_title.'</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <div class="form-group">
                            <label class="control-label">Recipe Images</label>
                            <div class="recipe-images-container">
                                <div class="recipe-image-list" id="recipe-image-list">
                                    <!-- Existing images will be displayed here -->
                                </div>
                                <div class="input-group">
                                    <input type="hidden" name="recipe_images" id="recipe_images" class="form-control item-menu" value="">
                                    <button type="button" onclick="recipeMediaFrame()" class="btn btn-primary w-100">
                                        <i data-code="f464" class="dashicons dashicons-edit"></i> Add Images
                                    </button>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer d-flex justify-content-between">
                <button type="button" id="btnUpdate" class="btn btn-info" disabled="disabled">Update</button>
                <button type="button" id="btnAdd" class="btn btn-success">Create</button>
            </div>
        </div>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.7.1.js"></script>
<script src="/wp-content/plugins/dn-blocks/scripts/menu-editor/js/bootstrap-iconpicker.min.js?ver=6.7.1" id="iconpicker-js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js?ver=5.3.2" id="bootstrap-js-js"></script>
<script src="/wp-content/plugins/dn-blocks/scripts/menu-editor/jquery-menu-editor.js?ver=6.7.1" id="jquery-menu-editor-js-js"></script>

<!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/davicotico/Menu-Editor@1.1.0/dist/styles.min.css">-->
<!--<script src="https://cdn.jsdelivr.net/gh/davicotico/Menu-Editor@1.1.0/dist/menu-editor.min.js"></script>-->
<script>

    <?php
        $block_data = "[]";

        if(isset($block->data) && $block->data)
            $block_data = $block->data;
    ?>


    const editor_data = JSON.parse("<?= $block_data; ?>");

    var sortableListOptions = {
        placeholderCss: {'background-color': "#cccccc"}
    };

    var editor = new MenuEditor('myEditor', {
        textData: $("#data"),
        listOptions: sortableListOptions
    });

    editor.setData(editor_data);

    editor.setForm($('#frmEdit'));

    editor.setUpdateButton($('#btnUpdate'));

    var myModal = new bootstrap.Modal(document.getElementById('dnModal'));

    $(document).on('click', '.btnEdit', function (e) {
        $('#dnModalLabel').html('Content Update');
        $('#dnModal').modal("show");
    });

    $(document).on('click', '.modal-show', function (e) {
        $('#dnModalLabel').html('Content Add');
        editor.resetForm(editor.getForm());
        $('#dnModal').modal("show");
    });

    $("#btnUpdate").click(function () {
        editor.update();
        myModal.hide();
    });

    $('#btnAdd').click(function () {
        editor.add();
        myModal.hide();
    });
</script>

<script>
    jQuery(document).ready(function($) {
        function fetchProducts(query = '') {
            $.ajax({
                url: ajaxurl,
                method: 'GET',
                data: {
                    action: 'fetch_products',
                    query: query
                },
                success: function(response) {
                    $('#product-dropdown').html('');
                    if (response.data.data.length > 0) {
                        response.data.data.forEach(function(product) {
                            $('#product-dropdown').append(
                                `<li data-value="${product.id}"><a href="#">${product.title}</a></li>`
                            );
                        });
                    } else {
                        $('#product-dropdown').html('<li>No products found.</li>');
                    }
                }
            });
        }

        fetchProducts();

        $('#input-product').on('input', function() {
            var query = $(this).val();
            if(query.length > 0) {
                $('#product-dropdown').show();
            } else {
                $('#product-dropdown').hide();
            }
            fetchProducts(query);
        });

        $('#product-dropdown').on('click', 'li a', function(e) {
            e.preventDefault();
            var productName = $(this).text();
            var productValue = $(this).parent().data('value');
            $('#selected_product').val(productValue);
            $('#selectedProduct').html('<i class="fa fa-minus-circle"></i> ' + productName);
            $('#product-dropdown').hide();
        });

        $('[data-bs-toggle="tooltip"]').tooltip();

        $('#input-product').on('focus', function() {
            $('#product-dropdown').show();
        });

        $(document).on('click', function(e) {
            if (!$(e.target).closest('#input-product, #product-dropdown').length) {
                $('#product-dropdown').hide();
            }
        });
    });
</script>

<script>
function mediaFrame(inputId) {
    var frame = wp.media({
        title: 'Select or Upload Media',
        button: {
            text: 'Use this media'
        },
        multiple: false
    });

    frame.on('select', function() {
        var attachment = frame.state().get('selection').first().toJSON();
        document.getElementById(inputId).value = attachment.url;
    });

    frame.open();
}
</script>

<script>
function recipeMediaFrame() {
    var frame = wp.media({
        title: 'Select Recipe Images',
        button: {
            text: 'Add to Recipe'
        },
        multiple: true
    });

    frame.on('select', function() {
        var attachments = frame.state().get('selection').map(function(attachment) {
            return attachment.toJSON();
        });
        
        var imageList = document.getElementById('recipe-image-list');
        var imageInput = document.getElementById('recipe_images');
        var currentImages = [];
        
        try {
            currentImages = imageInput.value ? JSON.parse(imageInput.value) : [];
        } catch(e) {
            currentImages = [];
        }
        
        // Clear existing previews
        imageList.innerHTML = '';
        
        attachments.forEach(function(attachment) {
            currentImages.push({
                id: attachment.id,
                url: attachment.url
            });
            
            // Add image preview
            var imagePreview = document.createElement('div');
            imagePreview.className = 'recipe-image-preview';
            imagePreview.innerHTML = `
                <img src="${attachment.url}" alt="">
                <button type="button" class="remove-image" data-id="${attachment.id}">×</button>
            `;
            imageList.appendChild(imagePreview);
        });
        
        imageInput.value = JSON.stringify(currentImages);
    });

    frame.open();
}

// Remove image handler
$(document).on('click', '.remove-image', function(e) {
    var imageId = $(this).data('id');
    var imageInput = $('#recipe_images');
    var currentImages = [];
    
    try {
        currentImages = JSON.parse(imageInput.val());
    } catch(e) {
        currentImages = [];
    }
    
    // Remove from array
    currentImages = currentImages.filter(img => img.id != imageId);
    imageInput.val(JSON.stringify(currentImages));
    
    // Remove preview
    $(this).parent().remove();
});

// Add styles for image previews
var style = document.createElement('style');
style.textContent = `
    .recipe-images-container {
        margin-top: 10px;
    }
    .recipe-image-list {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-bottom: 10px;
    }
    .recipe-image-preview {
        position: relative;
        width: 100px;
        height: 100px;
        border: 1px solid #ddd;
        border-radius: 4px;
        overflow: hidden;
    }
    .recipe-image-preview img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    .remove-image {
        position: absolute;
        top: 5px;
        right: 5px;
        background: rgba(255, 0, 0, 0.8);
        color: white;
        border: none;
        border-radius: 50%;
        width: 20px;
        height: 20px;
        line-height: 20px;
        text-align: center;
        cursor: pointer;
        padding: 0;
        font-size: 14px;
    }
    .remove-image:hover {
        background: rgba(255, 0, 0, 1);
    }
`;
document.head.appendChild(style);

// Mevcut resimleri yükle (edit modunda)
$(document).on('show.bs.modal', '#dnModal', function() {
    var recipeImages = $('#recipe_images').val();
    if (recipeImages) {
        try {
            var images = JSON.parse(recipeImages);
            var imageList = $('#recipe-image-list');
            imageList.empty();
            
            images.forEach(function(image) {
                var imagePreview = $('<div>', {
                    class: 'recipe-image-preview'
                }).html(`
                    <img src="${image.url}" alt="">
                    <button type="button" class="remove-image" data-id="${image.id}">×</button>
                `);
                imageList.append(imagePreview);
            });
        } catch(e) {
            console.error('Error loading existing images:', e);
        }
    }
});
</script>