<?php
if (!defined('ABSPATH')) {
    exit; // Güvenlik önlemi
}

// Düzenleme modunda mı?
$block_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$block = null;

if ($block_id) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'blocks';
    $block = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $block_id));
}
?>

<!--<script src="http://wp1.test/wp-content/plugins/dn-blocks/scripts/font-awesome/js/fontawesome.js" id="fontawesome-js"></script>-->
<!--<link rel='stylesheet' href='http://wp1.test/wp-content/plugins/dn-blocks/scripts/font-awesome/css/fontawesome.css' media='all' />-->

<link rel='stylesheet' id='jquery-ui-css-css' href='https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css?ver=6.7.1' media='all' />
<link rel='stylesheet' id='bootstrap-css-css' href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css?ver=5.3.2' media='all' />
<link rel='stylesheet' id='iconpicker-css' href='http://wp1.test/wp-content/plugins/dn-blocks/scripts/menu-editor/css/bootstrap-iconpicker.min.css?ver=6.7.1' media='all' />

<style>
    .panel {
        margin-bottom: 18px;
        background-color: #fff;
        border: 1px solid transparent;
        border-radius: 3px;
        -webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);
        box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);
    }
    .panel-default {
        box-shadow: 0 1px 2px rgba(0, 0, 0, .05);
        background-color: #fff;
        background-clip: border-box;
        border: 1px solid rgba(0, 0, 0, .125);
        border-radius: 2px;
    }
    .panel-default .panel-heading {
        border-radius: 2px 2px 0 0;
        padding: 20px;
        margin-bottom: 0;
        color: #4c4d5a;
        border-color: #dcdcdc;
        background: #f6f6f6;
        text-shadow: 0 -1px 0 rgba(50, 50, 50, 0);
        border-bottom: 1px solid #ededed;
    }
    .panel-default .panel-heading .panel-title {
        margin-bottom: 0;
        font-size: 20px;
        font-weight: 400;
    }
    .panel-heading h3 {
        font-weight: 500;
        display: inline-block;
    }
    .panel-title {
        margin-top: 0;
        margin-bottom: 0;
        font-size: 15px;
        color: inherit;
    }

    .panel-footer {
        padding: 12px 15px;
        background-color: #f5f5f5;
        border-top: 1px solid #ddd;
        border-bottom-right-radius: 2px;
        border-bottom-left-radius: 2px;
    }

    .control-label {
        text-align: right;
        margin-bottom: 0;
        font-weight: 600;
        padding-top: 5px;
        font-size: 15px;
    }

    .form-group + .form-group {
        border-top: 1px solid #ededed;
    }

    .form-horizontal .form-group {
        margin-left: -15px;
        margin-right: -15px;
    }
    
    .form-group {
        padding-top: 15px;
        padding-bottom: 15px;
        margin-bottom: 0;
    }
    input[type=date], input[type=datetime-local], input[type=datetime], input[type=email], input[type=month], input[type=number], input[type=password], input[type=search], input[type=tel], input[type=text], input[type=time], input[type=url], input[type=week] {
        padding: 0 8px;
        line-height: 2;
        min-height: 30px;
        font-size: 15px;
        border-radius: 0;
    }

    .btn {
        border-radius: 0;
    }
    .btn-primary {
        border-color: #37464e;
        background-color: #37464e;
        color: #ffffff;
    }
    .btn-primary:hover, .btn-primary:focus {
        border-color: #27373f;
        background-color: #27373f;
        color: #ffffff;
    }
</style>

<div class="wrap">
    <h1 class="mb-3"><?php echo $block ? 'Edit Block ('.esc_attr($block->title ?? '').')' : 'New Block'; ?></h1>
    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
        <input type="hidden" name="action" value="dn_save_block">
        <input type="hidden" name="block_id" value="<?php echo esc_attr($block_id); ?>">
        <?php wp_nonce_field('dn_save_block_nonce', 'dn_save_block_nonce_field'); ?>


        <div class="panel panel-default">

            <div class="panel-heading">
                <h3 class="panel-title"><div data-code="f464" class="dashicons dashicons-edit"></div></h3>
            </div>

            <div class="panel-body">
                <form action="" method="post" enctype="multipart/form-data" id="form-menu" class="form-horizontal">
                    <fieldset>
                        <div class="form-group row required">
                            <label class="col-sm-2 control-label" for="input-name">Modül Adı</label>
                            <div class="col-sm-10">
                                <input type="text" name="name" value="" placeholder="Modül Adı" id="input-name" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-title">Başlık</label>
                            <div class="col-sm-10">
                                <input type="text" name="title" value="" placeholder="Başlık" id="input-title" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-description">Açıklama</label>
                            <div class="col-sm-10">
                                <input type="text" name="description" value="" placeholder="Açıklama" id="input-description" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-description2">Açıklama2</label>
                            <div class="col-sm-10">
                                <input type="text" name="description2" value="" placeholder="Açıklama2" id="input-description2" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row required">
                            <label class="col-sm-2 control-label" for="input-language_id">Dil</label>
                            <div class="col-sm-10">
                                <select name="language_id" id="input-language_id" class="form-control">
                                    <option value="1">Türkçe</option>
                                    <option value="2" selected="selected">English</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-view">Görünüm</label>
                            <div class="col-sm-10">
                                <select name="view" id="input-view" class="form-control">
                                    <option value="box">Box</option>
                                    <option value="slide" selected="selected">Slide</option>
                                    <option value="full_width">Full Width</option>
                                    <option value="flex">Flex</option>
                                    <option value="left_two_image_right_text_and_image">Left Two Image Right Text And Image</option>
                                    <option value="left_video_right_two_image">Left Video  Right Two Image</option>
                                    <option value="royal_denim_collection">Royal Denim Collection</option>
                                    <option value="top_content_bottom_slider">Top Content Bottom Slider</option>
                                    <option value="instagram">Instagram</option>
                                    <option value="top_two_image_bottom_content">Top Two Image Bottom Content</option>
                                    <option value="left_content_right_slide">Left Content Right Slide</option>
                                    <option value="top_video_bottom_image">Top Video Bottom Image</option>
                                    <option value="left_video_right_content">Left Video Right Content</option>
                                    <option value="top_image_bottom_content">Top Image Bottom Content</option>
                                    <option value="button_and_title_over_image">Button And Title Over Image</option>
                                    <option value="full_width_only_image">Full Width Only Image</option>
                                    <option value="royal_denim_division">Royal Denim Division</option>
                                    <option value="kubilay_aka_collection">Kubilay Aka Koleksiyonu</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-btn_background">Buton Renk</label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <input type="color" name="btn_background" value="#fafafa" id="input-btn_background" class="form-control">
                                    <span class="input-group-btn">
                                    <button type="button" class="btn btn-primary" onclick="$('[name=btn_background]').val('#fafafa'); return false;">Kaldır</button>
                                </span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-button_link">Buton Link</label>
                            <div class="col-sm-10">
                                <input type="text" name="button_link" value="Link" placeholder="Buton Link" id="input-button-link" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-button_link">Buton Yazı</label>
                            <div class="col-sm-10">
                                <input type="text" name="button_text" value="" placeholder="Buton Yazı" id="input-button-text" class="form-control">
                            </div>
                        </div>


                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-marquee">Üst Animasyon</label>
                            <div class="col-sm-10">
                                <select name="marquee" id="input-marquee" class="form-control">
                                    <option value="1">Açık</option>
                                    <option value="0" selected="selected">Kapalı</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-image_width">Görsel Genişlik</label>
                            <div class="col-sm-10">
                                <input type="text" name="image_width" value="" placeholder="Görsel Genişlik" id="input-image-width" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-image_height">Görsel Yükseklik</label>
                            <div class="col-sm-10">
                                <input type="text" name="image_height" value="" placeholder="Görsel Yükseklik" id="input-image-width" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-mobile-image-width">Mobil Görsel Genişlik</label>
                            <div class="col-sm-10">
                                <input type="text" name="mobile_image_width" value="" placeholder="Mobil Görsel Genişlik" id="input-mobile-image-width" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-mobile-image-height">Mobil Görsel Yükseklik</label>
                            <div class="col-sm-10">
                                <input type="text" name="mobile_image_height" value="" placeholder="Mobil Görsel Yükseklik" id="input-mobile-image-height" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 control-label" for="input-status">Durum</label>
                            <div class="col-sm-10">
                                <select name="status" id="input-status" class="form-control">
                                    <option value="1" selected="selected">Açık</option>
                                    <option value="0">Kapalı</option>
                                </select>
                            </div>
                        </div>
                    </fieldset>
                    <div class="form-group row d-none">
                        <div class="col-sm-12">
                            <textarea id="data" name="banner_data" class="form-control">[{"text":"New Arrival","href":"/yenisezon","icon":"fa fa-calendar-plus-o","target":"_self","title":"","sub_text":"Discover More","image":"catalog/slider/yenisezon.webp","text2":"","mobile_image":"","text3":"","downloads":"","video_poster":"","sticker":""},{"text":"SWEAT","href":"/sweatshirt","icon":"fa fa-500px","target":"_self","title":"","sub_text":"Discover More","image":"catalog/slider/sweat.jpg","text2":"","text3":"","downloads":"","video_poster":"","sticker":"","mobile_image":""},{"text":"Coat","href":"/mont-ceket","icon":"fa fa-500px","target":"_self","title":"","sub_text":"Discover More","image":"catalog/slider/mont.jpg","text2":"","text3":"","downloads":"","video_poster":"","sticker":"","mobile_image":""}]</textarea>
                        </div>
                    </div>
                </form>
            </div>

            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-2"></div>
                    <div class="col-md-10">
                        <button type="button" class="btn btn-primary modal-show"><i class="fa fa-plus"></i> BANNER EKLE</button>
                    </div>
                </div>
            </div>

        </div>

        <table class="form-table">
            <tr>
                <th><label for="title">Block Title</label></th>
                <td><input type="text" name="title" id="title" class="regular-text" value="<?php echo esc_attr($block->title ?? ''); ?>" required></td>
            </tr>
            <tr>
                <th><label for="subtitle">Subtitle</label></th>
                <td><input type="text" name="subtitle" id="subtitle" class="regular-text" value="<?php echo esc_attr($block->subtitle ?? ''); ?>"></td>
            </tr>
            <tr>
                <th><label for="link_text">Link Text</label></th>
                <td><input type="text" name="link_text" id="link_text" class="regular-text" value="<?php echo esc_attr($block->link_text ?? ''); ?>"></td>
            </tr>
            <tr>
                <th><label for="link_url">Link URL</label></th>
                <td><input type="url" name="link_url" id="link_url" class="regular-text" value="<?php echo esc_attr($block->link_url ?? ''); ?>"></td>
            </tr>
            <tr>
                <th><label for="block_type">Block Type</label></th>
                <td>
                    <select name="block_type" id="block_type">
                        <option value="text" <?php selected($block->block_type ?? '', 'text'); ?>>Text</option>
                        <option value="image" <?php selected($block->block_type ?? '', 'image'); ?>>Image</option>
                        <option value="video" <?php selected($block->block_type ?? '', 'video'); ?>>Video</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th><label for="status">Status</label></th>
                <td>
                    <select name="status" id="status">
                        <option value="1" <?php selected($block->status ?? '', '1'); ?>>Active</option>
                        <option value="0" <?php selected($block->status ?? '', '0'); ?>>Inactive</option>
                    </select>
                </td>
            </tr>
        </table>

        <input type="submit" class="button button-primary" value="Save Block">
    </form>
</div>

<div>
    <ul id="myEditor" class="sortableLists list-group">
        <li class="list-group-item pr-0">
            <div style="overflow: auto;">
                <i class="fa fa-calendar-plus-o"></i>&nbsp;<span class="txt btn" style="margin-right: 5px;">New Arrival</span>
                <div class="btn-group pull-right">
                    <a class="btn btn-secondary btnUp btnMove clickable" href="#" style="display: none;"><i class="fa fa-angle-up clickable"></i></a>
                    <a class="btn btn-secondary btnDown btnMove clickable" href="#"><i class="fa fa-angle-down clickable"></i></a>
                    <a class="btn btn-secondary btnIn btnMove clickable" href="#" style="display: none;"><i class="fa fa-level-up clickable"></i></a>
                    <a class="btn btn-secondary btnOut btnMove clickable" href="#" style="display: none;"><i class="fa fa-level-down clickable"></i></a>
                    <a class="btn btn-primary btnEdit clickable" href="#"><i class="fa fa-edit clickable"></i></a><a class="btn btn-danger btnRemove clickable" href="#"><i class="fa fa-trash-o clickable"></i></a>
                </div>
            </div>
        </li>
        <li class="list-group-item pr-0">
            <div style="overflow: auto;">
                <i class="fa fa-500px"></i>&nbsp;<span class="txt btn" style="margin-right: 5px;">SWEAT</span>
                <div class="btn-group pull-right">
                    <a class="btn btn-secondary btnUp btnMove clickable" href="#"><i class="fa fa-angle-up clickable"></i></a><a class="btn btn-secondary btnDown btnMove clickable" href="#"><i class="fa fa-angle-down clickable"></i></a>
                    <a class="btn btn-secondary btnIn btnMove clickable" href="#"><i class="fa fa-level-up clickable"></i></a>
                    <a class="btn btn-secondary btnOut btnMove clickable" href="#" style="display: none;"><i class="fa fa-level-down clickable"></i></a>
                    <a class="btn btn-primary btnEdit clickable" href="#"><i class="fa fa-edit clickable"></i></a><a class="btn btn-danger btnRemove clickable" href="#"><i class="fa fa-trash-o clickable"></i></a>
                </div>
            </div>
        </li>
        <li class="list-group-item pr-0">
            <div style="overflow: auto;">
                <i class="fa fa-500px"></i>&nbsp;<span class="txt btn" style="margin-right: 5px;">Coat</span>
                <div class="btn-group pull-right">
                    <a class="btn btn-secondary btnUp btnMove clickable" href="#"><i class="fa fa-angle-up clickable"></i></a>
                    <a class="btn btn-secondary btnDown btnMove clickable" href="#" style="display: none;"><i class="fa fa-angle-down clickable"></i></a>
                    <a class="btn btn-secondary btnIn btnMove clickable" href="#"><i class="fa fa-level-up clickable"></i></a>
                    <a class="btn btn-secondary btnOut btnMove clickable" href="#" style="display: none;"><i class="fa fa-level-down clickable"></i></a>
                    <a class="btn btn-primary btnEdit clickable" href="#"><i class="fa fa-edit clickable"></i></a><a class="btn btn-danger btnRemove clickable" href="#"><i class="fa fa-trash-o clickable"></i></a>
                </div>
            </div>
        </li>
    </ul>

</div>



<!-- Modal -->
<div class="modal fade" id="dnModal" tabindex="-1" aria-labelledby="dnModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="dnModalLabel">Yeni Blok Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="frmEdit">
                    <fieldset>
                        <div class="form-group" style="padding-top: 0">
                            <label>Başlık</label>
                            <input type="text" class="form-control item-menu" name="text" id="text" placeholder="Başlık">
                        </div>

                        <div class="form-group">
                            <label>Alt Başlık (Opsiyonel)</label>
                            <input type="text" class="form-control item-menu" name="text2" id="text2" placeholder="Alt Başlık">
                        </div>

                        <div class="form-group">
                            <label>Alt Başlık (Opsiyonel)</label>
                            <input type="text" class="form-control item-menu" name="text3" id="text3" placeholder="Alt Başlık">
                        </div>

                        <div class="form-group">
                            <label>Buton Başlık</label>
                            <input type="text" class="form-control item-menu" name="sub_text" id="sub_text" placeholder="Buton Başlık">
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-12 col-sm-8">
                                    <label>Hedef Url</label>
                                    <input type="text" class="form-control item-menu" name="href" id="href" placeholder="Hedef Url" autocomplete="off"><ul class="dropdown-menu"></ul>
                                </div>
                                <div class="col-12 col-sm-4">
                                    <label>Target</label>
                                    <select name="target" id="target" class="form-control item-menu">
                                        <option value="_self">Geçerli Sekme</option>
                                        <option value="_blank">Yeni Sekme</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <div class="form-group">
                            <label>Görsel</label>
                            <div class="input-group">
                                <input type="text" name="image" id="image" value="" placeholder="Görsel" class="form-control item-menu">
                                <span class="input-group-btn">
                                    <button type="button" onclick="mediaFrame('image')" class="btn btn-primary"><i data-code="f464" class="dashicons dashicons-edit"></i></button>
                                </span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label>Mobil Görsel (Opsiyonel)</label>
                            <div class="input-group">
                                <input type="text" name="mobile_image" id="mobile_image" value="" placeholder="Mobil Görsel" class="form-control item-menu">
                                <span class="input-group-btn">
                                    <button type="button" onclick="mediaFrame('mobile_image')" class="btn btn-primary"><i data-code="f464" class="dashicons dashicons-edit"></i></button>
                                </span>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                <button type="button" id="btnUpdate" class="btn btn-primary" disabled="disabled">Güncelle</button>
                <button type="button" id="btnAdd" class="btn btn-success">Ekle</button>
            </div>
        </div>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.7.1.js"></script>
<script src="http://wp1.test/wp-content/plugins/dn-blocks/scripts/menu-editor/js/bootstrap-iconpicker.min.js?ver=6.7.1" id="iconpicker-js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js?ver=5.3.2" id="bootstrap-js-js"></script>
<script src="http://wp1.test/wp-content/plugins/dn-blocks/scripts/menu-editor/jquery-menu-editor.js?ver=6.7.1" id="jquery-menu-editor-js-js"></script>

<!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/davicotico/Menu-Editor@1.1.0/dist/styles.min.css">-->
<!--<script src="https://cdn.jsdelivr.net/gh/davicotico/Menu-Editor@1.1.0/dist/menu-editor.min.js"></script>-->
<script>
    const editor_data = [{"text":"New Arrival","href":"/yenisezon","icon":"fa fa-calendar-plus-o","target":"_self","title":"","sub_text":"Discover More","image":"catalog/slider/yenisezon.webp","text2":"","mobile_image":"","text3":"","downloads":"","video_poster":"","sticker":""},{"text":"SWEAT","href":"/sweatshirt","icon":"fa fa-500px","target":"_self","title":"","sub_text":"Discover More","image":"catalog/slider/sweat.jpg","text2":"","text3":"","downloads":"","video_poster":"","sticker":"","mobile_image":""},{"text":"Coat","href":"/mont-ceket","icon":"fa fa-500px","target":"_self","title":"","sub_text":"Discover More","image":"catalog/slider/mont.jpg","text2":"","text3":"","downloads":"","video_poster":"","sticker":"","mobile_image":""}];


    var iconPickerOptions = {
        search: true,
        searchText: "ikon ara...",
        labelHeader: "{0}/{1}",
        iconset: 'fontawesome4',
        arrowPrevIconClass: 'fa fa-arrow-left',
        arrowNextIconClass: 'fa fa-arrow-right'
    };

    var sortableListOptions = {
        placeholderCss: {'background-color': "#cccccc"}
    };
    var editor = new MenuEditor('myEditor', {
        textData: $("#data"),
        listOptions: sortableListOptions,
        iconPicker: iconPickerOptions
    });

    editor.setData(editor_data);

    editor.setForm($('#frmEdit'));

    editor.setUpdateButton($('#btnUpdate'));


    // Modal Update
    $(document).on('click', '.btnEdit', function (e) {
        console.log("asdsad")
        $('#dnModalLabel').html('Banner Düzenle');
        $('#dnModal').modal("show");
    });

    // Modal Open
    $(document).on('click', '.modal-show', function (e) {
        console.log(1)
        $('#dnModalLabel').html('Banner Ekle');
        editor.resetForm(editor.getForm());
        $('#dnModal').modal("show");
    });


    //Calling the update method
    $("#btnUpdate").click(function () {
        editor.update();
        $('#dnModal').modal("hide")
    });

    // Calling the add method
    $('#btnAdd').click(function () {
        editor.add();
        $('#myModal').modal("hide")
    });
</script>

<script type="text/javascript">
</script>

